<div class="card mb-4">
    <div class="card-header bg-light">
        <div class="row align-items-center">
            <div class="col">
                <h5 class="mb-0">Search Student</h5>
            </div>
        </div>
    </div>
    <div class="card-body">
        <form>
            <div class="row mb-3">
                <div class="col-md-2">
                    <select name="financial_year_id" class="form-select" required>
                        <?php $__currentLoopData = $academic_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($year->id); ?>" <?php echo e(request('financial_year_id', $active_academic_year->id) == $year->id ? 'selected' : ''); ?>>
                                <?php echo e($year->label); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="class_id" id="class_id" class="form-select" required>
                        <option value="all">All Class</option>
                        <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($class->id); ?>" <?php echo e((request('class_id')==$class->id)?'selected':''); ?>>
                                <?php echo e($class->class_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="section_id"
                            id="section_id"
                            class="form-select form-select-sm"
                            <?php echo e(request('class_id') ? '' : 'disabled'); ?>>
                        <option value="">All Sections</option>

                        
                        <?php if(request('class_id')): ?>
                            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($section->id); ?>"
                                    <?php echo e(request('section_id') == $section->id ? 'selected' : ''); ?>>
                                    <?php echo e($section->section_name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <input
                        type="month"
                        name="month"
                        class="form-control form-control-sm"
                        value="<?php echo e(request()->filled('month') ? request('month') : now()->format('Y-m')); ?>"
                    >
                </div>
                <div class="col-md-4">
                    <input type="search"
                        name="q"
                        value="<?php echo e(request('q')); ?>"
                        class="form-control form-control-sm"
                        placeholder="Search by name or admission #">
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    Search & Preview
                </button>

                
                <a href="<?php echo e(url()->current()); ?>"
                class="btn btn-outline-secondary">
                    Clear Filter
                </a>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Student Fee Status</h5>
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead>
                    <tr>
                        <th>Admission #</th>
                        <th>Student Name</th>
                        <th>Class</th>
                        <th>Roll No</th>
                        <th>Due Amount</th>
                        <!-- <th>Paid</th>
                        <th>Pending</th> -->
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>#<?php echo e($student->admission_no); ?></td>
                            <td><?php echo e($student->name); ?></td>

                            <td>
                                <?php echo e($student->activeClass->class->class_name ?? '-'); ?>

                                (<?php echo e($student->activeClass->section->section_name ?? '-'); ?>)
                            </td>

                            <td><?php echo e($student->activeClass->roll_no ?? '-'); ?></td>

                            <td>₹<?php echo e(number_format($student->total_fee, 2)); ?></td>
                            <!-- <td>₹<?php echo e(number_format($student->paid_fee, 2)); ?></td>
                            <td>₹<?php echo e(number_format($student->pending_fee, 2)); ?></td> -->


                            <td>
                                <?php if($student->fee_status == 'paid'): ?>
                                    <span class="badge bg-success">Paid</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Unpaid</span>
                                <?php endif; ?>
                            </td>

                            <td>
                                <?php if($student->fee_status == 'paid'): ?>
                                    <button
                                        class="btn btn-sm btn-outline-secondary viewFeeBtn"
                                        data-student-id="<?php echo e($student->id); ?>"
                                        data-month="<?php echo e(request('month', now()->format('Y-m'))); ?>">
                                        View
                                    </button>
                                <?php else: ?>
                                    <button
                                        class="btn btn-sm btn-outline-primary collectFeeBtn"
                                        data-student-id="<?php echo e($student->id); ?>"
                                        data-month="<?php echo e(request('month', now()->format('Y-m'))); ?>">
                                        Collect
                                    </button>
                                <?php endif; ?>
                            </td>

                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center text-muted">
                                No students found
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        
        <div class="mt-3">
            <?php echo e($students->links()); ?>

        </div>
    </div>
</div>
<?php /**PATH C:\xampp\htdocs\school\resources\views/student_fees/list.blade.php ENDPATH**/ ?>