<div class="card mb-4">
    <div class="card-header bg-light">
        <h5 class="mb-0">Add New Fee Head</h5>
    </div>
    <div class="card-body">
        <form method="POST" action="{{ route('fees.storeFeeHead') }}">
            @csrf
            <div class="row">
                <div class="col-md-5">
                    <input type="text" name="name" class="form-control" placeholder="Fee Head Name" required>
                </div>
                <div class="col-md-5">
                    <input type="text" name="description" class="form-control" placeholder="Description" required>
                </div>
                <div class="col-md-2">
                    <button class="btn btn-primary w-100">Add</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Fee Heads List</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-sm">
                <thead>
                    <tr>
                        <th>Fee Head Name</th>
                        <th>Description</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($feeHeads as $fee)
                    <tr>
                        <td>{{ $fee->name }}</td>
                        <td>{{ $fee->description }}</td>
                        <!-- <td>₹{{ number_format($fee->amount, 2) }}</td> -->
                        <td>
                            <div class="form-check form-switch">
                                <input
                                    class="form-check-input fee-status"
                                    type="checkbox"
                                    id="status_{{ $fee->id }}"
                                    data-id="{{ $fee->id }}"
                                    data-url="{{ route('fees.updateFeeHead', $fee->id) }}"
                                    {{ $fee->status ? 'checked' : '' }}
                                >
                            </div>
                        </td>
                        <td>
                            <button
                                type="button"
                                class="btn btn-sm btn-outline-primary edit-fee-head"
                                data-id="{{ $fee->id }}"
                                data-name="{{ $fee->name }}"
                                data-description="{{ $fee->description }}"
                            >
                                Edit
                            </button>


                            <!-- Delete Button -->
                            <!-- <form action="{{ route('fees.deleteFeeHead', $fee->id) }}"
                                method="POST"
                                class="d-inline delete-form">
                                @csrf
                                @method('DELETE')
                                <button type="button" class="btn btn-sm btn-outline-danger btn-delete">
                                    Delete
                                </button>
                            </form> -->

                            <button
                                type="button"
                                class="btn btn-sm btn-outline-danger deleteFeeHeadBtn"
                                data-url="{{ route('fees.deleteFeeHead', $fee->id) }}"
                            >
                                Delete
                            </button>


                        </td>
                    </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted">
                                No fee head found!
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-end mt-3">
            {{ $feeHeads->appends(['tab' => $tab])->links() }}
        </div>
    </div>
</div>

