<?php $__env->startSection('content'); ?>
    <div class="col-span-12 lg:col-span-12">
        <div class="flex justify-between mt-5">
            <h2 class="text-lg font-medium mr-auto">
                Users
            </h2>

            <?php
                $menuId = \App\Models\Menu::where('route', 'users.index')->value('id');
                $permissionService = app(\App\Services\PermissionService::class);

            ?>
            <?php if($permissionService->hasPermission($menuId, 'w')): ?>
                <div class="w-full sm:w-auto flex mt-4 sm:mt-0 ">
                    <a href="<?php echo e(route('users.create')); ?>">
                        <button class="button text-white bg-theme-1 shadow-md">
                            Add User
                        </button>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
    </div>
    <!-- BEGIN: HTML Table Data -->
    <div class="intro-y box p-5 mt-5">

        <?php if(session('success')): ?>
            <div class="rounded-md flex items-center px-5 py-4 mb-2 border border-theme-9 text-theme-9 dark:border-theme-9">
                <?php echo e(session('success')); ?>

            </div>
        <?php elseif(session('error')): ?>
            <div class="rounded-md flex items-center px-5 py-4 mb-2 border border-theme-6 text-theme-6 dark:border-theme-6">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>




        <div class="flex flex-col sm:flex-row sm:items-end xl:items-start">
            <form class="xl:flex w-full" id="tabulator-html-filter-form">

                <div class="sm:flex items-center justify-between w-full">
                    <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center gap-2 flex-wrap">
                            <label for="page-size" class="form-label mb-0">Data Per Page</label>
                            <select id="page-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                                
                                <option value="10">10</option>
                                <option value="30">30</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                            </select>
                        </div>
                    </div>
                    <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center flex-wrap">
                            <label for="org-size" class="form-label mb-0">Users as per Organisation:</label>
                            <select id="org-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                                <option value="">All Users</option>
                                <?php $__currentLoopData = $organisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $organisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($organisation->organisation_id); ?>">
                                        <?php echo e($organisation->organisation_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                        </div>
                    </div>
                    &nbsp; &nbsp; &nbsp;
                    <div>
                        <input type="text" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" id="search-string"
                            placeholder="Search...">
                    </div>

                </div>

            </form>
        </div>
        <div class="overflow-x-auto scrollbar-hidden">
            <div class="mt-5 table-report table-report--tabulator" id="users-table"></div>
        </div>
    </div>
    <!-- END: HTML Table Data -->

    <link href="<?php echo e(asset('build/assets/css/tabulator.min.css')); ?>" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tabulator/6.3.1/css/tabulator_materialize.min.css" rel="stylesheet">
    <script type="text/javascript" src="https://unpkg.com/tabulator-tables@6.3.1/dist/js/tabulator.min.js"></script>


    <script>
        var canRead = <?php echo json_encode($permissionService->hasPermission($menuId, 'r'), 512) ?>;
        var canWrite = <?php echo json_encode($permissionService->hasPermission($menuId, 'w'), 512) ?>;
        var canExecute = <?php echo json_encode($permissionService->hasPermission($menuId, 'x'), 512) ?>;

        var table = new Tabulator("#users-table", {
            ajaxURL: "<?php echo e(route('users.details')); ?>",
            ajaxParams: function() {
                return {
                    _token: document.querySelector('meta[name="csrf-token"]').getAttribute("content"),
                    search: document.querySelector("#search-string").value,
                    organisation_id: document.querySelector("#org-size").value,
                };
            },
            ajaxConfig: "POST",
            layout: "fitColumns",
            theme: "bootstrap5",
            paginationMode: "remote",
            pagination: true,
            paginationSize: 10,
            paginationSizeSelector: false,
            layout: "fitColumns",
            responsiveLayout: "collapse",
            ajaxProgressiveLoad: "scroll",
            ajaxLoaderLoading: "<span>Loading Data... Please Wait</span>",
            placeholder: "<span style='color: red; font-size: 16px; font-weight: bold;'>No Data Available</span>",
            search: true,
            movableRows: true,
            movableColumns: true,
            columnDefaults: {
                tooltip: true,
            },
            columns: [{
                    title: "SL",
                    hozAlign: "center",
                    formatter: function(cell, formatterParams, onRendered) {
                        let row = cell.getRow();
                        let data = row.getData();
                        let page = table.getPage();
                        let perPage = table.getPageSize();

                        if (!page) page = 0;
                        if (!perPage) perPage = 10;

                        return ((row.getPosition(true) + 1) + ((page - 1) * perPage) - 1);
                    },
                    maxWidth: 80
                },
                {
                    title: "Name",
                    field: "name",
                    hozAlign: "center",
                    headerSort: true,
                    // maxWidth: 200
                },
                {
                    title: "Email",
                    field: "email",
                    hozAlign: "center",
                    headerSort: true,
                    // maxWidth: 400
                },
                {
                    title: "Role",
                    field: "role.name",
                    hozAlign: "center",
                    headerSort: true,
                    maxWidth: 130
                },
                {
                    title: "Status",
                    field: "status",
                    headerSort: false,
                    hozAlign: "center",
                    visible: canExecute,
                    // maxWidth: 150,
                    formatter: function(cell) {
                        const rowData = cell.getRow().getData();

                        let badgeClass = "badge bg-secondary";
                        if (rowData.status === "active") {
                            badgeClass =
                                "status-toggle button w-24 rounded-full mr-1 mb-2 bg-theme-9 text-white"

                        } else if (rowData.status === "inactive") {
                            badgeClass =
                                "status-toggle button w-24 rounded-full mr-1 mb-2 bg-theme-6 text-white";
                        }

                        return `
                           <div class="flex justify-center">
                            <span class="status-toggle ${badgeClass}" 
                                data-id="${rowData.id}" 
                                style="cursor:pointer;">
                                ${rowData.status}
                            </span>
                            </div>
                        `;
                    },
                    cellClick: function(e, cell) {
                        // if (!canExecute) return;
                        const id = cell.getRow().getData().id;
                        console.log(id);
                        const currentStatus = cell.getRow().getData().status;
                        const newStatus = currentStatus === "active" ? "inactive" : "active";

                        Swal.fire({
                            title: "Are you sure?",
                            text: `You are about to change status to "${newStatus}".`,
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonText: "Yes",
                            cancelButtonText: "No",
                            customClass: {
                                confirmButton: "btn btn-success",
                                cancelButton: "btn btn-danger"
                            },
                            buttonsStyling: true
                        }).then((result) => {
                            if (result.isConfirmed) {
                                fetch(`/users/${id}/status`, {
                                        method: "POST",
                                        headers: {
                                            "X-CSRF-TOKEN": document.querySelector(
                                                'meta[name="csrf-token"]').content,
                                            "Content-Type": "application/json",
                                        }
                                    })
                                    .then(res => res.json())
                                    .then(data => {
                                        if (data.success) {
                                            cell.getRow().update({
                                                status: data.status
                                            });
                                            Swal.fire("Success!",
                                                "Status updated successfully.", "success");
                                        } else {
                                            Swal.fire("Error!", data.message ??
                                                "Something went wrong.", "error");
                                        }
                                    })
                                    .catch(() => {
                                        Swal.fire("Error!", "Something went wrong.", "error");
                                    });
                            }
                        });
                    }
                },
                {
                    title: "Action",
                    headerSort: false,
                    maxWidth: 620,
                    headerHozAlign: "center",
                    visible: canExecute,
                    formatter: function(cell) {
                        let rowData = cell.getRow().getData();
                        let html = `
                            <div class="flex justify-center items-center">
                              `;

                        if (canExecute && rowData.role_id !== 1) {
                            html += `
                              <span data-action="permissions" data-toggle="tooltip" data-original-title="Set Permissions"> 
                                    <a class="flex items-center mr-3">
                                         <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                            stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"
                                            class="feather feather-unlock w-4 h-4 mr-1">
                                            <rect x="3" y="11" width="18" height="11" rx="2" ry="2"/>
                                            <path d="M7 11V7a5 5 0 0 1 10 0"/>
                                        </svg>
                                    </a>
                                </span>
                                 <span data-action="edit" data-toggle="tooltip" data-original-title="Edit user">
                                    <a class="flex items-center mr-3"> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-check-square w-4 h-4 mr-1"><polyline points="9 11 12 14 22 4"></polyline><path d="M21 12v7a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11"></path></svg>  </a>
                                </span>
                                              `;
                        }
                        // if (canExecute && rowData.role_id !== 1) {
                        //     html += `
                    //        <span class="action-link text-danger font-weight-bold text-xs" data-action="delete" data-toggle="tooltip" data-original-title="Delete user">
                    //             <a class="flex items-center text-theme-6" data-toggle="modal" data-target="#delete-confirmation-modal"> <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2 w-4 h-4 mr-1"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg>  </a>
                    //         </span>
                    //                       `;
                        // }

                        return html;
                    },
                    cellClick: function(e, cell) {
                        const rowData = cell.getRow().getData();
                        const actionEl = e.target.closest('[data-action]');
                        const action = actionEl ? actionEl.dataset.action : null;

                        if (action === "permissions") {
                            console.log("Row Data:", rowData);
                            let encodedId = btoa(rowData.id);
                            window.location.href = "/users/permissions/" + encodedId;

                        } else if (action === "edit") {
                            console.log("Row Data:", rowData);
                            let encodedId = btoa(rowData.id);
                            window.location.href = "/users/edit/" + encodedId;

                        }
                        // else if (action === "delete") {
                        //     const swalWithBootstrapButtons = Swal.mixin({
                        //         customClass: {
                        //             confirmButton: "btn btn-success",
                        //             cancelButton: "btn btn-danger"
                        //         },
                        //         buttonsStyling: false
                        //     });
                        //     swalWithBootstrapButtons.fire({
                        //         title: "Are you sure?",
                        //         text: `You want to delete the team member named "${rowData.name}"`,
                        //         icon: "warning",
                        //         showCancelButton: true,
                        //         confirmButtonText: "Yes, delete it!",
                        //         cancelButtonText: "No, cancel!",
                        //         reverseButtons: true
                        //     }).then((result) => {
                        //         if (result.isConfirmed) {
                        //             $.ajax({
                        //                 type: "POST",
                        //                 url: "<?php echo e(route('users.destroy')); ?>",
                        //                 dataType: 'json',
                        //                 data: {
                        //                     id: rowData.id,
                        //                     _token: '<?php echo e(csrf_token()); ?>'
                        //                 },
                        //                 success: function(response) {
                        //                     if (response.status == true) {
                        //                         toastr.success("Deleted Successfully",
                        //                             "Success", toastrProperties);
                        //                         setTimeout(() => {
                        //                             table.setData();
                        //                         }, 400)
                        //                     } else {
                        //                         toastr.error(
                        //                             "Error! Please try after some time",
                        //                             "Error", toastrProperties);
                        //                     }
                        //                 },
                        //                 error: function(error) {
                        //                     console.log(error);
                        //                 }
                        //             });

                        //         }
                        //     });
                        // }
                    }
                }
            ],
            ajaxResponse: function(url, params, response) {
                return {
                    data: response.data,
                    last_page: response.last_page,
                    current_page: response.current_page,
                    total: response.total
                };
            }
        });
        document.getElementById("page-size").addEventListener("change", function() {
            table.setPageSize(Number(this.value));
        });
        document.getElementById("org-size").addEventListener("change", function() {
            table.setData();
        });
        document.getElementById("search-string").addEventListener("input", function() {
            table.setData();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/ramakrishna-sevashram/resources/views/auth/users/index.blade.php ENDPATH**/ ?>