<?php $__env->startSection('content'); ?>
<div class="intro-y col-span-12 lg:col-span-12">
    <div class="intro-y box mt-5">
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    Member Donation
                </h2>
            </div>

            <form id="donationForm" method="POST" enctype="multipart/form-data" class="pb-4">
                <?php echo csrf_field(); ?>
                <div class="member-add-boxarea p-5" id="dynamic-fields">
                    <div id="donation-rows" class="space-y-2 member-add-boxscroll">
                        <div class="donation-mamber-wraper">
                            <!-- Fixed Donor -->
                            <input type="hidden" name="members[]" value="<?php echo e($donor->donor_id); ?>">
                            <input type="text" class="input border flex-1 bg-gray-100"
                                value="<?php echo e(ucwords(strtolower($donor->donor_name))); ?>" disabled>

                            <!-- Income Head Dropdown -->
                            <select name="income_heads[]" class="input border flex-1">
                                <option value="">-- Select Income Head --</option>
                                <?php $__currentLoopData = $incomeHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($head->income_head_id); ?>">
                                    <?php echo e(ucwords(strtolower($head->income_head_name))); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            <!-- Amount -->
                                <input type="text" name="amounts[]" class="input border flex-1" placeholder="Amount">

                                <select id="payment_type_id" name="payment_type_id[]"
                                    class="input border flex-1">
                                    <option value="">-- Select Payment Type --</option>

                                    <?php $__currentLoopData = $paymentTypes->where('parent_id', null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                    $children = $paymentTypes->where(
                                    'parent_id',
                                    $parent->id,
                                    );
                                    ?>

                                    <?php if($children->isEmpty()): ?>
                                    <option value="<?php echo e($parent->id); ?>"
                                        <?php echo e(old('payment_type_id') == $parent->id ? 'selected' : ''); ?>>
                                        <?php echo e($parent->name); ?>

                                    </option>
                                    <?php else: ?>
                                    <optgroup label="<?php echo e($parent->name); ?>">
                                        <?php $__currentLoopData = $children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($child->id); ?>"
                                            <?php echo e(old('payment_type_id') == $child->id ? 'selected' : ''); ?>>
                                            <?php echo e($child->name); ?>

                                        </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </optgroup>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>

                                <div class="text-red-500 text-sm mt-1 error-message"
                                    id="error-payment-type"></div>

                            <!-- Action Buttons -->
                            <div class="button-box">
                                <button type="button" class="btn-add bg-green-500 text-white px-3 rounded">+</button>
                            </div>
                            <!-- <button type="button" class="btn-remove bg-red-500 text-white px-3 rounded">-</button> -->
                        </div>

                    </div>
                </div>

                <div class="sm:pl-5 mt-5">
                    <a href="<?php echo e(route('donor.index')); ?>">
                        <span class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600 mr-2">
                            ← Back
                        </span>
                    </a>
                    <button type="submit" class="button w-24 bg-theme-1 text-white">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        const container = document.getElementById("donation-rows");
        const maxRows = 10;
        const donorId = "<?php echo e($donor->donor_id); ?>";

        function checkDBDuplicate(memberId, incomeHeadId) {
            if (!memberId || !incomeHeadId) return Promise.resolve({
                exists: false
            });

            return fetch("<?php echo e(route('donation.check')); ?>", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                    "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
                },
                body: JSON.stringify({
                    donor_id: memberId,
                    income_head_id: incomeHeadId
                })
            }).then(res => res.json());
        }

        // Prevent duplicate income head selection in form
        function disableSelectedIncomeHeads() {
            const rows = container.querySelectorAll(".donation-row");
            let selectedHeads = [];

            rows.forEach(row => {
                const income = row.querySelector("select[name='income_heads[]']").value;
                if (income) selectedHeads.push(income);
            });

            rows.forEach(row => {
                const incomeSelect = row.querySelector("select[name='income_heads[]']");
                Array.from(incomeSelect.options).forEach(option => {
                    if (selectedHeads.includes(option.value) && option.value !== incomeSelect.value) {
                        option.disabled = true;
                    } else {
                        option.disabled = false;
                    }
                });
            });
        }

        // Add / remove dynamic rows
        container.addEventListener("click", function(e) {
            if (e.target.classList.contains("btn-add")) {
                e.preventDefault();
                const rowCount = container.querySelectorAll(".donation-row").length;
                if (rowCount >= maxRows) {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Limit Reached',
                        text: 'You can only add up to ' + maxRows + ' donations at once.',
                        confirmButtonText: 'OK'
                    });
                    return;
                }

                const newRow = document.createElement("div");
                newRow.className = "donation-mamber-wraper";

                newRow.innerHTML = `
                    <input type="hidden" name="members[]" value="${donorId}">
                    <input type="text" class="input border flex-1 bg-gray-100" value="<?php echo e(ucwords(strtolower($donor->donor_name))); ?>" disabled>

                    <select name="income_heads[]" class="input border flex-1 income-head-select">
                        <option value="">-- Select Income Head --</option>
                        <?php $__currentLoopData = $incomeHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($head->income_head_id); ?>"><?php echo e($head->income_head_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                        <input type="text" name="amounts[]" class="input border flex-1" placeholder="Amount">

                                    <select id="payment_type_id" name="payment_type_id[]"
                                        class="input border flex-1">
                                        <option value="">-- Select Payment Type --</option>

                                        <?php $__currentLoopData = $paymentTypes->where('parent_id', null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                        $children = $paymentTypes->where(
                                        'parent_id',
                                        $parent->id,
                                        );
                                        ?>

                                        <?php if($children->isEmpty()): ?>
                                        <option value="<?php echo e($parent->id); ?>"
                                            <?php echo e(old('payment_type_id') == $parent->id ? 'selected' : ''); ?>>
                                            <?php echo e($parent->name); ?>

                                        </option>
                                        <?php else: ?>
                                        <optgroup label="<?php echo e($parent->name); ?>">
                                            <?php $__currentLoopData = $children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($child->id); ?>"
                                                <?php echo e(old('payment_type_id') == $child->id ? 'selected' : ''); ?>>
                                                <?php echo e($child->name); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </optgroup>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>

                                    <div class="text-red-500 text-sm mt-1 error-message"
                                        id="error-payment-type"></div>
                    <div class="button-box">
                    <button type="button" class="btn-add bg-green-500 text-white px-3 rounded">+</button>
                    <button type="button" class="btn-remove bg-red-500 text-white px-3 rounded">-</button>
                    </div>
                `;

                container.appendChild(newRow);
                disableSelectedIncomeHeads();
            }

            if (e.target.classList.contains("btn-remove")) {
                e.preventDefault();
                const rows = container.querySelectorAll(".donation-mamber-wraper");
                if (rows.length > 1) {
                    e.target.closest(".donation-mamber-wraper").remove();
                    disableSelectedIncomeHeads();
                }
            }
        });

        // Check DB + prevent duplicates when income head changes
        container.addEventListener("change", function(e) {
            if (e.target.matches("select[name='income_heads[]']")) {
                const row = e.target.closest(".donation-row");
                const incomeHeadId = row.querySelector("select[name='income_heads[]']").value;
                const amountContainer = row.querySelector(".amount-container");

                disableSelectedIncomeHeads();

                // if (donorId && incomeHeadId) {
                //     checkDBDuplicate(donorId, incomeHeadId).then(res => {
                //         if (res.exists) {
                //             amountContainer.innerHTML = `<p class="text-center text-red-500">Already Given.</p>`;
                //         } else {
                //             amountContainer.innerHTML = `<input type="number" name="amounts[]" class="input border flex-1" placeholder="Amount">`;
                //         }
                //     });
                // }
            }
        });

        container.addEventListener("input", function(e) {
            if (e.target.name === "amounts[]") {
                let val = e.target.value;

                val = val.replace(/[^0-9.]/g, ""); // allow only digits and dot

                let parts = val.split(".");
                if (parts.length > 2) {
                    val = parts[0] + "." + parts.slice(1).join(""); // remove extra dots
                }

                if (/^0[0-9]/.test(val)) {
                    val = val.replace(/^0+/, "");
                }

                if (val.startsWith("0.") || val === "0") {
                    val = val.replace(/^0+/, "");
                }

                e.target.value = val;
            }
        });

    });

    // Submit form via Ajax
    $('#donationForm').submit(function(e) {
        e.preventDefault();
        let formData = new FormData(this);

        $.ajax({
            url: "<?php echo e(route('donor.donation.store')); ?>",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success!',
                        text: response.message,
                        confirmButtonText: 'OK'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location.href = "<?php echo e(route('donor.index')); ?>";
                        }
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops!',
                        text: response.message
                    });
                }
            },
            error: function(xhr) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: xhr.responseJSON?.message || 'Something went wrong!'
                });
            }
        });
    });

    function cleanAmount(val) {
        val = val.replace(/[^0-9.]/g, "");

        let parts = val.split(".");
        if (parts.length > 2) {
            val = parts[0] + "." + parts.slice(1).join("");
        }
        if (/^0[0-9]/.test(val)) {
            val = val.replace(/^0+/, "");
        }

        if (val.startsWith("0.") || val === "0") {
            val = val.replace(/^0+/, "");
        }
        return val;
    }
    $("input[name='amounts[]']").on("input", function() {
        this.value = cleanAmount(this.value);
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/auth/donor/memberDonation.blade.php ENDPATH**/ ?>