<?php $__env->startSection('content'); ?>

<?php $final_total_funded_amount = 0; ?>

<div class="intro-y listing-table col-span-12 lg:col-span-12">

    <!-- BEGIN: Select Options -->
    <div class="intro-y box mt-5 ">
        <!-- BEGIN: Horizontal Form -->
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    Members Yearly Record
                </h2>
                <div style="display: flex; justify-content : between; align-items : center">
                    <p>
                        Membership Total Amount :
                    </p>
                    <p class="font-medium" style="padding-left: 5px;">
                        <strong>₹ <span id="final_total_funded_amount"><?php echo $final_total_funded_amount; ?></span></strong>
                    </p>
                </div>
            </div>
            <div style="margin-top: 4px;">


            </div>


            <div class="donation-list-table">

                <table class="member_donation_list">
                    <thead>
                        <tr>
                            <th rowspan="2">Member Name</th>

                            <?php
                            // Check if yearly subscription exists in income heads
                            $yearlyIncomeHead = $incomeHeads->first(function ($h) {
                            $normalized = strtolower(str_replace(' ', '', trim($h->income_head_name)));
                            return $normalized === 'yearlysubscription';
                            });
                            $yearlyIncomeHeadId = $yearlyIncomeHead->income_head_id ?? null;
                            ?>

                            <?php if($yearlyIncomeHead): ?>
                            <th colspan="2" style="text-align:center;">Yearly Subscription</th>
                            <?php endif; ?>

                            <?php $__currentLoopData = $incomeHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php
                            $normalizedHead = strtolower(str_replace(' ', '', trim($head->income_head_name)));
                            ?>

                            <?php if($normalizedHead !== 'yearlysubscription'): ?>
                            <th rowspan="2"><?php echo e(ucwords($head->income_head_name)); ?> (₹)</th>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <th rowspan="2">Total(₹)</th>
                        </tr>

                        <?php if($yearlyIncomeHead): ?>
                        <tr>
                            <th>Subscription Fee(₹)</th>
                            <th>Contingent Fee(₹)</th>
                        </tr>
                        <?php endif; ?>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $donationData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $donorId => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php

                        $incomes = $data['incomes'] ?? [];
                        $total = 0;
                        ?>
                        <tr>
                            <td><?php echo e($data['donor']->donor_name); ?></td>

                            
                            <?php if($yearlyIncomeHead): ?>
                            <?php

                            $yearlyTransactions = $incomes[$yearlyIncomeHeadId] ?? [];
                            $subscriptionSummary = $data['subscription_summary'] ?? ['subscription_total' => 0, 'contingent_total' => 0, 'is_completed' => 0];
                            $subscriptionFee = $subscriptionSummary['subscription_total'] ?? 0;
                            $contingentFee = $subscriptionSummary['contingent_total'] ?? 0;
                            $isSubscriptionCompleted = $subscriptionSummary['is_completed'] ?? 0 ;


                            $total += $subscriptionFee + $contingentFee;
                            ?>
                            <td>
                                <?php
                                    $totalPaid = $subscriptionFee + $contingentFee;
                               ?>
                                <?php if($totalPaid > 0 && $totalPaid < 500): ?>
                                    <span style="display:block;font-weight: 600;">
                                        <?php echo e(number_format($subscriptionFee, 2)); ?>

                                    </span>
                                    <button
                                        class="add-subscription-btn bg-blue-500 hover:bg-green-600 text-white text-s px-2 py-1.5 rounded absolute bottom-1 right-1"
                                        data-donor-id="<?php echo e($data['donor']->donor_id); ?>"
                                        data-income-head-id="<?php echo e($yearlyIncomeHead->income_head_id ?? ''); ?>"
                                        data-Member="<?php echo e($data['donor']->donor_name); ?>"
                                        data-remainingvalue = "<?php echo e(500 - ($subscriptionFee + $contingentFee)); ?>">
                                        +
                                    </button>
                                    

                                
                                <?php elseif($totalPaid == 0 && !$isSubscriptionCompleted): ?>
                                    <button
                                        class="add-subscription-btn bg-blue-500 hover:bg-green-600 text-white text-s px-2 py-1.5 rounded absolute bottom-1 right-1"
                                        data-donor-id="<?php echo e($data['donor']->donor_id); ?>"
                                        data-income-head-id="<?php echo e($yearlyIncomeHead->income_head_id ?? ''); ?>"
                                        data-Member="<?php echo e($data['donor']->donor_name); ?>">
                                        +
                                    </button>

                                
                                <?php elseif($totalPaid >= 500): ?>
                                    <span style="display:block;font-weight: 600;">
                                        <?php echo e(number_format($subscriptionFee, 2)); ?>

                                    </span>
                                    
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if(($subscriptionFee + $contingentFee) > 0): ?>
                                <span style="display:block;font-weight: 600;"><?php echo e(number_format($contingentFee, 2)); ?></span>
                                
                                <?php endif; ?>
                            </td>
                            <?php endif; ?>

                            
                            <?php $__currentLoopData = $incomeHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $headId = $head->income_head_id;
                            $normalizedHead = strtolower(str_replace(' ', '', trim($head->income_head_name)));
                            $transactions = $incomes[$headId] ?? [];
                            $headTotal = array_sum(array_column($transactions, 'amount'));
                            if ($normalizedHead !== 'yearlysubscription') {
                            $total += $headTotal;
                            }

                            ?>
                            <?php if($normalizedHead !== 'yearlysubscription'): ?>
                            <td>
                                <?php if(!empty($transactions)): ?>
                                <strong style="display: inline-flex;gap: 5px;align-items: center;"><?php echo e($headTotal); ?>

                                    <a class="btn" href="javascript:void(0)">
                                        <img src="<?php echo e(asset('build/assets/dist/images/problem.png')); ?>" onclick="openModal('<?php echo e($data['donor']->donor_name); ?>','<?php echo e($headTotal); ?>' ,'<?php echo e(json_encode($transactions)); ?>')" alt="Problem" style="max-width:23px;">
                                    </a>
                                </strong>
                                <?php endif; ?>
                                <button class="add-donation-btn bg-blue-500 hover:bg-green-600 text-white text-s px-2 py-1.5 rounded absolute bottom-1 right-1"
                                    data-donor-id="<?php echo e($data['donor']->donor_id); ?>"
                                    data-income-head-id="<?php echo e($headId); ?>" data-member="<?php echo e($data['donor']->donor_name); ?>">
                                    +
                                </button>
                            </td>

                            <?php if(!empty($transactions)): ?>
                            <input type="hidden" class="total_amount" value="<?php echo e($headTotal); ?>">
                            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tran): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <input type="hidden" class="amt_date" value="<?php echo e($tran['amount']); ?> (<?php echo e($tran['date']); ?>)">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>


                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <td><?php $final_total_funded_amount += $total;
                                echo $total; ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>


            </div>


        </div>

        <!-- Total amount-modal -->


        <div id="open-modal" class="modal-window" style="display:none;">
            <div class="modal-window-wraper">
                <a href="javascript:void(0)" title="Close" onclick="closeModal()" class="modal-close">x</a>

                <h4 class="modal_name">Name</h4>
                <table>
                    <tr>
                        <th style="text-align: left;">date</th>
                        <th style="text-align: right;">Amount</th>
                        <!-- <th style="text-align: right;">Payment Method</th> -->
                    </tr>
                    <tbody class="modal_body"></tbody>
                </table>


            </div>
        </div>


        <!-- Subscription Modal -->
        <div id="subscriptionModal"
            style="display:none; position:fixed; inset:0; background: rgba(0,0,0,0.5); z-index:50; justify-content:center; align-items:center;">
            <div
                style="background:white; padding:20px; padding-bottom: 10px; border-radius:8px; max-width:500px; width:100%; margin:auto; position:relative; margin-top: 4%;">
                <button id="closeModal"
                    class="close-btn">&times;</button>
                <h2 style="font-weight:bold; margin-bottom:10px;">Add Subscription</h2>
                <div style="margin-bottom:10px;">
                    <label> <strong>Member Name</strong></label>
                    <input readonly type="text" name="subscription_modal_member_name" id="subscription_modal_member_name"
                        style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px; background-color: #1c3faa47; font-weight: 600; color: #121b37;">

                    </div>
                <form id="modalSubscriptionForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="donor_id" id="modal_donor_id">
                    <input type="hidden" name="organisation_id" id="modal_organisation_id">
                    <input type="hidden" name="account_type_id" id="modal_account_type_id">
                    <input type="hidden" name="income_head_id" id="modal_income_head_id">
                    <input type="hidden" value="" id="remaing_balance">



                    <div style="margin-bottom:10px;">
                        <label>Payment Methods</label>
                        <select name="payment_type_id"
                            style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;" required>
                            <option value="">-- Select Payment Type --</option>
                            <?php $__currentLoopData = $paymentTypes->where('parent_id', null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $children = $paymentTypes->where('parent_id', $parent->id); ?>
                            <?php if($children->isEmpty()): ?>
                            <option value="<?php echo e($parent->id); ?>"><?php echo e($parent->name); ?></option>
                            <?php else: ?>
                            <optgroup label="<?php echo e($parent->name); ?>">
                                <?php $__currentLoopData = $children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($child->id); ?>"><?php echo e($child->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </optgroup>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div style="margin-bottom:10px;">
                        <label>Money Receipt No</label>
                        <input type="text" name="money_receipt_no" id="money_receipt_no" style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;">
                            <span style="color:red;" class="error_money_receipt_no"></span>
                    </div>

                    <div style="margin-bottom:10px;">
                        <label>Transaction Amount</label>
                        <input type="number" name="transaction_amount" id="transaction_amount" style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;"
                            required>
                        <span style="color:red;" class="error_transac"></span>
                    </div>

                    <div style="margin-bottom:10px;">
                        <label>Transaction Date</label>
                        <input type="date" name="transaction_date" value="<?php echo e(now()->toDateString()); ?>"
                            style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;">
                    </div>

                    <div style="margin-bottom:10px;">
                        <label>Transaction Narration</label>
                        <textarea name="transaction_narration" style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;"></textarea>
                    </div>

                    <div style="text-align:right;">
                        <button type="button" id="modalCloseBtn"
                            style="background:#ccc; padding:6px 12px; border:none; border-radius:4px; margin-right:5px; cursor:pointer;"
                            onmouseover="this.style.background='#b3b3b3'"
                            onmouseout="this.style.background='#ccc'">
                            Cancel
                        </button>
                        <button type="submit" style=" background:#4CAF50; color:white;padding:6px 12px;border:none; border-radius:4px;cursor:pointer;"
                            onmouseover="this.style.background='#45a049'"
                            onmouseout="this.style.background='#4CAF50'">
                            Save
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Donation Modal -->
        <div id="donationModal"
            style="display:none; position:fixed; inset:0; background: rgba(0,0,0,0.5); z-index:50; justify-content:center; align-items: flex-start;">
            <div class="bg-white rounded-lg shadow-lg w-1/3 p-6 pb-3 relative" style="margin-top: 5%;">
                <button type="button" id="modalDonationCloseBtn"
                    class="close-btn">
                    ✕
                </button>
                <h2 class="text-lg font-bold mb-4">Add Donation</h2>

                <div style="margin-bottom:10px;">
                    <label> <strong>Member Name</strong></label>
                    <input readonly type="text" name="donation_modal_member_name" id="donation_modal_member_name"
                        style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px; background-color: #1c3faa47; font-weight: 600; color: #121b37;">
                </div>
                <form id="modalDonationForm">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="donor_id" id="donation_modal_donor_id">
                    <input type="hidden" name="income_head_id" id="donation_modal_income_head_id">
                    <div style="margin-bottom:10px;">
                            <label>Money Receipt No</label>
                            <input type="text" name="money_receipt_no" id="money_receipt_no" style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;">
                            <span style="color:red;" class="error_money_receipt_no"></span>
                        </div>
                    <div class="mb-3">
                        <label class="block text-sm font-medium">Transaction Date</label>
                        <input
                            type="date"
                            name="transaction_date"
                            class="input border w-full"
                           max="<?php echo date('Y-m-d'); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="block text-sm font-medium">Amount</label>
                        <input
                            type="number"
                            name="amount"
                            class="input border w-full"
                            step="0.01"
                            min="0"
                            required
                            oninput="validateAmount(this)"
                            placeholder="Enter amount">
                        <small id="amount-error" class="text-red-500 text-xs hidden">Please enter a valid amount</small>
                    </div>
                    <div style="margin-bottom:10px;">
                        <label>Payment Method</label>
                        <select name="payment_type_id"
                            style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;" required>
                            <option value="">-- Select Payment Type --</option>
                            <?php $__currentLoopData = $paymentTypes->where('parent_id', null); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $children = $paymentTypes->where('parent_id', $parent->id); ?>
                            <?php if($children->isEmpty()): ?>
                            <option value="<?php echo e($parent->id); ?>"><?php echo e($parent->name); ?></option>
                            <?php else: ?>
                            <optgroup label="<?php echo e($parent->name); ?>">
                                <?php $__currentLoopData = $children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($child->id); ?>"><?php echo e($child->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </optgroup>
                            <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="flex justify-end space-x-2">
                        <button type="button" id="closeDonationModal"
                            class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600">Cancel</button>
                        <button type="submit"
                            class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700">Save</button>
                    </div>
                </form>
            </div>
        </div>


    </div>
    <!-- END: Horizontal Form -->
</div>
<!-- END: Select Options -->
</div>




<script>
    const donors = <?php echo json_encode($donors, 15, 512) ?>;
    document.querySelectorAll('.add-subscription-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            let donorId = this.dataset.donorId;
            let incomeId = this.dataset.incomeHeadId;
            let donor = donors.find(d => d.donor_id == donorId);

            document.getElementById('modal_donor_id').value = donorId;
            document.getElementById('modal_income_head_id').value = incomeId;
            document.getElementById('subscriptionModal').style.display = 'flex';
        });
    });
    document.getElementById('closeModal').addEventListener('click', () => {
        document.getElementById('subscriptionModal').style.display = 'none';
    });
    document.getElementById('modalCloseBtn').addEventListener('click', () => {
        document.getElementById('subscriptionModal').style.display = 'none';
    });



    document.getElementById('modalSubscriptionForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const modal = document.getElementById('modalSubscriptionForm');
        const form = this;
        const submitBtn = form.querySelector('button[type="submit"]');

        // Disable the submit button and show loading text

        let enteredAmount = Number(form.transaction_amount.value);
        let remaining = Number(document.getElementById("remaing_balance").value);

        // 🔥 VALIDATION: Cannot exceed remaining amount
        if(remaining != 0 || remaining == 150){
            if ( enteredAmount > remaining ) {
                $('.error_transac').html(`Amount cannot be greater than remaining balance ₹${remaining}`);
                return; // Stop submission
            }
        }


        // MIN and MAX check
        if (enteredAmount < 100 || enteredAmount > 500) {
          //  alert("Amount must be between ₹100 and ₹400!");
           $('.error_transac').html("Amount must be between ₹100 and ₹500!")
            return;
        }


        submitBtn.disabled = true;
        const originalText = submitBtn.innerText;
        submitBtn.innerText = 'Submitting...';

        let formData = new FormData(form);

        fetch("<?php echo e(route('donor.subscription.store')); ?>", {
            method: 'POST',
            body: formData,
        })
        .then(res => {
            if (!res.ok) {
                throw new Error(`HTTP error ${res.status}`);
            }
            return res.json();
        })
        .then(data => {
            alert('Subscription saved!');
           $('#subscriptionModal').hide();
            location.reload();
        })
        .catch(err => {
            console.error('Error:', err);
            // alert('Something went wrong. Please try again.');
        })
        .finally(() => {
            submitBtn.disabled = false;
            submitBtn.innerText = originalText;
        });
    });

    document.addEventListener("DOMContentLoaded", function() {

        document.querySelectorAll('.add-donation-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                let donorId = this.dataset.donorId;
                let incomeId = this.dataset.incomeHeadId;

                document.getElementById('donation_modal_donor_id').value = donorId;
                document.getElementById('donation_modal_income_head_id').value = incomeId;

                document.getElementById('donationModal').style.display = 'flex';
            });
        });

        document.getElementById('closeDonationModal').addEventListener('click', () => {
            document.getElementById('donationModal').style.display = 'none';
        });
        document.getElementById('modalDonationCloseBtn').addEventListener('click', () => {
            document.getElementById('donationModal').style.display = 'none';
        });

        document.getElementById('modalDonationForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const form = this;
            const submitBtn = form.querySelector('button[type="submit"]');
            // Disable the submit button and show loading text
            submitBtn.disabled = true;
            const originalText = submitBtn.innerText;
            submitBtn.innerText = 'Submitting...';
            let formData = new FormData(form);

            fetch("<?php echo e(route('donor.member.donation.list.submit')); ?>", {
                method: 'POST',
                body: formData,
                headers: {
                    "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content
                }
            })
            .then(res => {
                if (!res.ok) {
                    throw new Error(`HTTP error ${res.status}`);
                }
                return res.json();
            })
            .then(data => {
                alert('Donation saved!');
                $('#donationModal').hide();

                location.reload();
            })
            .catch(err => {
                console.error('Error:', err);
                // alert('Something went wrong. Please try again.');
            })
            .finally(() => {
                // Re-enable the submit button and restore text
                submitBtn.disabled = false;
                submitBtn.innerText = originalText;
            });
        });
    });

    function cleanAmount(val) {
        val = val.replace(/[^0-9.]/g, "");

        let parts = val.split(".");
        if (parts.length > 2) {
            val = parts[0] + "." + parts.slice(1).join("");
        }
        if (/^0[0-9]/.test(val)) {
            val = val.replace(/^0+/, "");
        }

        if (val.startsWith("0.") || val === "0") {
            val = val.replace(/^0+/, "");
        }
        return val;
    }
    $("input[name='transaction_amount'], input[name='amount']").on("input", function() {
        this.value = cleanAmount(this.value);
    });

    $("#money_receipt_no").on("input", function() {
        let value = $(this).val();
        value = value.replace(/[^A-Za-z0-9]/g, "");
        if (value.length > 20) {
            value = value.substring(0, 20);
        }
        $(this).val(value);
        let errorDiv = $("#error-transaction-reference");
        if (value.length < 5) {
            errorDiv.text("Transaction reference must be at least 5 characters.");
        } else {
            errorDiv.text("");
        }
    });



</script>

<script>
    function validateAmount(input) {
        const error = document.getElementById('amount-error');
        // Allow empty or valid positive decimal numbers
        const isValid = /^\d*\.?\d*$/.test(input.value);

        if (!isValid) {
            error.classList.remove('hidden');
            input.classList.add('border-red-500');
        } else {
            error.classList.add('hidden');
            input.classList.remove('border-red-500');
        }
    }

    function openModal(name, amnt, data) {
        if (typeof data === 'string') {
            data = JSON.parse(data);
        }
        let html = '';

        // Build table rows dynamically
        $.each(data, function(index, item) {
            html += `
            <tr>
                <td style="text-align:left;">${item.date}</td>
                <td style="text-align:right;">${item.amount}</td>
            </tr>
        `;
        });

        $('#open-modal .modal_body').html(html);
        $('#open-modal .modal_name').html(name);
        $('#open-modal .modal_total_amount').html(amnt);

        $('#open-modal').show();
    }

    function closeModal() {
        $('#open-modal').hide();
    }

    $(document).ready(function() {
        setTotalAmount("<?php echo e($final_total_funded_amount); ?>");
        $(document).on('click', '.add-subscription-btn', function() {
            const donorName = $(this).data('member');
            const remaining_blance = $(this).data('remainingvalue');
            $('#subscription_modal_member_name').val(donorName);
            $('#remaing_balance').val(remaining_blance);
            $('#transaction_amount').val(remaining_blance);

        });
        $(document).on('click', '.add-donation-btn', function() {
            const donorName = $(this).data('member');
            $('#donation_modal_member_name').val(donorName);
        });

        function setTotalAmount(amount) {
            $('#final_total_funded_amount').html(amount);
        }


    })
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('master.authMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravelproject\ramkrishna-sevashram-new\resources\views/auth/donor/subscription/list.blade.php ENDPATH**/ ?>