<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title><?php echo e(ucfirst($data->transcation_type)); ?> Transaction</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
        }

        h2 {
            background-color: #f1f5f9;
            color: #1e3a8a;
            padding: 8px 12px;
            border-radius: 6px;
            text-align: center;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        th,
        td {
            padding: 8px 12px;
            border: 1px solid #ddd;
        }

        th {
            background-color: #3b82f6;
            color: white;
            text-align: left;
            width: 30%;
        }

        td {
            background-color: #f9fafb;
        }

        p {
            font-weight: 20px;
        }
    </style>
</head>

<body>
    <div class="intro-y col-span-12 lg:col-span-12 transection-details-view">
        <div class="intro-y box mt-8 shadow-lg rounded-2xl overflow-hidden">
            <div class="bg-gradient-to-r from-blue-600 to-indigo-600 p-5">
                <h2 class="font-semibold text-lg text-black">
                    <?php echo e(ucfirst($data->transcation_type)); ?> Transaction Details:
                </h2>
            </div>

            <div class="p-8 bg-white">
                <div class="grid grid-cols-1 md:grid-cols-2 gap-y-6 gap-x-10">
                    <?php if(isset($data->organisation_name)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Organisation Name:</p>
                        <p class="text-blue-600 font-semibold">
                            <?php echo e($data->organisation_name); ?>

                        </p>
                    </div>
                    <hr>
                    <?php endif; ?>
                    <?php if(isset($data->account_type_Name)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Division Name:</p>
                        <p class="text-blue-600 font-semibold">
                            <?php echo e($data->account_type_Name); ?>

                        </p>
                    </div>
                    <hr>
                    <?php endif; ?>
                    <?php if(isset($data->head_name)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Head Name:</p>
                        <p class="text-blue-600 font-semibold">
                            <?php echo e($data->head_name); ?>

                        </p>
                    </div>
                    <hr>
                    <?php endif; ?>
                    <?php if(isset($data->money_receipt_no)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Money Receipt No. :</p>
                        <p class="text-blue-600 font-semibold">
                            <?php echo e($data->money_receipt_no); ?>

                        </p>
                    </div>
                    <hr>
                    <?php endif; ?>
                    <?php if(!empty($data->asset_name)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Asset Name:</p>
                        <p class="text-blue-600 font-semibold">
                            <?php echo e($asset->asset_name); ?>

                        </p>
                    </div>
                    <hr>
                    <?php endif; ?>
                    <?php if(!empty($data->liability_name)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Liability Name:</p>
                        <p class="text-blue-600 font-semibold">
                            <?php echo e($data->liability_name); ?>

                        </p>
                    </div>
                    <hr>
                    <?php endif; ?>
                    <?php if(!empty($data->donor_name)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Donor Name:</p>
                        <p class="text-blue-600 font-semibold">
                            <?php echo e($data->donor_name); ?>

                            <?php if(!empty($data->donor_type)): ?>
                            <?php if($data->donor_type == 'members'): ?>
                            - (Member)
                            <?php elseif($data->donor_type == 'non_members'): ?>
                            - (Non Member)
                            <?php elseif($data->donor_type == 'foreign_members'): ?>
                            - (Family Member)
                            <?php endif; ?>
                            <?php endif; ?>
                        </p>
                    </div>
                    <hr>
                    <?php endif; ?>
                    <?php if(!empty($accounting_year)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Accounting Year:</p>
                        <p class="text-blue-600 font-semibold">
                            <?php echo e($accounting_year); ?>

                        </p>
                    </div>
                    <hr>
                    <?php endif; ?>
                    <?php if(!empty($data->transaction_date)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Date of Transaction:</p>
                        <p class="text-blue-600 font-semibold">
                            <?php echo e(date('d-m-Y', strtotime($data->transaction_date))); ?>

                        </p>
                    </div>
                    <hr>
                    <?php endif; ?>
                    <?php if(!empty($data->transaction_reference)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Transaction Reference No.:</p>
                        <p class="text-blue-600 font-semibold"><?php echo e($data->transaction_reference); ?></p>
                    </div>
                    <hr>
                    <?php endif; ?>
                    <?php if(!empty($data->payment_type_name)): ?>
                    <div class="list-chart">
                        <p class="text-gray-600 font-medium">Payment Type:</p>
                        <p class="text-blue-600 font-semibold"><?php echo e($data->payment_type_name ?? '-'); ?></p>
                    </div>
                    <hr>
                    <?php endif; ?>
                    <?php if(!empty($data->transaction_narration)): ?>
                    <div class="md:col-span-2 list-chart">
                        <p class="text-gray-600 font-medium">Transaction Narration:</p>
                        <p class="text-blue-600 font-semibold italic"><?php echo e($data->transaction_narration ?? '—'); ?>

                        </p>
                    </div>
                    <hr>
                    <?php endif; ?>
                </div>
                <?php if(!empty($data->transaction_amount)): ?>
                <div class="list-chart">
                    <p class="text-gray-600 font-medium">Transaction Amount:</p>
                    <p class="text-green-600 text-xl font-bold">
                      ₹ <?php echo e(number_format($data->transaction_amount, 2)); ?>

                    </p>
                </div>
                <hr>
                <?php endif; ?>
                <?php if(!empty($data->file_path)): ?>
                <div>
                    <p class="text-gray-600 font-medium">Uploaded Files:</p>
                    <div class="flex gap-4 flex-wrap">
                        <?php $__currentLoopData = explode(',', $data->file_path); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $file = trim($file);
                        $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                        ?>

                        <?php if($extension === 'pdf'): ?>
                        <a href="<?php echo e(asset('storage/' . $file)); ?>" target="_blank"
                            class="flex flex-col items-center justify-center w-32 h-32 bg-gray-100 border rounded shadow cursor-pointer">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-12 h-12 text-red-600"
                                fill="currentColor" viewBox="0 0 24 24">
                                <path
                                    d="M6 2a2 2 0 0 0-2 2v16c0 1.1.9 2 2 2h12a2 2 0 0 0 2-2V8l-6-6H6zm7 1.5L18.5 9H13V3.5zM8 13h8v2H8v-2z" />
                            </svg>
                            <span class="text-sm text-gray-700">PDF File</span>
                        </a>
                        <?php else: ?>
                        <a href="<?php echo e(asset('storage/' . $file)); ?>" target="_blank">
                            <img src="<?php echo e(asset('storage/' . $file)); ?>" alt="Uploaded Image"
                                class="w-32 h-32 object-cover rounded shadow cursor-pointer">
                        </a>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>

</html><?php /**PATH /home/download/public_html/resources/views/jounaltransactions/print.blade.php ENDPATH**/ ?>