@extends('master.authMaster')
@section('content')
    <div class="intro-y col-span-12 lg:col-span-12">

        <!-- BEGIN: Select Options -->
        <div class="intro-y box mt-5 income-head-top-sec">
            <h2 class="text-lg font-medium mr-auto">Contra Transactions</h2>
            <div class="w-full sm:w-auto flex mt-4 sm:mt-0">
                <a href="{{ route('transactions.contra.create') }}">
                    <button class="button text-white bg-theme-1 shadow-md">
                        Add Contra Entry
                    </button>
                </a>
            </div>
        </div>
    </div>
    </div>
    <!-- BEGIN: HTML Table Data -->
    <div class="intro-y box p-5 mt-5">
        <div class="flex flex-col sm:flex-row sm:items-end xl:items-start">
            <form class="xl:flex w-full" id="tabulator-html-filter-form">
                <div class="sm:flex items-center justify-between w-full">
                    <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center gap-2 flex-wrap">
                            <label for="page-size" class="form-label mb-0">Data Per Page</label>
                            <select id="page-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                                {{-- <option value="5">5</option> --}}
                                <option value="10">10</option>
                                <option value="30">30</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                            </select>
                        </div>
                    </div>

                    &nbsp; &nbsp; &nbsp;
                    <div>
                        <input type="text" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" id="search-string"
                            placeholder="Search...">
                    </div>

                </div>
            </form>
        </div>
        <div class="overflow-x-auto scrollbar-hidden">
            <div class="mt-5 table-report table-report--tabulator" id="transcation_table"></div>
        </div>
    </div>
    <!-- END: HTML Table Data -->


    <script src="{{ asset('js/tabulator.min.js') }}"></script>
    <script>
        $(document).ready(function() {

            @if (session('success'))
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: @json(session('success')),
                    timer: 2500,
                    showConfirmButton: false
                });
            @endif

            @if (session('error'))
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: @json(session('error')),
                    timer: 2500,
                    showConfirmButton: false
                });
            @endif

        });
    </script>

    @include('utils.alert')

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // 🧭 Current financial year range
            var currentYearRange =
                "{{ \Carbon\Carbon::createFromDate(date('Y'), 4, 1)->format('d-m-Y') . ' to ' . \Carbon\Carbon::createFromDate(date('Y') + 1, 3, 31)->format('d-m-Y') }}";

            // 🧱 Initialize Tabulator table
            var table = new Tabulator("#transcation_table", {
                ajaxURL: "{{ route('transactions.contra.details') }}",
                ajaxParams: function() {
                    return {
                        _token: document.querySelector('meta[name="csrf-token"]').getAttribute(
                            "content"),
                        search: document.querySelector("#search-string").value,
                        // organisation_id: document.querySelector("#org-size").value,
                    };
                },
                ajaxConfig: "POST",
                layout: "fitColumns",
                theme: "bootstrap5",
                paginationMode: "remote",
                pagination: true,
                paginationSize: 10,
                paginationSizeSelector: false,
                movableRows: true,
                movableColumns: true,
                ajaxLoaderLoading: `
                <div style='display:inline-block; border:4px solid #333; border-radius:10px; background:#fff; font-weight:bold; font-size:16px; color:#000; padding:10px 20px;'>
                    Loading Data
                </div>
            `,
                columnDefaults: {
                    headerHozAlign: "left",
                    tooltip: true,
                },
                columns: [                    {
                        title: "SL",
                        formatter: "rownum",
                        maxWidth: 100,
                        headerSort: false,
                        hozAlign: "center"
                    },
                    {
                        title: "Transaction Date",
                        field: "transaction_date",
                        headerSort: true,
                        minWidth: 180,
                        formatter: function(cell) {
                            let value = cell.getValue();
                            if (value) {
                                let date = new Date(value);
                                // Format as DD-MM-YYYY
                                let day = String(date.getDate()).padStart(2, '0');
                                let month = String(date.getMonth() + 1).padStart(2, '0');
                                let year = date.getFullYear();
                                return `${day}-${month}-${year}`;
                            }
                            return 'N/A';
                        }
                    },
                    {
                        title: "Contra Type",
                        field: "contra_reference_type",
                        headerSort: true,
                        minWidth: 150,
                        formatter: function(cell) {
                            let value = cell.getValue();
                            let labels = {
                                'cash_deposite': 'Cash Deposit',
                                'cash_withdraw': 'Cash Withdrawal',
                                'bank_transfer': 'Bank Transfer'
                            };
                            let badges = {
                                'cash_deposite': 'bg-green-100 text-green-800',
                                'cash_withdraw': 'bg-orange-100 text-orange-800',
                                'bank_transfer': 'bg-blue-100 text-blue-800'
                            };
                            let label = labels[value] || value;
                            let badge = badges[value] || 'bg-gray-100 text-gray-800';
                            return `<span class="px-2 py-1 rounded text-xs font-semibold ${badge}">${label}</span>`;
                        }
                    },
                    {
                        title: "Transaction Amount",
                        field: "transaction_amount",
                        headerSort: true,
                        minWidth: 180,
                        formatter: function(cell) {
                            let value = cell.getValue() || 0;
                            return '₹' + parseFloat(value).toLocaleString('en-IN', {
                                minimumFractionDigits: 2,
                                maximumFractionDigits: 2
                            });
                        }
                    },
                    {
                        title: "Bank(s)",
                        field: "bank_names",
                        headerSort: false,
                        minWidth: 200,
                        formatter: function(cell) {
                            return cell.getValue() || 'N/A';
                        }
                    },
                ],
                rowFormatter: function(row) {
                    const data = row.getData();
                    // You can add custom row formatting here if needed
                },
                ajaxResponse: function(url, params, response) {
                    return {
                        data: response.data,
                        last_page: response.last_page,
                        current_page: response.current_page,
                        total: response.total,
                    };
                }
            });



            // 📄 Page size change
            document.getElementById("page-size")?.addEventListener("change", function() {
                table.setPageSize(Number(this.value));
            });

            // 🔍 Live search
            document.getElementById("search-string")?.addEventListener("input", function() {
                table.setData();
            });
        });
    </script>
@endsection
