@extends('master.authMaster')

@section('content')
    @php
        use Carbon\Carbon;

        $currentOrganisationId = old('organisation_id', optional($currentOrganisation)->organisation_id);
        $financialYear = \App\Models\AccountingYear::current();
        if ($financialYear) {
            [$fyStart, $fyEnd] = array_map('trim', explode(' to ', $financialYear->accounting_year_financial));
            $minDate = Carbon::createFromFormat('d-m-Y', $fyStart)->toDateString();
            $maxDateCandidate = Carbon::createFromFormat('d-m-Y', $fyEnd);
            $today = Carbon::today();
            $maxDate = $today->greaterThan($maxDateCandidate) ? $maxDateCandidate->toDateString() : $today->toDateString();
        } else {
            $minDate = now()->subYear()->toDateString();
            $maxDate = now()->toDateString();
        }

        $oldBankId = old('bank_id');
        $oldFromBankId = old('from_bank_id');
        $oldAmount = old('transaction_amount');
        $oldDate = old('transaction_date', now()->toDateString());
    @endphp

    <div class="intro-y col-span-12 lg:col-span-12">
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    Contra Entry
                </h2>
                <a href="{{ route('transactions.index') }}"
                    class="button text-white bg-gray-600 hover:bg-gray-700 shadow-md mt-3 sm:mt-0">
                    ← Back to Transactions
                </a>
            </div>

            <div class="p-5">
                <form method="POST" action="{{ route('transactions.contra.store') }}" id="contraForm">
                    @csrf
                    <input type="hidden" name="contra_type" value="cash_deposit">
                    <input type="hidden" name="from_head_id" value="{{ old('from_head_id') }}">

                    <div class="grid grid-cols-12 gap-5">
                        <div class="col-span-12 md:col-span-6">
                            <label for="organisation_id" class="form-label font-semibold">Organisation
                                <span class="text-red-500">*</span>
                            </label>
                            <select name="organisation_id" id="organisation_id"
                                class="input w-full border mt-2 custm-drpdwn">
                                <option value="">-- Select Organisation --</option>
                                @foreach ($organisations as $organisation)
                                    <option value="{{ $organisation->organisation_id }}"
                                        data-is-current="{{ $organisation->is_current }}"
                                        {{ (string) $currentOrganisationId === (string) $organisation->organisation_id ? 'selected' : '' }}>
                                        {{ $organisation->organisation_name }}
                                        {{ $organisation->is_current ? '(Current)' : '' }}
                                    </option>
                                @endforeach
                            </select>
                            @error('organisation_id')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>
                        <div></div>

                        <div class="col-span-12 md:col-span-12">
                            <label class="form-label font-semibold">Transaction Type
                                <span class="text-red-500">*</span>
                            </label>
                            <div class="flex items-center gap-6 mt-2">

                                 <div class="flex items-center">
                                    <input type="radio" name="type" value="cash_deposite"
                                        class="input border mr-2 cash_deposite" checked>
                                    <label for="type_cash_dep" class="cursor-pointer">Cash Deposite</label>
                                </div>

                                <div class="flex items-center">
                                    <input type="radio" name="type" id="type_cash" value="cash_withdraw"
                                        class="input border mr-2 cash_withdraw">
                                    <label for="type_cash" class="cursor-pointer ">Cash Withdraw</label>
                                </div>

                                <div class="flex items-center">
                                    <input type="radio" name="type" id="type_bank" value="bank_transfer"
                                        class="input border mr-2 bank_transfer">
                                    <label for="type_bank" class="cursor-pointer">Bank Transfer</label>
                                </div>

                            </div>
                            @error('type')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- Cash Deposite --}}

                        <div class="col-span-12 md:col-span-4 cash_deposite_to_bank">
                            <label class="form-label text-sm">Deposite To Bank <span class="text-red-500">*</span>
                                {{-- <span class="block text-xs text-gray-500">Banks</span> --}}
                            </label>
                            <select name="bank_id" id="bank_id"
                                class="input w-full border mt-2 custm-drpdwn">
                                <option value="">-- Select Deposite To Banks --</option>
                                @foreach ($banks as $bank)
                                    <option value="{{ $bank->id }}"
                                        data-organisation="{{ $bank->organisation_id }}"
                                        data-type="bank"
                                        {{ $oldBankId == $bank->id ? 'selected' : '' }}>
                                        {{ $bank->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('bank_id')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-span-12 md:col-span-4 cash_deposite_to_bank">
                            <label class="form-label text-sm">Amount (₹) <span class="text-red-500">*</span></label>
                            <input type="number" min="0" step="0.01" name="transaction_amount" id="transaction_amount"
                                class="input w-full border mt-2"
                                value="{{ $oldAmount }}"
                                placeholder="Enter amount">
                            @error('transaction_amount')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-span-12 md:col-span-4 cash_deposite_to_bank">
                            <label class="form-label text-sm">Date <span class="text-red-500">*</span></label>
                            <input type="date" name="transaction_date" id="transaction_date"
                                class="input w-full border mt-2"
                                min="{{ $minDate }}"
                                max="{{ $maxDate }}"
                                value="{{ $oldDate }}"
                                onfocus="this.showPicker()">
                            @error('transaction_date')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>


                        {{-- END --}}

                       {{--  Withdraw amount --}}

                        <div class="col-span-12 md:col-span-4 withdraw_bank" style="display: none;">
                            <label class="form-label text-sm">Cash Withdraw from Bank <span class="text-red-500">*</span>
                                {{-- <span class="block text-xs text-gray-500">Banks</span> --}}
                            </label>
                            <select name="bank_id" id="withdraw_bank_id"
                                class="input w-full border mt-2 custm-drpdwn">
                                <option value="">-- Select Withdraw Bank --</option>
                                @foreach ($banks as $bank)
                                    <option value="{{ $bank->id }}"
                                        data-organisation="{{ $bank->organisation_id }}"
                                        data-type="bank"
                                        {{ $oldBankId == $bank->id ? 'selected' : '' }}>
                                        {{ $bank->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('bank_id')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-span-12 md:col-span-4 withdraw_bank" style="display: none;">
                            <label class="form-label text-sm">Amount (₹) <span class="text-red-500">*</span></label>
                            <input type="number" min="0" step="0.01" name="transaction_amount" id="withdraw_transaction_amount"
                                class="input w-full border mt-2"
                                value="{{ $oldAmount }}"
                                placeholder="Enter amount">
                            @error('transaction_amount')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-span-12 md:col-span-4 withdraw_bank" style="display: none;">
                            <label class="form-label text-sm">Date <span class="text-red-500">*</span></label>
                            <input type="date" name="transaction_date" id="withdraw_transaction_date"
                                class="input w-full border mt-2"
                                min="{{ $minDate }}"
                                max="{{ $maxDate }}"
                                value="{{ $oldDate }}"
                                onfocus="this.showPicker()">
                            @error('transaction_date')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- END --}}

                        {{-- Bank to bank transfer --}}

                        <div class="col-span-12 md:col-span-3 transfer_to_bank" style="display: none;">
                            <label class="form-label text-sm">Transfer from Bank <span class="text-red-500">*</span>
                                {{-- <span class="block text-xs text-gray-500">Banks</span> --}}
                            </label>
                            <select name="from_bank_id" id="from_bank_id"
                                class="input w-full border mt-2 custm-drpdwn">
                                <option value="">-- Select From Bank --</option>
                                @foreach ($banks as $bank)
                                    <option value="{{ $bank->id }}"
                                        data-organisation="{{ $bank->organisation_id }}"
                                        data-type="bank"
                                        {{ $oldFromBankId == $bank->id ? 'selected' : '' }}>
                                        {{ $bank->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('from_bank_id')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-span-12 md:col-span-3 transfer_to_bank" style="display: none;">
                            <label class="form-label text-sm">Transfer to Bank <span class="text-red-500">*</span>
                                {{-- <span class="block text-xs text-gray-500">Banks</span> --}}
                            </label>
                            <select name="bank_id" id="transfer_bank_id"
                                class="input w-full border mt-2 custm-drpdwn">
                                <option value="">-- Select To Bank --</option>
                                @foreach ($banks as $bank)
                                    <option value="{{ $bank->id }}"
                                        data-organisation="{{ $bank->organisation_id }}"
                                        data-type="bank"
                                        {{ $oldBankId == $bank->id ? 'selected' : '' }}>
                                        {{ $bank->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('bank_id')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-span-12 md:col-span-3 transfer_to_bank" style="display: none;">
                            <label class="form-label text-sm">Amount (₹) <span class="text-red-500">*</span></label>
                            <input type="number" min="0" step="0.01" name="transaction_amount" id="transfer_transaction_amount"
                                class="input w-full border mt-2"
                                value="{{ $oldAmount }}"
                                placeholder="Enter amount">
                            @error('transaction_amount')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-span-12 md:col-span-3 transfer_to_bank" style="display: none;">
                            <label class="form-label text-sm">Date <span class="text-red-500">*</span></label>
                            <input type="date" name="transaction_date" id="transfer_transaction_date"
                                class="input w-full border mt-2"
                                min="{{ $minDate }}"
                                max="{{ $maxDate }}"
                                value="{{ $oldDate }}"
                                onfocus="this.showPicker()">
                            @error('transaction_date')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        {{-- END --}}

                        <div class="col-span-12">
                            <label for="transaction_reference" class="form-label font-semibold">Transaction Reference</label>
                            <input type="text" name="transaction_reference" id="transaction_reference"
                                class="input w-full border mt-2"
                                value="{{ old('transaction_reference') }}"
                                placeholder="Enter reference (optional)">
                            @error('transaction_reference')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-span-12">
                            <label for="transaction_narration" class="form-label font-semibold">Narration</label>
                            <textarea name="transaction_narration" id="transaction_narration"
                                class="input w-full border mt-2"
                                rows="3"
                                placeholder="Add notes for this contra entry (optional)">{{ old('transaction_narration') }}</textarea>
                            @error('transaction_narration')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="flex flex-col sm:flex-row sm:justify-end gap-3 mt-8">
                        <a href="{{ route('transactions.index') }}"
                            class="px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white shadow">
                            Cancel
                        </a>
                        <button type="submit" id="submitContraForm" class="button w-full sm:w-32 bg-theme-1 text-white">
                            <span class="submit-text">Save Contra Entry</span>
                            <span class="loading-text" style="display: none;">
                                <i class="fa fa-spinner fa-spin"></i> Saving...
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    @include('utils.alert')



    <script>

        $(document).ready(function() {
            // Screen Withdraw Cash from banks ------------
            $('.cash_withdraw').on('click',function(){
                $('.cash_deposite_to_bank').css('display','none');
                $('.transfer_to_bank').css('display','none');
                $('.withdraw_bank').css('display','block');
            });

            $('.cash_deposite').on('click',function(){
                $('.withdraw_bank').css('display','none');
                $('.transfer_to_bank').css('display','none');
                $('.cash_deposite_to_bank').css('display','block');
            });

            $('.bank_transfer').on('click',function(){
                $('.withdraw_bank').css('display','none');
                $('.cash_deposite_to_bank').css('display','none');
                $('.transfer_to_bank').css('display','block');
            });
        });

        // AJAX Form Submission
        $('#contraForm').on('submit', function(e) {
            e.preventDefault();

            var $form = $(this);
            var $submitBtn = $('#submitContraForm');
            var $submitText = $submitBtn.find('.submit-text');
            var $loadingText = $submitBtn.find('.loading-text');

            // Disable submit button and show loading
            $submitBtn.prop('disabled', true);
            $submitText.hide();
            $loadingText.show();

            // Get transaction type
            var selectedType = $('input[name="type"]:checked').val();

            // Get form data - form already has all single fields
            var formData = new FormData(this);

            // Remove all bank_id and transaction_amount fields first
            formData.delete('bank_id');
            formData.delete('transaction_amount');
            formData.delete('transaction_date');
            formData.delete('from_bank_id');

            // Based on transaction type, add only relevant fields
            if (selectedType === 'cash_deposite') {
                // Cash Deposite: bank_id, transaction_amount, transaction_date from cash_deposite_to_bank section
                var bankId = $('#bank_id').val();
                var amount = $('#transaction_amount').val();
                var date = $('#transaction_date').val();

                if (bankId) formData.append('bank_id', bankId);
                if (amount) formData.append('transaction_amount', amount);
                if (date) formData.append('transaction_date', date);
            } else if (selectedType === 'cash_withdraw') {
                // Cash Withdraw: bank_id, transaction_amount, transaction_date from withdraw_bank section
                var bankId = $('#withdraw_bank_id').val();
                var amount = $('#withdraw_transaction_amount').val();
                var date = $('#withdraw_transaction_date').val();

                if (bankId) formData.append('bank_id', bankId);
                if (amount) formData.append('transaction_amount', amount);
                if (date) formData.append('transaction_date', date);
            } else if (selectedType === 'bank_transfer') {
                // Bank Transfer: from_bank_id, bank_id, transaction_amount, transaction_date from transfer_to_bank section
                var fromBankId = $('#from_bank_id').val();
                var bankId = $('#transfer_bank_id').val();
                var amount = $('#transfer_transaction_amount').val();
                var date = $('#transfer_transaction_date').val();

                if (fromBankId) formData.append('from_bank_id', fromBankId);
                if (bankId) formData.append('bank_id', bankId);
                if (amount) formData.append('transaction_amount', amount);
                if (date) formData.append('transaction_date', date);
            }

            // Ensure from_head_id is sent as empty string (Laravel will convert to null)
            var fromHeadId = $('input[name="from_head_id"]').val();
            if (!fromHeadId || fromHeadId === '') {
                formData.set('from_head_id', '');
            }

            // Add transaction type to form data
            formData.set('type', selectedType);


            $.ajax({
                url: $form.attr('action'),
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function(response) {
                    if (response.success) {
                        // Show success message
                        if (typeof showAlert === 'function') {
                            showAlert('success', response.message);
                        } else {
                            alert(response.message);
                        }

                        // Redirect after a short delay
                        setTimeout(function() {
                            if (response.redirect) {
                                window.location.href = response.redirect;
                            } else {
                                window.location.reload();
                            }
                        }, 1500);
                    } else {
                        // Show error message
                        if (typeof showAlert === 'function') {
                            showAlert('error', response.message || 'An error occurred');
                        } else {
                            alert(response.message || 'An error occurred');
                        }

                        // Re-enable submit button
                        $submitBtn.prop('disabled', false);
                        $submitText.show();
                        $loadingText.hide();
                    }
                },
                error: function(xhr) {
                    var errorMessage = 'Failed to save contra entry. Please try again.';

                    if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMessage = xhr.responseJSON.message;
                    } else if (xhr.responseJSON && xhr.responseJSON.errors) {
                        // Handle validation errors
                        var errors = xhr.responseJSON.errors;
                        var errorMessages = [];
                        $.each(errors, function(key, value) {
                            errorMessages.push(value[0]);
                        });
                        errorMessage = errorMessages.join('\n');
                    }

                    // Show error message
                    if (typeof showAlert === 'function') {
                        showAlert('error', errorMessage);
                    } else {
                        alert(errorMessage);
                    }

                    // Re-enable submit button
                    $submitBtn.prop('disabled', false);
                    $submitText.show();
                    $loadingText.hide();
                }
            });
        });

    </script>
@endsection
