@extends('master.authMaster')
@section('content')
<div class="col-span-12 lg:col-span-12">
    <div class="flex justify-between mt-5">
        <h2 class="text-lg font-medium mr-auto">
            Members
        </h2>
        @can('modify-menu', 54)
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
            <a href="{{ route('donor.create') }}">
                <button class="secondary">
                    Add Member
                </button>
            </a>
        </div>
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
            <a href="{{ route('donor.importForm') }}">
                <button class="secondary">
                    Add Bulk Member
                </button>
            </a>
        </div>
        @endcan
        <div class="w-full sm:w-auto flex mt-4 sm:mt-0 mr-4">
            <a href="{{ route('donor.member.donation.list') }}">
                <button class="primary">
                    Members Yearly Record
                </button>
            </a>
        </div>
    </div>
</div>
</div>
<div class="intro-y box p-5 mt-5">

    <div class="flex flex-col sm:flex-row sm:items-end xl:items-start">
        <form class="xl:flex w-full" id="tabulator-html-filter-form">
            <div class="sm:flex items-end justify-between w-full gap-4">
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center gap-2 flex-wrap">
                        <label for="page-size" class="form-label mb-0">Data Per Page</label>
                        <select id="page-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                            {{-- <option value="5">5</option> --}}
                            <option value="10">10</option>
                            <option value="30">30</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                        </select>
                    </div>
                </div>
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between">
                    <div class="d-flex align-items-center flex-wrap">
                        <label for="org-size" class="form-label mb-0">Members as per Organisation:</label>
                        <select id="org-size" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border">
                            <option value="">All Members</option>
                            @foreach ($organisations as $organisation)
                            <option value="{{ $organisation->organisation_id }}">
                                {{ $organisation->organisation_name }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="ms-4 me-4 d-flex align-items-center justify-content-between" style="max-width: 300px;">
                    <div class="d-flex align-items-center flex-wrap">
                        <label for="org-size" class="form-label mb-0">Defaulter Members List</label>
                        <select id="defaulter_mem" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border"
                            name="amount_flag">
                            <option value="">--select--</option>
                            <option value="not_paid">Pending</option>
                            <option value="paid">Paid</option>
                        </select>
                    </div>
                </div>
                <div>
                    <input type="text" class="input w-full sm:w-40 xxl:w-full mt-2 sm:mt-0 border" id="search-string"
                        placeholder="Search...">
                </div>
            </div>
        </form>
    </div>
    <div class="overflow-x-auto scrollbar-hidden">
        <div class="mt-5 table-report table-report--tabulator" id="donor-table"></div>
    </div>
</div>

@if (session('success'))
<script>
    toastr.success(@json(session('success')), "Success", toastrProperties);
</script>
@elseif (session('error'))
<script>
    toastr.error(@json(session('error')), "Error", toastrProperties);
</script>
@endif

<link href="{{ asset('build/assets/css/tabulator.min.css') }}" rel="stylesheet">
<link href="{{ asset('css/tabulator_materialize.min.css') }}" rel="stylesheet">
<script type="text/javascript" src="{{ asset('js/tabulator.min.js') }}"></script>
<script>
    const canAddDonation = @json(Gate::allows('modify-menu', 54));
    const getDonorRoute = "{{ route('donor.details') }}";
</script>
<script src="{{ asset('js/members/memberListing.js') }}"></script>
@endsection