@extends('master.authMaster')
@section('content')
<script>
    var isError = false;
</script>
<div class="intro-y col-span-12 lg:col-span-12">

    <div class="intro-y box mt-5" style=" padding: 20px 20px 30px 20px;">
        <div class="intro-y mt-5">
            <h2 class="text-xl font-bold mb-4">Add Member</h2>
            @if ($errors->any())
            <script>
                var isError = true;
            </script>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <ul class="list-disc pl-5">
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
            @endif

            <form id="donorForm" action="{{ route('donor.store') }}" method="POST">
                @csrf
                <div class="grid grid-cols-2 gap-4">
                    <div class="donorclass">
                        <label class="block text-gray-700">Organisation <span style="color: red">*</span></label>
                        <select id="organisation_id" name="organisation_id"
                            class="input w-full border mt-2 custm-drpdwn" disabled>
                            <option value="">-- Select Organisation --</option>
                            <option value="{{ $orgId }}"
                             selected>
                                {{ $organisationsName }}
                            </option>
                        </select>
                        <div class="text-red-500 text-sm mt-1 error-message" id="error-organisation"></div>
                    </div>
                    <div class="donorclass">
                        <div id="accountTypeWrapper">
                            <label class="block text-gray-700">Division</label>
                            <select id="account_type_id" name="account_type_id"
                                class="input w-full border mt-2 custm-drpdwn">
                                <option value="">-- Select Division --</option>
                                @foreach($accountTypes as $aType)
                                <option value="{{  $aType['account_type_id'] }}" {{ old('account_type_id') == $aType['account_type_id'] ? 'selected' : '' }}>{{ $aType['account_type_Name'] }}</option>
                                @endforeach
                            </select>
                            <small id="accountTypeMsg" class="text-red-500" style="display:none;">
                                Please select organisation first
                            </small>
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-account-type"></div>
                        </div>
                    </div>
                    <div class="donorclass">
                        <label class="block text-gray-700">Donor Type <span class="text-red-500">*</span></label>
                        <select id="donor_type" name="donor_type" class="w-full border p-2 rounded _required">
                            <option value="">-- Select --</option>
                            <option value="members" {{ old('donor_type') == 'members' ? 'selected' : '' }}>Members
                            </option>
                            <option value="foreign_members"
                                {{ old('donor_type') == 'foreign_members' ? 'selected' : '' }}>
                                Family Members</option>
                            <option value="non_members" {{ old('donor_type') == 'non_members' ? 'selected' : '' }}>
                                Non Members
                            </option>
                        </select>
                        <div class="text-red-500 text-sm mt-1 error-message" id="error-donor-type"></div>
                    </div>

                    <div class="donorclass">
                        <label class="block text-gray-700">Name <span class="text-red-500">*</span></label>
                        <input type="text" id="donor_name" name="donor_name" value="{{ old('donor_name') }}"
                            class="w-full border p-2 rounded _required _name">
                        <div class="text-red-500 text-sm mt-1 error-message" id="error-donor-name"></div>
                    </div>
                    <div class="donorclass">
                        <label class="block text-gray-700">Donor Folio Number</label>
                        <input type="text" id="donor_folio_no" name="donor_folio_no"
                            value="{{ old('donor_folio_no') }}" class="w-full border p-2 rounded _noSpecialChars">
                        <div class="text-red-500 text-sm mt-1 error-message" id="error-folio-no"></div>
                    </div>

                    <div class="donorclass">
                        <label class="block text-gray-700">Phone Number</label>
                        <input type="text" id="donor_phone_number" name="donor_phone_number"
                            value="{{ old('donor_phone_number') }}" class="w-full border p-2 rounded _phone">
                        <div class="text-red-500 text-sm mt-1 error-message" id="error-phone-number"></div>
                    </div>
                    <div class="donorclass">
                        <label class="block text-gray-700">Address</label>
                        <textarea id="donor_address" name="donor_address" class="w-full border p-2 rounded _textOnly">{{ old('donor_address') }}</textarea>
                        <div class="text-red-500 text-sm mt-1 error-message" id="error-address"></div>
                    </div>

                </div>
                <div class="sm:pl-5 mt-5 flex items-center space-x-3">
                    <a href="{{ route('donor.index') }}"
                        class="inline-flex items-center px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white">Cancel</a>
                    <button id="saveDonor" type="submit"
                        class="inline-flex items-center justify-center w-24 px-4 py-2 rounded bg-theme-1 text-white">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
<script src="{{ asset('js/skj-validations@v2.js') }}"></script>
<script src="{{ asset('js/members/addMember.js') }}"></script>
@endsection