@extends('master.authMaster')


@section('content')
{{-- Form --}}
<div class="intro-y col-span-12 lg:col-span-12">

    <!-- BEGIN: Select Options -->
    <div class="intro-y box mt-5">
        <!-- BEGIN: Horizontal Form -->
        <div class="intro-y box mt-5">
            <div class="flex flex-col sm:flex-row items-center p-5 border-b border-gray-200 dark:border-dark-5">
                <h2 class="font-medium text-base mr-auto">
                    Expense Transaction
                </h2>

            </div>
            <div class="p-5" id="horizontal-form">

                <form id="expenseForm" method="POST">
                    @csrf
                    <div class="preview">
                        {{-- <div class="grid grid-cols-12 gap-6 mt-5"> --}}
                        <div class="intro-y col-span-12 lg:col-span-12">
                            <!-- BEGIN: Input -->
                            <div class="intro-y box">

                                <div class="p-5" id="input">
                                    <div class="preview">
                                        @php
                                        use Carbon\Carbon;
                                        $financialYear = \App\Models\AccountingYear::current();
                                        $orgId = \App\Models\Organisation::current()->organisation_id;

                                        [$startDate, $endDate] = explode(
                                        ' to ',
                                        $financialYear->accounting_year_financial,
                                        );

                                        $startDate = Carbon::createFromFormat('d-m-Y', trim($startDate));
                                        $endDate = Carbon::createFromFormat('d-m-Y', trim($endDate));

                                        $today = Carbon::today();

                                        if ($today->between($startDate, $endDate)) {
                                        $maxDate = $today->toDateString();
                                        } else {
                                        $maxDate = $endDate->toDateString();
                                        }

                                        $minDate = $startDate->toDateString();
                                        @endphp
                                        <div class="w-full -ml-4 -mr-4 flex flex-wrap">

                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Organisation <span style="color: red">*</span></label>
                                                    <select id="organisation_id" name="organisation_id"
                                                        class="input w-full border mt-2 custm-drpdwn" disabled>
                                                        <option value="">-- Select Organisation --</option>
                                                        @foreach ($organisations as $organisation)
                                                        <option value="{{ $organisation->organisation_id }}"
                                                            {{ old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : '' }}>
                                                            {{ $organisation->organisation_name }}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-organisation"></div>
                                                </div>
                                            </div>
                                            <input type="hidden" value="{{ $orgId }}" id="organisation_id"
                                                name="organisation_id">
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3" id="accountTypeWrapper">
                                                    <label>Division</label>
                                                    <select id="account_type_id" name="account_type_id"
                                                        class="input w-full border mt-2 custm-drpdwn" disabled>
                                                        <option value="">-- Select Division Type --</option>
                                                    </select>
                                                    <small id="accountTypeMsg" class="text-red-500"
                                                        style="display:none;">
                                                        Please select organisation first
                                                    </small>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-account-type"></div>
                                                </div>
                                            </div>

                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label class="items-center justify-between"> Expense Head
                                                        <span style="color: red">*</span>

                                                        <!-- <button type="button" id="addExpenseHeadBtn"
                                                            class="ml-2 bg-blue-500 text-white px-2 py-1 rounded hidden hover:bg-blue-600"
                                                            style="float: right;">+</button> -->
                                                    </label>
                                                    <select id="expense_head_id" name="expense_head_id"
                                                        class="input w-full border mt-2 custm-drpdwn">
                                                        <option value="">-- Select Expense Head --</option>
                                                        @foreach ($expenseHeads as $expenseHead)
                                                        <option value="{{ $expenseHead->expense_head_id }} # {{ $expenseHead->expense_head_group_id }}"
                                                            {{ old('expense_head_id') == $expenseHead->expense_head_id ? 'selected' : '' }}>
                                                            {{ $expenseHead->expense_head_name }}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-expense-head"></div>
                                                </div>
                                            </div>
                                            <!-- Add Expense Head Modal -->
                                            <div id="expenseHeadModal"
                                                class="hidden fixed inset-0 bg-gray-800 bg-opacity-50 flex items-center justify-center z-50">
                                                <div class="bg-white p-6 rounded-2xl w-96 shadow-lg">
                                                    <h2 class="text-lg font-semibold mb-4">Add Expense Head</h2>

                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div>
                                                            <label>Organisation <span
                                                                    class="text-red-500">*</span></label>
                                                            <select id="expense_organisation_id_new"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select Organisation --
                                                                </option>
                                                                @foreach ($organisations as $org)
                                                                <option value="{{ $org->organisation_id }}">
                                                                    {{ $org->organisation_name }}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                            <div class="text-red-500 text-sm error-message"
                                                                id="error-organisation-id"></div>
                                                        </div>
                                                        <div>
                                                            <label class="block">Division <span
                                                                    class="text-red-500">*</span></label>
                                                            <select id="expense_account_type_id"
                                                                class="w-full border rounded px-3 py-2 custm-drpdwn"
                                                                disabled>
                                                                <option value="">-- Select --</option>
                                                                @foreach ($accountTypes as $type)
                                                                <option value="{{ $type->account_type_id }}">
                                                                    {{ $type->account_type_Name }}
                                                                </option>
                                                                @endforeach
                                                            </select>
                                                        </div>

                                                        <div>
                                                            <label class="block">Expense Head Name <span
                                                                    class="text-red-500">*</span></label>
                                                            <input type="text" id="expense_head_name"
                                                                class="w-full border rounded px-3 py-2">
                                                        </div>

                                                        <div class="flex justify-end space-x-3">
                                                            <button type="button" id="closeExpenseHeadModal"
                                                                class="px-4 py-2 bg-gray-500 text-white rounded">Cancel</button>
                                                            <button type="button" id="saveExpenseHeadBtn"
                                                                class="px-4 py-2 bg-blue-600 text-white rounded">Save</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Error Modal -->
                                            <div id="expenseErrorModal"
                                                class="hidden fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50">
                                                <div class="bg-white rounded-lg shadow-lg p-6 w-96">
                                                    <h2 class="text-lg font-semibold text-red-600 mb-2">Error</h2>
                                                    <p id="expenseErrorMessage" class="text-gray-700"></p>
                                                    <div class="flex justify-end mt-4">
                                                        <button type="button" id="closeExpenseErrorModal"
                                                            class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                                                            Close
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Voucher / Receipt No. </label>
                                                    <input type="text" class="input w-full border mt-2"
                                                        name="receipt_no" value="{{ old('receipt_no') }}"
                                                        placeholder="Enter Voucher / Receipt Number">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-receipt-number"></div>
                                                </div>
                                            </div>

                                            {{-- START vendor/staff --}}
                                            <div class="w-full px-4">
                                                <div class="mt-3">
                                                    <label class="block font-medium text-gray-700">Pay To</label>
                                                    <div class="flex items-center space-x-6 mt-2">
                                                        <label class="flex items-center space-x-2">
                                                            <input type="radio" name="payee_type" value="internal"
                                                                class="payee-type-radio w-4 h-4">
                                                            <span>Staff</span>
                                                        </label>
                                                        <label class="flex items-center space-x-2">
                                                            <input type="radio" name="payee_type" value="external"
                                                                class="payee-type-radio w-4 h-4">
                                                            <span>Vendor</span>
                                                        </label>
                                                        <button type="button" id="clearPayeeSelection"
                                                            class="ml-4 px-3 py-1 bg-gray-200 text-gray-700 rounded hover:bg-gray-300 ">
                                                            Clear
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="mt-3 hidden relative" id="payeeWrapper">
                                                    <label class="flex items-center justify-between">
                                                        <span class="text-gray-700">Select Payee</span>
                                                        <input type="text" id="payeeInput"
                                                            class="input w-full border mt-2 p-2 rounded"
                                                            placeholder="Type to search payee...">
                                                        <button type="button" id="addVendorBtn"
                                                            class="ml-2 bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600">+</button>
                                                    </label>
                                                    <ul id="payeeList"
                                                        class="absolute w-full bg-white border rounded mt-1 max-h-40 overflow-y-auto hidden z-10 custm-drpdwn">
                                                        @foreach ($vendors as $vendor)
                                                        <li data-id="{{ $vendor->vendor_id }}"
                                                            data-type="{{ $vendor->vendor_type }}"
                                                            class="px-3 py-2 hover:bg-gray-100 cursor-pointer">
                                                            {{ $vendor->vendor_name }}
                                                        </li>
                                                        @endforeach
                                                    </ul>
                                                    <input type="hidden" name="payee_id" id="payeeHidden">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-asset-payee"></div>
                                                </div>
                                                <div class="mt-3 hidden" id="vendorAmountWrapper">
                                                    <label>
                                                        <span class="text-gray-700" style="color: blue;">Total
                                                            Bill
                                                            Amount
                                                            (₹) </span>
                                                        <input type="text" data-type="external"
                                                            name="vendor_total_amount" id="vendorTotalAmount"
                                                            class="input w-full border mt-2 p-2 rounded"
                                                            placeholder="Enter total amount">
                                                        <div class="text-red-500 text-sm mt-1 error-message"
                                                            id="error-asset-payee-amount"></div>
                                                    </label>
                                                </div>
                                            </div>
                                            <!-- Vendor Modal -->
                                            <div id="vendorModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden z-50">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-1/2">
                                                    <h2 class="text-lg font-bold mb-4">Add New Vendor</h2>

                                                    <div class="grid grid-cols-2 gap-4">
                                                        <div>
                                                            <label>Vendor Type <span style="color:red">*</span></label>
                                                            <select id="vendor_type_new"
                                                                class="w-full border p-2 rounded" disabled>
                                                                <option value="">-- Select --</option>
                                                                <option value="internal">Staff</option>
                                                                <option value="external">Vendor</option>
                                                            </select>
                                                        </div>

                                                        <div>
                                                            <label>Vendor Name <span style="color:red">*</span></label>
                                                            <input type="text" id="vendor_name" name="vendor_name" class="w-full border p-2 rounded">
                                                            <p id="error-vendor-name" class="text-red-500 text-sm mt-1"></p> <!-- Error message goes here -->
                                                        </div>


                                                        <div>
                                                            <label>Phone</label>
                                                            <input type="text" id="vendor_phone_number"
                                                                class="w-full border p-2 rounded">
                                                        </div>

                                                        <div>
                                                            <label>GST Number</label>
                                                            <input type="text" id="vendor_gst_number"
                                                                class="w-full border p-2 rounded">
                                                        </div>
                                                        <div>
                                                            <label>PAN Number</label>
                                                            <input type="text" id="vendor_pan_number"
                                                                class="w-full border p-2 rounded">
                                                        </div>

                                                        <div>
                                                            <label>Bank Account No</label>
                                                            <input type="text" id="vendor_bank_account_number"
                                                                class="w-full border p-2 rounded">
                                                        </div>
                                                        <div>
                                                            <label>Bank IFSC</label>
                                                            <input type="text" id="vendor_bank_ifsc"
                                                                class="w-full border p-2 rounded">
                                                        </div>

                                                    </div>

                                                    <div class="mt-4">
                                                        <label>Address</label>
                                                        <textarea id="vendor_address" class="w-full border p-2 rounded"></textarea>
                                                    </div>

                                                    <div class="flex justify-end space-x-2 mt-6">
                                                        <button type="button" id="closeVendorModal"
                                                            class="px-4 py-2 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                                                        <button type="button" id="saveVendor"
                                                            class="px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">Save</button>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Success Modal -->
                                            <div id="vendorSuccessModal"
                                                class="fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 hidden">
                                                <div class="bg-white p-6 rounded-lg shadow-lg w-96 text-center">
                                                    <h2 class="text-lg font-bold mb-4">Success!</h2>
                                                    <p>Vendor added successfully.</p>
                                                    <button type="button" id="vendorCloseSuccessModal"
                                                        class="mt-4 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600">
                                                        Close
                                                    </button>
                                                </div>
                                            </div>

                                            <!-- Error Modal -->
                                            <div id="vendorErrorModal"
                                                class="hidden fixed inset-0 flex items-center justify-center z-50 bg-black bg-opacity-50">
                                                <div class="bg-white rounded-lg shadow-lg p-6 w-96">
                                                    <h2 class="text-lg font-semibold text-red-600 mb-2">Error</h2>
                                                    <p id="vendorErrorMessage" class="text-gray-700"></p>
                                                    <div class="flex justify-end mt-4">
                                                        <button type="button" id="vendorCloseErrorModal"
                                                            class="bg-red-500 text-white px-4 py-2 rounded hover:bg-red-600">
                                                            Close
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                            {{-- END vendor/staff --}}

                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Amount Paid (₹) <span style="color: red">*</span></label>
                                                    <input type="text" class="input w-full border mt-2"
                                                        name="transaction_amount"
                                                        value="{{ old('transaction_amount') }}"
                                                        placeholder="Enter Transaction Amount">
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-transaction-amount"></div>
                                                </div>
                                            </div>
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Payment Type <span style="color: red">*</span>
                                                    </label>
                                                    <select id="payment_type_id" name="payment_type_id"
                                                        class="input w-full border mt-2 custm-drpdwn">
                                                        <option value="">-- Select Payment Type --
                                                        </option>

                                                        @foreach ($paymentTypes->where('parent_id', null) as $parent)
                                                        @php
                                                        $children = $paymentTypes->where(
                                                        'parent_id',
                                                        $parent->id,
                                                        );
                                                        @endphp

                                                        @if ($children->isEmpty())
                                                        <option value="{{ $parent->id }}"
                                                            {{ old('payment_type_id') == $parent->id ? 'selected' : '' }}>
                                                            {{ $parent->name }}
                                                        </option>
                                                        @else
                                                        <optgroup label="{{ $parent->name }}">
                                                            @foreach ($children as $child)
                                                            <option value="{{ $child->id }}"
                                                                {{ old('payment_type_id') == $child->id ? 'selected' : '' }}>
                                                                {{ $child->name }}
                                                            </option>
                                                            @endforeach
                                                        </optgroup>
                                                        @endif
                                                        @endforeach
                                                    </select>

                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-payment-type"></div>
                                                </div>
                                            </div>
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Date of Transaction <span
                                                            style="color: red">*</span></label>
                                                    <input type="date" class="input w-full border mt-2"
                                                        name="transaction_date" min="{{ $minDate }}"
                                                        max="{{ $maxDate }}"
                                                        value="{{ old('transaction_date', now()->toDateString()) }}"
                                                        onfocus="this.showPicker()" />
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-date"></div>
                                                </div>
                                            </div>
                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Transaction Reference No.</label>
                                                    <input id="transaction_reference" type="text"
                                                        class="input w-full border mt-2" name="transaction_reference"
                                                        value="{{ old('transaction_reference') }}"
                                                        placeholder="Enter Transaction Reference">
                                                    <div class="text-gray-500 text-xs mt-1">
                                                        Only letters and numbers allowed, 5–20 characters.
                                                    </div>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-transaction-reference"></div>
                                                </div>
                                            </div>


                                            <div class="w-6/12 px-4">
                                                <div class="mt-3">
                                                    <label>Transaction Narration </label>
                                                    <textarea class="input w-full border mt-2" name="transaction_narration" placeholder="Enter Transaction Narration">{{ old('transaction_narration') }}</textarea>
                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-transaction-narration"></div>
                                                </div>
                                            </div>

                                            <div class="w-full px-4">
                                                <div class="mt-3">
                                                    <label>Upload Images</label>
                                                    <input type="file" class="w-full border mt-2 p-2 rounded"
                                                        name="expense_files[]" id="expense_files"
                                                        accept="image/*,application/pdf" multiple>
                                                    <ul id="file-list" class="mt-2 text-sm text-gray-600 space-y-1">
                                                    </ul>

                                                    <div class="text-red-500 text-sm mt-1 error-message"
                                                        id="error-expense-files"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- </div> --}}

                        </div>
                        <div class="sm:pl-5 mt-5">

                            <a href="{{ route('expense.index') }}"><span
                                    class="bg-gray-500 text-white px-4 py-2 rounded hover:bg-gray-600 mr-2">
                                    ← Back
                                </span></a>
                            <button type="submit" class="button w-24 bg-theme-1 text-white" id="transaction_expense">Save</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- END: Horizontal Form -->
    </div>
    <!-- END: Select Options -->
</div>


<script>
    //organisation and accountype checking start.
    let accountTypes = @json($accountTypes);
    let orgSelect = document.getElementById('organisation_id');
    let accSelect = document.getElementById('account_type_id');
    let msg = document.getElementById('accountTypeMsg');



    let oldOrg = "{{ old('organisation_id', $orgId) }}";
    let oldAcc = "{{ old('account_type_id') }}";

    function populateAccountTypes(orgId) {
        accSelect.innerHTML = '<option value="">-- Select Division --</option>';

        if (orgId) {
            let filtered = accountTypes.filter(at => at.organisation_id == oldOrg);

            if (filtered.length > 0) {
                document.getElementById("accountTypeWrapper").style.display = "block";
                filtered.forEach(at => {
                    let option = document.createElement('option');
                    option.value = at.account_type_id;
                    option.textContent = at.account_type_Name;

                    if (oldAcc == at.account_type_id) {
                        option.selected = true;
                    }
                    accSelect.appendChild(option);
                });

                accSelect.disabled = false;
                msg.style.display = "none";
            } else {
                accSelect.disabled = true;
                msg.textContent = "No division found for this organisation.";
                msg.style.display = "block";
                document.getElementById("accountTypeWrapper").style.display = "none";
            }
        } else {
            accSelect.disabled = true;
            msg.textContent = "Please select organisation first.";
            msg.style.display = "block";
            document.getElementById("accountTypeWrapper").style.display = "block";
        }
    }

    orgSelect.addEventListener('change', function() {
        populateAccountTypes(this.value);
    });

    accSelect.addEventListener('focus', function() {
        if (!orgSelect.value) {
            msg.textContent = "Please select organisation first.";
            msg.style.display = "block";
            setTimeout(() => msg.style.display = "none", 2000);
        }
    });

    if (oldOrg) {
        populateAccountTypes(oldOrg);
    }
    //organisation and accountype checking end.


    $(document).ready(function() {





        $("input[name='type']").on("click", function(e) {
            const orgId = $("#organisation_id").val();
            const accountTypeId = $("#account_type_id").val();
            const $errorDiv = $("#error-organisation");
            const $errorDiv2 = $("#error-account-type");

            $errorDiv.text("");

            if (!orgId) {
                e.preventDefault();
                $errorDiv.text("Please select Organisation first.");
                return;
            }

            if (orgId != 2 && !accountTypeId) {
                e.preventDefault();
                $errorDiv2.text("Please select Division first.");
                return;
            }
        });

        function toggleExpenseHeadBtn() {
            const orgId = $("#organisation_id").val();
            const accountTypeId = $("#account_type_id").val();

            if (!orgId) {
                $("#addExpenseHeadBtn").addClass("hidden");
                // $("#addVendorBtn").addClass("hidden");
                return;
            }

            if (orgId == 2) {
                $("#addExpenseHeadBtn").removeClass("hidden");
                $("#addVendorBtn").removeClass("hidden");
            } else {
                if (accountTypeId) {
                    $("#addExpenseHeadBtn").removeClass("hidden");
                    $("#addVendorBtn").removeClass("hidden");
                } else {
                    $("#addExpenseHeadBtn").addClass("hidden");
                    $("#addVendorBtn").addClass("hidden");
                }
            }
        }
        $("#organisation_id, #account_type_id").on("change", toggleExpenseHeadBtn);
        toggleExpenseHeadBtn();

        $("#organisation_id").on("change", function() {
            $("#error-organisation").text("");
        });
        $("#account_type_id").on("change", function() {
            $("#error-account-type").text("");
        });




        // $("#expenseForm").on("submit", function(e) {
        //     e.preventDefault();
        //     let formData = new FormData($('#expenseForm')[0]);

        //     $(".error-message").text("");
        //     $("input, select, textarea").removeClass("border-red-500");

        //     let isValid = true;
        //     let firstInvalidField = null;

        //     if ($.trim($("#organisation_id").val()) === "") {
        //         $("#error-organisation").text("Organisation is required");
        //         $("#organisation").addClass("border-red-500");
        //         if (!firstInvalidField) firstInvalidField = $("#organisation_id");
        //         isValid = false;
        //     }

        //     let orgId = $("#organisation_id").val();
        //     let filtered = accountTypes.filter(at => at.organisation_id == orgId);

        //     if (filtered.length > 0) {
        //         if ($.trim($("#account_type_id").val()) === "") {
        //             $("#error-account-type").text("Division is required");
        //             $("#account_type_id").addClass("border-red-500");
        //             if (!firstInvalidField) firstInvalidField = $("#account_type_id");
        //             isValid = false;
        //         }
        //     }

        //     if ($.trim($("#payment_type_id").val()) === "") {
        //         $("#error-payment-type").text("Payment Type is required");
        //         $("#payment_type_id").addClass("border-red-500");
        //         if (!firstInvalidField) firstInvalidField = $("#payment_type_id");
        //         isValid = false;
        //     } else {
        //         $("#error-payment-type").text("");
        //         $("#payment_type_id").removeClass("border-red-500");
        //     }

        //     if ($.trim($("#expense_head_id").val()) === "") {
        //         $("#error-expense-head").text("Expense Head is required");
        //         $("#expense_head_id").addClass("border-red-500");
        //         if (!firstInvalidField) firstInvalidField = $("#expense_head_id");
        //         isValid = false;
        //     }

        //     if ($.trim($("input[name='transaction_amount']").val()) === "") {
        //         $("#error-transaction-amount").text("Transaction Amount is required");
        //         $("input[name='transaction_amount']").addClass("border-red-500");
        //         if (!firstInvalidField) firstInvalidField = $("#transaction_amount");

        //         isValid = false;
        //     }

        //     if ($.trim($("input[name='transaction_date']").val()) === "") {
        //         $("#error-date").text("Transaction Date is required");
        //         $("input[name='transaction_date']").addClass("border-red-500");
        //         if (!firstInvalidField) firstInvalidField = $("#transaction_date");

        //         isValid = false;
        //     }

        //     // start custom for expense type and vendor list
        //     let type = $("input[name='type']:checked").val();
        //     let payeeType = $("input[name='payee_type']:checked").val();



        //     if (payeeType === "internal") {
        //         if ($.trim($("#payeeHidden").val()) === "") {
        //             $("#error-asset-payee").text("Please select a Staff member");
        //             $("#payeeInput").addClass("border-red-500");
        //             if (!firstInvalidField) firstInvalidField = $("#payeeHidden");

        //             isValid = false;
        //         }
        //     }

        //     if (payeeType === "external") {
        //         if ($.trim($("#vendorTotalAmount").val()) === "") {
        //             $("#error-asset-payee-amount").text("Total Amount is required for Vendor payments");
        //             $("#vendorTotalAmount").addClass("border-red-500");
        //             if (!firstInvalidField) firstInvalidField = $("#vendorTotalAmount");

        //             isValid = false;
        //         }
        //         if ($.trim($("#payeeHidden").val()) === "") {
        //             $("#error-asset-payee").text("Please select a Vendor");
        //             $("#payeeInput").addClass("border-red-500");
        //             if (!firstInvalidField) firstInvalidField = $("#payeeHidden");

        //             isValid = false;
        //         }

        //     }

        //     // end customValidation

        //     if (!isValid) {
        //         if (firstInvalidField) {
        //             $('html, body').animate({
        //                 scrollTop: firstInvalidField.offset().top - 100
        //             }, 500);
        //             // firstInvalidField.focus();
        //         }
        //         return;
        //     }

        //     $.ajax({
        //         url: "{{ route('expense.store') }}",
        //         type: "POST",
        //         data: formData,
        //         processData: false,
        //         contentType: false,
        //         success: function(response) {
        //             if (response.success) {
        //                 /* alert(response.message);
        //                 window.location.href = "{{ route('expense.index') }}"; */
        //                 $('#transaction_expense').disable();
        //                  Swal.fire({
        //                     icon: 'success',
        //                     title: 'Success!',
        //                     text:response.message,
        //                     timer: 2000,
        //                     showConfirmButton: false
        //                 }).then(() => {
        //                     window.location.href = "{{ route('expense.index') }}";
        //                 });

        //             } else {
        //                 alert("Something went wrong.");
        //             }
        //         },
        //         error: function(xhr) {
        //             if (xhr.status === 422) {
        //                 let errors = xhr.responseJSON.errors;
        //                 let messages = [];
        //                 for (let key in errors) {
        //                     messages.push(errors[key][0]);
        //                 }
        //                 alert(messages.join("\n"));


        //             } else {
        //                 alert("Something went wrong. Please try again.");
        //                 alert("Error: " + xhr.status + " - " + xhr.responseText);

        //             }
        //         }
        //     });
        // });

        $("#expenseForm").on("submit", function(e) {
            e.preventDefault();

            // Disable the submit button immediately
            let $submitBtn = $("#transaction_expense");
            $submitBtn.prop("disabled", true);

            let formData = new FormData($('#expenseForm')[0]);

            $(".error-message").text("");
            $("input, select, textarea").removeClass("border-red-500");

            let isValid = true;
            // let firstInvalidField = $("#expense_head_id");
            let firstInvalidField = null;   

            if ($.trim($("#organisation_id").val()) === "") {
                $("#error-organisation").text("Organisation is required");
                $("#organisation_id").addClass("border-red-500");
                // if (!firstInvalidField) firstInvalidField = $("#organisation_id");
                isValid = false;
            }

            let orgId = $("#organisation_id").val();
            let filtered = accountTypes.filter(at => at.organisation_id == orgId);
            if ($.trim($("#payment_type_id").val()) === "") {
                $("#error-payment-type").text("Payment Type is required");
                $("#payment_type_id").addClass("border-red-500");
                // if (!firstInvalidField) firstInvalidField = $("#payment_type_id");
                isValid = false;
            }

            if ($.trim($("#expense_head_id").val()) === "") {
                $("#error-expense-head").text("Expense Head is required");  
                $("#expense_head_id").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("#expense_head_id");
                isValid = false;
            }

            if ($.trim($("input[name='transaction_amount']").val()) === "") {
                $("#error-transaction-amount").text("Transaction Amount is required");
                $("input[name='transaction_amount']").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("input[name='transaction_amount']");
                isValid = false;
            }

            if ($.trim($("input[name='transaction_date']").val()) === "") {
                $("#error-date").text("Transaction Date is required");
                $("input[name='transaction_date']").addClass("border-red-500");
                if (!firstInvalidField) firstInvalidField = $("input[name='transaction_date']");
                isValid = false;
            }

            // Custom for expense type and vendor list
            let type = $("input[name='type']:checked").val();
            let payeeType = $("input[name='payee_type']:checked").val();

            if (payeeType === "internal") {
                if ($.trim($("#payeeHidden").val()) === "") {
                    $("#error-asset-payee").text("Please select a Staff member");
                    $("#payeeInput").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#payeeHidden");
                    isValid = false;
                }
            }

            if (payeeType === "external") {
                if ($.trim($("#vendorTotalAmount").val()) === "") {
                    $("#error-asset-payee-amount").text("Total Amount is required for Vendor payments");
                    $("#vendorTotalAmount").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#vendorTotalAmount");
                    isValid = false;
                }
                if ($.trim($("#payeeHidden").val()) === "") {
                    $("#error-asset-payee").text("Please select a Vendor");
                    $("#payeeInput").addClass("border-red-500");
                    if (!firstInvalidField) firstInvalidField = $("#payeeHidden");
                    isValid = false;
                }
            }

            if (!isValid) {
                // Re-enable submit button if validation fails
                $submitBtn.prop("disabled", false);

                if (firstInvalidField) {
                    $('html, body').animate({
                        scrollTop: firstInvalidField.offset().top - 200
                    }, 500);
                    
                }
                return;
            }

            $.ajax({
                url: "{{ route('expense.store') }}",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: response.message,
                            timer: 2000,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = "{{ route('expense.index') }}";
                        });
                    } else {
                        alert("Something went wrong.");
                        // Re-enable button if server returns failure
                        $submitBtn.prop("disabled", false);
                    }
                },
                error: function(xhr) {
                    alert("Something went wrong. Please try again.");
                    // Re-enable button if AJAX fails
                    $submitBtn.prop("disabled", false);
                }
            });
        });


        $("#organisation_id").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-organisation").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("#expense_head_id").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-expense-head").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("#payment_type_id").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-payment-type").text("");
                $(this).removeClass("border-red-500");
            }
        });
        $("#account_type_id").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-account-type").text("");
                $(this).removeClass("border-red-500");
            }
        });


        $("input[name='transaction_amount']").on("input", function() {
            if ($(this).val().trim() !== "") {
                $("#error-transaction-amount").text("");
                $(this).removeClass("border-red-500");
            }
        });

        $("input[name='transaction_reference']").on("input", function() {
            if ($(this).val().trim() !== "") {
                $("#error-transaction-reference").text("");
                $(this).removeClass("border-red-500");
            }
        });

        $("input[name='transaction_date']").on("change", function() {
            if ($(this).val().trim() !== "") {
                $("#error-date").text("");
                $(this).removeClass("border-red-500");
            }
        });

        $("textarea[name='transaction_narration']").on("input", function() {
            if ($(this).val().trim() !== "") {
                $("#error-transaction-narration").text("");
                $(this).removeClass("border-red-500");
            }
        });



        $("#payeeList").on("click", "li", function() {
            $("#payeeHidden").val($(this).data("id"));
            $("#payeeInput").val($(this).text());
            $("#error-asset-payee").text("");
            $("#payeeInput").removeClass("border-red-500");

            $("#payeeList").addClass("hidden");
        });
        $("#vendorTotalAmount").on("input", function() {
            if ($(this).val().trim() !== "") {
                $("#error-asset-payee-amount").text("");
                $(this).removeClass("border-red-500");
            }
        });

    });

    $("#transaction_reference").on("input", function() {
        let value = $(this).val();
        value = value.replace(/[^A-Za-z0-9]/g, "");
        if (value.length > 20) {
            value = value.substring(0, 20);
        }
        $(this).val(value);
        let errorDiv = $("#error-transaction-reference");
        if (value.length < 5) {
            errorDiv.text("Transaction reference must be at least 5 characters.");
        } else {
            errorDiv.text("");
        }
    });



    // for vendor listing:
    document.addEventListener("DOMContentLoaded", function() {
        const radios = document.querySelectorAll(".payee-type-radio");
        const payeeWrapper = document.getElementById("payeeWrapper");
        const payeeInput = document.getElementById("payeeInput");
        const payeeList = document.getElementById("payeeList");
        const payeeHidden = document.getElementById("payeeHidden");
        const clearBtn = document.getElementById("clearPayeeSelection");
        const vendorAmountWrapper = document.getElementById("vendorAmountWrapper");


        let currentType = null;

        radios.forEach(radio => {
            radio.addEventListener("change", function() {
                currentType = this.value;
                payeeWrapper.classList.remove("hidden");
                payeeInput.value = "";
                payeeHidden.value = "";
                payeeList.classList.add("hidden");
                clearBtn.classList.remove("hidden");
                vendorAmountWrapper.classList.add("hidden");
                payeeInput.readOnly = false;
            });
        });

        payeeInput.addEventListener("input", function() {
            this.value = this.value.replace(/[^a-zA-Z\s]/g, '');

            const filter = this.value.toLowerCase();
            let hasMatch = false;
            payeeList.querySelectorAll("li").forEach(li => {
                if (li.dataset.type === currentType &&
                    li.textContent.toLowerCase().includes(filter)) {
                    li.style.display = "block";
                    hasMatch = true;
                } else {
                    li.style.display = "none";
                }
            });
            payeeList.classList.toggle("hidden", !hasMatch || filter === "");
        });

        payeeList.addEventListener("click", function(e) {

            if (e.target.tagName === "LI") {
                payeeInput.value = e.target.textContent;
                payeeHidden.value = e.target.dataset.id;
                payeeList.classList.add("hidden");
                payeeInput.readOnly = true;
            }

            if (e.target.dataset.type === "external") {
                vendorAmountWrapper.classList.remove("hidden");
            } else {
                vendorAmountWrapper.classList.add("hidden");
            }
        });

        clearBtn.addEventListener("click", function() {
            radios.forEach(r => r.checked = false);
            payeeWrapper.classList.add("hidden");
            payeeInput.value = "";
            payeeHidden.value = "";
            payeeList.classList.add("hidden");
            vendorAmountWrapper.classList.add("hidden");
            currentType = null;
            payeeInput.readOnly = false;
        });
    });
    // end for vendor listing:

    //start for vendor add logic

    $('#addVendorBtn').on('click', function() {
        let selectedType = $("input[name='payee_type']:checked").val();

        if (selectedType) {
            $("#vendor_type_new").val(selectedType);
        } else {
            $("#vendor_type_new").val("");
        }
        $('#vendorModal').removeClass('hidden');
    });

    $('#closeVendorModal').on('click', () => $('#vendorModal').addClass('hidden'));

    $('#saveVendor').on('click', function() {
        const vendorName = $('#vendor_name').val().trim();
        const errorEl = $('#error-vendor-name');

        errorEl.text('');

        if (!vendorName.match(/^[a-zA-Z\s]+$/)) {
            errorEl.text('Vendor name must contain only letters and spaces.');
            return;
        }

        let vendorData = {
            _token: "{{ csrf_token() }}",
            vendor_type: $('#vendor_type_new').val(),
            vendor_name: $('#vendor_name').val(),
            vendor_contact_person: $('#vendor_contact_person').val() ?? null,
            vendor_phone_number: $('#vendor_phone_number').val(),
            vendor_email: $('#vendor_email').val(),
            vendor_address: $('#vendor_address').val(),
            vendor_gst_number: $('#vendor_gst_number').val(),
            vendor_pan_number: $('#vendor_pan_number').val(),
            vendor_payment_terms: $('#vendor_payment_terms').val() ?? null,
            vendor_bank_account_number: $('#vendor_bank_account_number').val(),
            vendor_bank_ifsc: $('#vendor_bank_ifsc').val(),

        };

        $.ajax({
            url: "{{ route('vendor.store') }}",
            type: "POST",
            data: vendorData,
            success: function(res) {
                if (res.success) {
                    $('#vendorModal').addClass('hidden');
                    $('#vendorSuccessModal').removeClass('hidden');

                    $('#payeeVendorRadio').prop('checked', true).trigger('change');

                    $('#payeeInput').val(res.vendor.vendor_name);
                    $('#payeeHidden').val(res.vendor.vendor_id);

                    if (res.vendor.vendor_type === "external") {
                        $('#vendorAmountWrapper').removeClass('hidden');
                        $('#amountPaidWrapper').removeClass('hidden');
                    } else {
                        $('#vendorAmountWrapper').addClass('hidden');
                        $('#amountPaidWrapper').removeClass('hidden');
                    }

                } else {
                    $('#vendorErrorMessage').text(res.message || "Failed to save vendor.");
                    $('#vendorErrorModal').removeClass('hidden');
                }
            },
            error: function(xhr) {
                console.error(xhr.responseText);
                $('#vendorErrorMessage').text("Error: Could not save vendor.");
                $('#vendorErrorModal').removeClass('hidden');
            }
        });
    });

    $('#vendorCloseSuccessModal').on('click', () => $('#vendorSuccessModal').addClass('hidden'));
    $('#vendorCloseErrorModal').on('click', () => $('#vendorErrorModal').addClass('hidden'));


    // end for vendor add logic

    //for file upload logic and append names
    document.getElementById('expense_files').addEventListener('change', function(e) {
        const fileList = document.getElementById('file-list');
        const errorDiv = document.getElementById('error-expense-files');
        fileList.innerHTML = "";
        errorDiv.textContent = "";

        const maxTotalSize = 3 * 1024 * 1024;
        let totalSize = 0;
        let hasInvalidType = false;

        for (let i = 0; i < this.files.length; i++) {
            const file = this.files[i];
            totalSize += file.size;

            if (!file.type.startsWith("image/") && file.type !== "application/pdf") {
                hasInvalidType = true;
            }
        }
        if (totalSize > maxTotalSize) {
            // alert("Total file size must not exceed 3 MB.\nYou selected " + (totalSize / (1024 * 1024)).toFixed(
            //     2) + " MB.");
            errorDiv.textContent = "Total file size must not exceed 3 MB.\nYou selected " + (totalSize / (1024 *
                1024)).toFixed(
                2) + " MB.";
            this.value = "";
            return;
        }
        if (hasInvalidType) {
            // alert("Invalid file type. Only images or PDFs allowed.");
            errorDiv.textContent = "Invalid file type. Only images or PDFs up to 3 MB are allowed.";
            this.value = "";
            return;
        }

        for (let i = 0; i < this.files.length; i++) {
            const li = document.createElement("li");
            li.textContent = this.files[i].name;
            fileList.appendChild(li);
        }
    });
    // end for file upload logic and append names

    function cleanAmount(val) {
        val = val.replace(/[^0-9.]/g, "");

        let parts = val.split(".");
        if (parts.length > 2) {
            val = parts[0] + "." + parts.slice(1).join("");
        }
        if (/^0[0-9]/.test(val)) {
            val = val.replace(/^0+/, "");
        }

        if (val.startsWith("0.") || val === "0") {
            val = val.replace(/^0+/, "");
        }
        return val;
    }

    $("input[name='transaction_amount'], input[name='vendor_total_amount']").on("input", function() {
        this.value = cleanAmount(this.value);
    });


    // start: add expense heads logic.
    $("#addExpenseHeadBtn").on("click", function() {

        $("#expense_account_type_id").val($("#account_type_id").val());
        $("#expense_organisation_id_new").val($("#organisation_id").val());

        $("#expenseHeadModal").removeClass("hidden");
    });

    $("#closeExpenseHeadModal").on("click", function() {
        $("#expenseHeadModal").addClass("hidden");
    });
    $("#closeExpenseSuccessModal").on("click", function() {
        $("#expenseSuccessModal").addClass("hidden");
    });

    $("#closeExpenseErrorModal").on("click", function() {
        $("#expenseErrorModal").addClass("hidden");
    });

    $("#saveExpenseHeadBtn").on("click", function() {
        let payload = {
            _token: $("meta[name='csrf-token']").attr("content"),
            organisation_id: $('#expense_organisation_id_new').val().trim(),
            expense_head_name: $("#expense_head_name").val().trim(),
            account_type_id: $("#expense_account_type_id").val() || null,
            expense_head_group_id: $("#expense_head_group_id").val() || null,
            expense_head_group_opening_balance: $("#expense_head_group_opening_balance").val() || null
        };

        $.ajax({
            url: "{{ route('expensehead.store') }}",
            type: "POST",
            data: JSON.stringify(payload),
            contentType: "application/json",
            success: function(response) {
                if (response.success) {
                    $("#expenseHeadModal").addClass("hidden");
                    $("#expenseSuccessModal").removeClass("hidden");
                    let select = $("#expense_head_id");
                    let option = $("<option>")
                        .val(response.new_id)
                        .text(response.name)
                        .prop("selected", true);
                    select.append(option);
                    $("#expense_head_name").val("");
                    $("#expense_account_type_id").val("");
                    $("#expense_head_group_id").val("");
                    $("#expense_head_group_opening_balance").val("");
                }
            },
            error: function(xhr) {
                let res = xhr.responseJSON;
                if (res && res.errors) {
                    let messages = Object.values(res.errors).flat().join("<br>");
                    $("#expenseErrorMessage").html(messages);
                } else {
                    $("#expenseErrorMessage").text("Something went wrong.");
                }
                $("#expenseErrorModal").removeClass("hidden");
            }
        });
    });
    // end logic add expense heads:

    const vendorName = document.getElementById("vendor_name");
    const vendorContact = document.getElementById("vendor_contact_person");
    const vendorPhone = document.getElementById("vendor_phone_number");
    const vendorPAN = document.getElementById("vendor_pan_number");
    const vendorIFSC = document.getElementById("vendor_bank_ifsc");

    // Vendor Name - only letters and spaces
    vendorName.addEventListener("input", function() {
        this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
        document.getElementById("error-vendor-name").textContent =
            this.value === '' ? "Vendor name must contain only letters and spaces." : "";
    });
</script>
@endsection