@extends('master.authMaster')


@section('content')
    <div class="ledgers-page-sec col-span-12 lg:col-span-12">



        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">

            <!-- Sidebar / Filter Box -->
            <div class="w-full bg-white border-r">

                {{-- @foreach ($incomeHeads as $incomeHead)
                    @foreach ($ledgerIncomeHeads as $ledgerIncomeHead)
                        @if ($incomeHead->income_head_id == $ledgerIncomeHead->income_head)
                            <ul id="tabMenu" class="income-head">

                                <li data-tab="tab1">
                                    <a href="{{ route('ledger.income.head.details', $ledgerIncomeHead->income_head) }}">
                                        {{ ucfirst($incomeHead->income_head_name) }}
                                    </a>
                                </li>
                                <li>
                                    ₹ {{ $ledgerIncomeHead->total_amount }}
                                    <span><a href="{{ route('ledger.income.head.details', $ledgerIncomeHead->income_head) }}"
                                            class="edit-btn"> View Details </a></span>
                                </li>

                            </ul>
                        @endif
                    @endforeach
                @endforeach --}}

                <div class="container">

                    <h2 class="text-lg font-semibold p-4 border-b">Income Ledger</h2>
                    @if ($incomeHeadsByGroup->isEmpty() && $incomeHeadsWithoutGroup->isEmpty())
                        <p class="p-4 text-gray-500">No Income heads data found for this financial year.Please<a
                                href="{{ route('income.create') }}" style="color: blue"> Add Data</a> from Income
                            Screen.</p>
                    @else
                        @foreach ($incomeHeadGroups as $group)
                            @if (isset($incomeHeadsByGroup[$group->income_head_group_ID]))
                                <div class="incm-ledg-sngl-box">
                                    <h3 class="font-bold mt-4">{{ Ucfirst($group->income_head_group_Name) }}</h3>
                                    <ul class="income-head list-disc pl-6">
                                        @foreach ($incomeHeadsByGroup[$group->income_head_group_ID] as $head)
                                            <li class="mb-1">
                                                {{ $head->income_head_name }} -
                                                ₹ {{ $ledgerIncomeHeads[$head->income_head_id]->total_amount ?? 0 }}
                                                <span>
                                                    <a href="{{ route('ledger.income.head.details', $head->income_head_id) }}"
                                                        class="text-blue-600 underline">View Details</a>
                                                </span>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                        @endforeach

                        @if ($incomeHeadsWithoutGroup->isNotEmpty())
                            <div class="incm-ledg-sngl-box">
                                <h3 class="font-bold mt-6">Ungrouped Income Heads</h3>
                                <ul class="income-head list-disc pl-6">
                                    @foreach ($incomeHeadsWithoutGroup as $head)
                                        <li class="mb-1">
                                            {{ $head->income_head_name }} -
                                            ₹ {{ $ledgerIncomeHeads[$head->income_head_id]->total_amount ?? 0 }}
                                            <span>
                                                <a href="{{ route('ledger.income.head.details', $head->income_head_id) }}"
                                                    class="text-blue-600 underline">View Details</a>
                                            </span>
                                        </li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                    @endif
                </div>

            </div>


        </div>
        <div class="mt-6">
            <button onclick="history.back()"
                class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                ← Back
            </button>
        </div>
        <script>
            const tabs = document.querySelectorAll("#tabMenu li");
            const contents = document.querySelectorAll(".tab-content");

            function activateTab(tab) {
                // reset all
                tabs.forEach(el => el.classList.remove("border-blue-600", "bg-blue-50"));
                contents.forEach(c => c.classList.remove("active"));

                // activate clicked tab
                tab.classList.add("border-blue-600", "bg-blue-50");
                document.getElementById(tab.dataset.tab).classList.add("active");
            }

            // --- don't auto-open any tab on load ---
            // if (tabs.length > 0) {
            //   activateTab(tabs[0]);
            // }

            // click handling
            tabs.forEach(tab => {
                tab.addEventListener("click", () => activateTab(tab));
            });
        </script>



    </div>
@endsection
