@extends('master.authMaster')

@section('content')
    <div class="ledgers-page-sec bg-gray-100 col-span-12 lg:col-span-12 account-brot-for-pg">
        <div class="ledgers-page-wraper flex w-full bg-white shadow-md rounded-2xl overflow-hidden">
            <div class="w-full p-4">
                <div class="content-box">

                    <!-- Header -->
                    <div class="flex justify-between items-center">
                        <h3 class="text-base font-medium text-black">
                            {{ ucfirst($flag) }} Transaction History
                        </h3>
                    </div>
                    <ul class="listing-top" style="background-color: #3182ce14">
                        <li class="p-3">Total {{ ucfirst($flag) }} Amount Brought Forward</li>
                        <li class="p-3 text-right text-black font-semibold">
                            {{ number_format($forwardCapital, 2) }}
                        </li>
                    </ul>

                    @php
                        $sl = 1;
                    @endphp

                    <div class="sngl-box">
                        <table class="w-full text-left border-collapse shadow-sm rounded-lg overflow-hidden mb-3">
                            {{-- Forward Capital --}}

                            <thead>
                                <tr>
                                    <td>Sl No.</td>
                                    <td>Date</td>
                                    <td>Income/Expense Heads</td>
                                    <td>Narration & Vendor/Donor Name</td>
                                    <td class="text-right">Amount</td>
                                </tr>

                            </thead>
                            <tbody class="divide-y">

                                @php
                                    use Carbon\Carbon;

                                    // Step 1: Prepare array of IDs with type and date
                                    $transactionPointers = [];

                                    foreach ($incomeDatas as $income) {
                                        $transactionPointers[] = [
                                            'type' => 'income',
                                            'id' => $income->income_id,
                                            'date' => $income->transaction_date ?? $income->created_at,
                                        ];
                                    }

                                    foreach ($expenseDatas as $expense) {
                                        $transactionPointers[] = [
                                            'type' => 'expense',
                                            'id' => $expense->expense_id,
                                            'date' => $expense->transaction_date ?? $expense->created_at,
                                        ];
                                    }

                                    // Step 2: Sort by date descending
                                    usort($transactionPointers, function ($a, $b) {
                                        return Carbon::parse($b['date'])->timestamp <=>
                                            Carbon::parse($a['date'])->timestamp;
                                    });

                                    // Step 3: Initialize totals
                                    $incomeTotal = 0;
                                    $expenseTotal = 0;
                                @endphp

                            <tbody class="divide-y">


                                {{-- Step 4: Loop through the sorted pointers --}}
                                @foreach ($transactionPointers as $ptr)
                                    @if ($ptr['type'] === 'income')
                                        @php
                                            $data = $incomeDatas->firstWhere('income_id', $ptr['id']);
                                            $incomeTotal += $data->transaction_amount;
                                        @endphp
                                        <tr class="hover:bg-gray-50 bg-green-50">
                                            <td class="p-3">{{$sl++}}</td>
                                            <td class="p-3">
                                                {{ Carbon::parse($data->transaction_date ?? $data->created_at)->format('d-m-Y') }}
                                            </td>
                                            <td class="p-3">{{ $data->incomeHead->income_head_name ?? '-' }}</td>
                                            <td class="p-3">
                                                {{ $data->transaction_narration ?? '-' }}
                                                @if ($data->donor)
                                                    ({{ $data->donor->donor_name }})
                                                @endif
                                            </td>
                                            <td class="p-3 text-right text-green-600 font-semibold">
                                                +{{ number_format($data->transaction_amount, 2) }}
                                            </td>
                                        </tr>
                                    @else
                                        @php
                                            $data = $expenseDatas->firstWhere('expense_id', $ptr['id']);
                                            $expenseTotal += $data->transaction_amount;
                                        @endphp
                                        <tr class="hover:bg-gray-50 bg-red-50">
                                            <td class="p-3">{{$sl++}}</td>
                                            <td class="p-3">
                                                {{ Carbon::parse($data->transaction_date ?? $data->created_at)->format('d-m-Y') }}
                                            </td>
                                            <td class="p-3">{{ $data->expenseHead->expense_head_name ?? '-' }}</td>
                                            <td class="p-3">
                                                {{ $data->transaction_narration ?? '-' }}
                                                @if ($data->vendor)
                                                    ({{ $data->vendor->vendor_name }})
                                                @elseif ($data->staffVendor)
                                                    ({{ $data->staffVendor->vendor_name ?? $data->staffVendor->name }})
                                                @endif
                                            </td>
                                            <td class="p-3 text-right text-red-600 font-semibold">
                                                -{{ number_format($data->transaction_amount, 2) }}
                                            </td>
                                        </tr>
                                    @endif
                                @endforeach
                            </tbody>

                            <tfoot>
                                <tr>
                                    <td colspan="4" class="p-3 text-right font-semibold">Total Income</td>
                                    <td class="p-3 text-right font-bold text-green-600">
                                        {{ number_format($incomeTotal, 2) }}</td>
                                </tr>
                                <tr>
                                    <td colspan="4" class="p-3 text-right font-semibold">Total Expense</td>
                                    <td class="p-3 text-right font-bold text-red-600">{{ number_format($expenseTotal, 2) }}
                                    </td>
                                </tr>
                                <tr>
                                    @php $grandTotal = $forwardCapital + ($incomeTotal - $expenseTotal); @endphp
                                    <td colspan="4" class="p-3 text-right font-semibold">Grand Total</td>
                                    <td
                                        class="p-3 text-right font-bold {{ $grandTotal >= 0 ? 'text-green-700' : 'text-red-700' }}">
                                        {{ number_format($grandTotal, 2) }}
                                    </td>
                                </tr>
                            </tfoot>

                        </table>
                    </div>

                    <div class="mt-6">
                        <button onclick="history.back()"
                            class="px-4 py-2 rounded-lg bg-gray-500 hover:bg-gray-600 text-white shadow text-sm transition">
                            ← Back
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
