@extends('master.authMaster')

@section('content')
    <div class="intro-y col-span-12 lg:col-span-12">

        <!-- BEGIN: Select Options -->
        <div class="intro-y box mt-5" style="padding: 20px 20px 20px 30px;">
            <h2 class="text-xl font-bold mb-6">Add Asset Brought Forward</h2>
            @php
                $currentOrg = \App\Models\Organisation::current();
                $orgId = $currentOrg ? $currentOrg->organisation_id : null;
            @endphp

            @if ($errors->any())
                <div class="rounded-md flex items-center px-5 py-4 mb-4 border border-theme-6 text-theme-6">
                    <ul class="list-disc list-inside">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form id="assetBroughtForwardForm" action="{{ route('asset.brought.forward.store') }}" method="POST">
                @csrf
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <div class="mt-3">
                            <input type="hidden" name="organisation_id" value="{{ $orgId ?? '' }}">
                            <label>Organisation <span style="color: red">*</span></label>
                            <select id="organisation_id" class="input w-full border mt-2" disabled>
                                <option value="">-- Select Organisation --</option>
                                @php
                                    $organisations = \App\Models\Organisation::where('status', 'active')->get();
                                @endphp
                                @foreach ($organisations as $organisation)
                                    <option value="{{ $organisation->organisation_id }}"
                                        {{ old('organisation_id', $orgId) == $organisation->organisation_id ? 'selected' : '' }}>
                                        {{ $organisation->organisation_name }}
                                    </option>
                                @endforeach
                            </select>
                            @if (!$orgId)
                                <div class="text-red-500 text-sm mt-1">Please select a current organisation first.</div>
                            @endif
                        </div>
                    </div>

                    <div>
                        <div class="mt-3">
                            <label>Accounting Year <span class="text-red-500">*</span></label>
                            <select id="accounting_year_id" name="accounting_year_id"
                                class="w-full border p-2 rounded mt-2 @error('accounting_year_id') border-red-500 @enderror"
                                required>
                                <option value="">-- Select Accounting Year --</option>
                                @foreach ($years as $year)
                                    <option value="{{ $year->accounting_year_id }}"
                                        {{ old('accounting_year_id') == $year->accounting_year_id ? 'selected' : '' }}>
                                        {{ $year->accounting_year_financial }}
                                    </option>
                                @endforeach
                            </select>
                            @error('accounting_year_id')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-accounting-year"></div>
                        </div>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <div class="mt-3">
                            <label>Total Asset Amount <span class="text-red-500">*</span></label>
                            <input type="text" id="total_asset_amount" name="total_asset_amount"
                                class="w-full border p-2 rounded mt-2 @error('total_asset_amount') border-red-500 @enderror"
                                value="{{ old('total_asset_amount') }}" placeholder="Enter Total Asset Amount" required>
                            @error('total_asset_amount')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-total-amount"></div>
                        </div>
                    </div>
                    <div>
                        <div class="mt-3">
                            <label>Transaction Date <span class="text-red-500">*</span></label>
                            <input type="date" id="transaction_date" name="transaction_date"
                                class="w-full border p-2 rounded mt-2 @error('transaction_date') border-red-500 @enderror"
                                value="{{ old('transaction_date') }}" required>
                            @error('transaction_date')
                                <div class="text-red-500 text-sm mt-1">{{ $message }}</div>
                            @enderror
                            <div class="text-red-500 text-sm mt-1 error-message" id="error-transaction-date"></div>
                        </div>
                    </div>
                </div>

                <div class="mt-5">
                    <a href="{{ route('asset.brought.forward.index') }}"
                        class="px-4 py-2 rounded bg-gray-500 hover:bg-gray-600 text-white shadow text-sm mr-3">Cancel</a>
                    <button type="submit" id="save-btn" class="button w-24 bg-theme-1 text-white">Save</button>
                </div>
            </form>

        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Format number input
            $('#total_asset_amount').on('input', function() {
                let val = this.value;
                val = val.replace(/[^0-9.]/g, "");
                let parts = val.split(".");
                if (parts.length > 2) {
                    val = parts[0] + "." + parts.slice(1).join("");
                }
                this.value = val;
            });

            $('#assetBroughtForwardForm').on('submit', function(e) {
                let form = $(this)[0];
                if (form.checkValidity()) {
                    $('#save-btn').prop('disabled', true).text('Submitting...');
                    return true;
                } else {
                    e.preventDefault();
                    form.reportValidity();
                    return false;
                }
            });
        });
    </script>
@endsection
