<?php

namespace Database\Seeders;

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class BankSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $banks = [
            [
                'name' => 'State Bank of Artemis',
                'short_code' => 'SBA',
                'ifsc_code' => 'SBAR0001234',
                'branch' => 'New Horizon Branch',
                'account_number' => '124567890123',
                'swift_code' => 'SBARINBB001',
                'micr_code' => '400002345',
                'contact_person' => 'Priya Sharma',
                'contact_number' => '9876543210',
                'email' => 'contact@sba-example.com',
                'address_line1' => '12 Skyline Avenue',
                'address_line2' => '4th Floor',
                'city' => 'Mumbai',
                'state' => 'Maharashtra',
                'country' => 'India',
                'postal_code' => '400001',
            ],
            [
                'name' => 'Heritage Cooperative Bank',
                'short_code' => 'HCB',
                'ifsc_code' => 'HERI0009876',
                'branch' => 'Central Heritage Branch',
                'account_number' => '223456789012',
                'swift_code' => 'HERIINBB002',
                'micr_code' => '110002345',
                'contact_person' => 'Arun Patel',
                'contact_number' => '9123456780',
                'email' => 'hello@heritagecoop.com',
                'address_line1' => '45 Heritage Lane',
                'address_line2' => 'Suite 8',
                'city' => 'New Delhi',
                'state' => 'Delhi',
                'country' => 'India',
                'postal_code' => '110001',
            ],
            [
                'name' => 'Riverfront Savings Bank',
                'short_code' => 'RSB',
                'ifsc_code' => 'RIVF0004567',
                'branch' => 'Riverfront Promenade',
                'account_number' => '334567890123',
                'swift_code' => 'RIVFINBB003',
                'micr_code' => '560002345',
                'contact_person' => 'Meera Nair',
                'contact_number' => '9034567812',
                'email' => 'support@riverfrontbank.com',
                'address_line1' => '88 Riverside Road',
                'address_line2' => 'Block B',
                'city' => 'Bengaluru',
                'state' => 'Karnataka',
                'country' => 'India',
                'postal_code' => '560001',
            ],
            [
                'name' => 'Evergreen Urban Bank',
                'short_code' => 'EUB',
                'ifsc_code' => 'EVER0007654',
                'branch' => 'Green Meadows Branch',
                'account_number' => '445678901234',
                'swift_code' => 'EVERINBB004',
                'micr_code' => '700002345',
                'contact_person' => 'Rohit Sen',
                'contact_number' => '9988776655',
                'email' => 'service@evergreenurban.com',
                'address_line1' => '22 Garden Street',
                'address_line2' => 'Near City Park',
                'city' => 'Kolkata',
                'state' => 'West Bengal',
                'country' => 'India',
                'postal_code' => '700001',
            ],
            [
                'name' => 'Summit National Bank',
                'short_code' => 'SNB',
                'ifsc_code' => 'SUMT0003210',
                'branch' => 'Summit Heights Branch',
                'account_number' => '556789012345',
                'swift_code' => 'SUMTINBB005',
                'micr_code' => '600002345',
                'contact_person' => 'Divya Reddy',
                'contact_number' => '9012345678',
                'email' => 'info@summitnb.com',
                'address_line1' => '18 Cloudline Avenue',
                'address_line2' => 'Summit Towers',
                'city' => 'Chennai',
                'state' => 'Tamil Nadu',
                'country' => 'India',
                'postal_code' => '600002',
            ],
            [
                'name' => 'Lighthouse Community Bank',
                'short_code' => 'LCB',
                'ifsc_code' => 'LIGH0006543',
                'branch' => 'Beacon District Branch',
                'account_number' => '667890123456',
                'swift_code' => 'LIGHINBB006',
                'micr_code' => '682002345',
                'contact_person' => 'Manoj Thomas',
                'contact_number' => '9845123456',
                'email' => 'care@lighthousebank.com',
                'address_line1' => '9 Beacon Street',
                'address_line2' => 'Opp. Marine Plaza',
                'city' => 'Kochi',
                'state' => 'Kerala',
                'country' => 'India',
                'postal_code' => '682001',
            ],
            [
                'name' => 'Sunrise Mutual Bank',
                'short_code' => 'SMB',
                'ifsc_code' => 'SUNM0008521',
                'branch' => 'Sunrise Vista Branch',
                'account_number' => '778901234567',
                'swift_code' => 'SUNMINBB007',
                'micr_code' => '380002345',
                'contact_person' => 'Kiran Desai',
                'contact_number' => '9823456710',
                'email' => 'contact@sunrisemutual.com',
                'address_line1' => '56 Morning Glory Road',
                'address_line2' => 'Suite 5A',
                'city' => 'Ahmedabad',
                'state' => 'Gujarat',
                'country' => 'India',
                'postal_code' => '380001',
            ],
            [
                'name' => 'Harborline Trust Bank',
                'short_code' => 'HTB',
                'ifsc_code' => 'HARB0009632',
                'branch' => 'Coastal Harbor Branch',
                'account_number' => '889012345678',
                'swift_code' => 'HARBINBB008',
                'micr_code' => '403002345',
                'contact_person' => 'Anita Fernandes',
                'contact_number' => '9922334455',
                'email' => 'support@harborlinebank.com',
                'address_line1' => '101 Seaside Boulevard',
                'address_line2' => 'Palm Residency',
                'city' => 'Panaji',
                'state' => 'Goa',
                'country' => 'India',
                'postal_code' => '403001',
            ],
            [
                'name' => 'Aurora Financial Bank',
                'short_code' => 'AFB',
                'ifsc_code' => 'AURF0007412',
                'branch' => 'Aurora Heights Branch',
                'account_number' => '990123456789',
                'swift_code' => 'AURFINBB009',
                'micr_code' => '452002345',
                'contact_person' => 'Sneha Kapoor',
                'contact_number' => '9776655443',
                'email' => 'hello@aurorafinbank.com',
                'address_line1' => '64 Aurora Heights',
                'address_line2' => '5th Cross',
                'city' => 'Indore',
                'state' => 'Madhya Pradesh',
                'country' => 'India',
                'postal_code' => '452001',
            ],
            [
                'name' => 'Silverline Metro Bank',
                'short_code' => 'SMB2',
                'ifsc_code' => 'SILM0001597',
                'branch' => 'Metro Central Branch',
                'account_number' => '101234567890',
                'swift_code' => 'SILMINBB010',
                'micr_code' => '500002345',
                'contact_person' => 'Vikram Rao',
                'contact_number' => '9654321870',
                'email' => 'metro@silverlinebank.com',
                'address_line1' => '77 Metro Avenue',
                'address_line2' => 'Tech Hub',
                'city' => 'Hyderabad',
                'state' => 'Telangana',
                'country' => 'India',
                'postal_code' => '500001',
            ],
        ];

        $timestamp = Carbon::now();

        $banks = array_map(function (array $bank) use ($timestamp) {
            return array_merge($bank, [
                'is_active' => true,
                'created_at' => $timestamp,
                'updated_at' => $timestamp,
            ]);
        }, $banks);

        DB::table('banks')->insert($banks);
    }
}
