<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('income_heads', function (Blueprint $table) {
            $table->integer('organisation_id')->nullable()->after('income_head_id');
        });

        Schema::table('expense_heads', function (Blueprint $table) {
            $table->integer('organisation_id')->nullable()->after('expense_head_id');
            $table->integer('account_type_id')->nullable()->change();
        });
    }

    public function down(): void
    {
        Schema::table('income_heads', function (Blueprint $table) {
            $table->dropColumn('organisation_id');
        });

        Schema::table('expense_heads', function (Blueprint $table) {
            $table->dropColumn('organisation_id');
            $table->integer('account_type_id')->nullable(false)->change();
        });
    }
};
