<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        if (Schema::hasColumn('incomes', 'file_path')) {
            Schema::table('incomes', function (Blueprint $table) {
                $table->longText('file_path')->nullable()->change();
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasColumn('incomes', 'file_path')) {
            Schema::table('incomes', function (Blueprint $table) {
                $table->string('file_path', 255)->nullable()->change();
            });
        }
    }
};
