<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('asset_records', function (Blueprint $table) {
            $table->id();
            $table->integer('asset_id')->nullable();
            $table->integer('vendor_id')->nullable();
            $table->integer('journal_id')->nullable();
            $table->decimal('amount', 15, 2)->default(0.00);
            $table->enum('income_expense', ['income', 'expense'])->nullable();
            $table->enum('dr_cr', ['dr', 'cr'])->nullable();
            $table->timestamps();
        });
    }


    public function down(): void
    {
        Schema::dropIfExists('asset_records');
    }
};
