<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('tbl_account_types') && !Schema::hasTable('account_types')) {
            Schema::rename('tbl_account_types', 'account_types');
        }

        if (Schema::hasTable('tbl_expense_head_groups') && !Schema::hasTable('expense_head_groups')) {
            Schema::rename('tbl_expense_head_groups', 'expense_head_groups');
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('account_types') && !Schema::hasTable('tbl_account_types')) {
            Schema::rename('account_types', 'tbl_account_types');
        }

        if (Schema::hasTable('expense_head_groups') && !Schema::hasTable('tbl_expense_head_groups')) {
            Schema::rename('expense_head_groups', 'tbl_expense_head_groups');
        }
    }
};
