<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('incomes', function (Blueprint $table) {
            $table->integerIncrements('income_id');
            $table->integer('organisation_id')->nullable();
            $table->integer('financial_year_id')->nullable();
            $table->integer('account_type_id')->nullable();
            $table->integer('income_head')->nullable();
            $table->integer('user_id')->nullable();
            $table->string('transaction_reference')->nullable();
            $table->decimal('transaction_amount', 15, 2);
            $table->date('transaction_date');
            $table->text('transaction_narration')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('incomes');
    }
};
