<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->bigIncrements('transaction_id');
            $table->unsignedBigInteger('organisation_id')->nullable();
            $table->unsignedBigInteger('account_type_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->string('transaction_reference')->nullable()->nullable();
            $table->enum('transaction_type', ['income', 'expense'])->nullable();
            $table->decimal('transaction_amount', 15, 2)->nullable();
            $table->date('transaction_date')->nullable();
            $table->enum('dr_cr', ['Dr', 'Cr'])->nullable();
            $table->text('transaction_narration')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
