<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tbl_account_types', function (Blueprint $table) {
            $table->increments('account_type_id');
            $table->unsignedBigInteger('organisation_id');
            $table->string('account_type_Name');
            $table->string('account_type_Description')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();
        });
    }


    public function down(): void
    {
        Schema::dropIfExists('tbl_account_types');
    }
};
