<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Liability extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'liabilities';
    protected $primaryKey = 'liability_id';

    protected $fillable = [
        'organisation_id',
        'account_type_id',
        'financial_year_id',
        'liability_name',
        'liability_type',
        'liability_date',
        'liability_amount',
        'income_head_id',
        'liability_status',
    ];
    public function organisation()
    {
        return $this->belongsTo(Organisation::class, 'organisation_id');
    }

    public function accountType()
    {
        return $this->belongsTo(AccountType::class, 'account_type_id');
    }

    public function financialYear()
    {
        return $this->belongsTo(AccountingYear::class, 'financial_year_id', 'accounting_year_id');
    }
}
