<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExpenseHead extends Model
{
    use HasFactory;

    protected $table = 'expense_heads';
    protected $primaryKey = 'expense_head_id';

    protected $fillable = [
        'account_type_id',
        'expense_head_group_id',
        'expense_head_name',
        'expense_head_group_opening_balance',
        'status',
    ];

    public function accountType()
    {
        return $this->belongsTo(AccountType::class, 'account_type_ID', 'account_type_ID');
    }

    public function group()
    {
        return $this->belongsTo(ExpenseHeadGroup::class, 'expense_head_group_id', 'expense_head_group_ID');
    }
    public function expenses()
    {
        return $this->hasMany(Expense::class, 'expense_head', 'expense_head_id');
    }


}
