<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssetBroughtForward extends Model
{
    use HasFactory;

    protected $table = 'asset_brought_forwards';

    protected $fillable = [
        'financial_year_id',
        'total_asset_amount',
        'user_id',
        'dated_as_on',
        'organisation_id',
        'account_type_id'
    ];

    public function financialYear()
    {
        return $this->belongsTo(AccountingYear::class, 'financial_year_id', 'accounting_year_id');
    }
}
