<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Asset extends Model
{
    use SoftDeletes;

    protected $primaryKey = 'asset_id';

    protected $fillable = [
        'organisation_id',
        'account_type_id',
        'head_id',
        'expense_head_id',
        'depriciation_calcutated_amount',
        'asset_opening_balance',
        'asset_purchase_date',
        'financial_year_id',
        'asset_purchase_cost',
        'asset_useful_life'
    ];

    public function organisation()
    {
        return $this->belongsTo(Organisation::class, 'organisation_id');
    }

    public function accountType()
    {
        return $this->belongsTo(AccountType::class, 'account_type_id', 'account_type_id');
    }
}
