<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreHeadGroupRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    protected function prepareForValidation(): void
    {
        $this->merge([
            'organisation_id' => (int) $this->organisation_id,
        ]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'organisation_id'  => 'required|integer',

            'name' => [
                'required',
                'string',
                'max:255'
            ],
     
        ];
    }

    public function messages(): array
    {
        return [
            'organisation_id.required' => 'Organisation is required.',
            'organisation_id.integer' => 'Organisation is must be an integer ID.',
            'name.required'            => 'Head Group Name is required.',
            'name.unique'              => 'This Head Group Name already exists for the selected head group type.',
         
        ];
    }
}
