<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active">Dashboard</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4 gap-3">
        <div>
            <h1 class="h3 mb-1 text-gray-800">Dashboard</h1>
            <small class="text-muted">Welcome back, <?php echo e(auth()->user()->name); ?>!</small>
        </div>
       
    </div>

    <!-- Stats Cards -->
    <div class="row g-4 mb-5">
        <div class="col-12 col-sm-6 col-lg-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center py-4">
                    <div class="display-5 text-primary mb-2">
                        <i class="bi bi-people-fill"></i>
                    </div>
                    <h6 class="card-title text-muted text-uppercase small fw-bold">Total Students</h6>
                    <h2 class="mb-1 text-primary"><?php echo e($activeStudents); ?></h2>
                    <small class="text-success fw-medium"><i class="bi bi-check-circle"></i> Active</small>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-lg-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center py-4">
                    <div class="display-5 text-info mb-2">
                        <i class="bi bi-person-badge-fill"></i>
                    </div>
                    <h6 class="card-title text-muted text-uppercase small fw-bold">Staff Members</h6>
                    <h2 class="mb-1 text-info"><?php echo e($activeStaff); ?></h2>
                    <small class="text-muted fw-medium">Active</small>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-lg-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center py-4">
                    <div class="display-5 text-success mb-2">
                        <i class="bi bi-currency-rupee"></i>
                    </div>
                    <h6 class="card-title text-muted text-uppercase small fw-bold">Fees Collected</h6>
                    <h2 class="mb-1 text-success">₹<?php echo e(number_format($totalCollectedFee)); ?></h2>
                    <small class="text-muted">Current Academic Year</small>
                </div>
            </div>
        </div>

        <div class="col-12 col-sm-6 col-lg-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center py-4">
                    <div class="display-5 text-warning mb-2">
                        <i class="bi bi-exclamation-triangle-fill"></i>
                    </div>
                    <h6 class="card-title text-muted text-uppercase small fw-bold">Pending Fees</h6>
                    <h2 class="mb-1 text-warning">₹<?php echo e(number_format($pendingFee)); ?></h2>
                    <small class="text-danger fw-medium"><i class="bi bi-clock-history"></i> Requires Action</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions & Recent Activities -->
    <div class="row g-4">
        <!-- Quick Actions -->
        <div class="col-12 col-lg-12">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-white border-0 pt-3 border-bottom border-light">
                    <h5 class="mb-0 fw-semibold d-flex align-items-center">
                        <i class="bi bi-lightning-charge-fill text-primary me-3 fs-4"></i>
                        Quick Actions
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-12 col-md-3">
                            <a href="<?php echo e(route('students.index')); ?>?tab=register" class="text-decoration-none">
                                <div class="card border-0 shadow-sm h-100 text-center py-4 bg-primary bg-opacity-10 hover-lift transition">
                                    <div class="display-6 text-primary mb-3">
                                        <i class="bi bi-plus-circle"></i>
                                    </div>
                                    <h6 class="fw-bold text-primary">Register Student</h6>
                                    <small class="text-muted">Add new record</small>
                                </div>
                            </a>
                        </div>

                        <div class="col-12 col-md-3">
                            <a href="<?php echo e(route('student-fees.index')); ?>" class="text-decoration-none">
                                <div class="card border-0 shadow-sm h-100 text-center py-4 bg-success bg-opacity-10 hover-lift transition">
                                    <div class="display-6 text-success mb-3">
                                        <i class="bi bi-credit-card-2-front"></i>
                                    </div>
                                    <h6 class="fw-bold text-success">Collect Fees</h6>
                                    <small class="text-muted">Record payment</small>
                                </div>
                            </a>
                        </div>

                        <div class="col-12 col-md-3">
                            <a href="<?php echo e(route('students.index')); ?>" class="text-decoration-none">
                                <div class="card border-0 shadow-sm h-100 text-center py-4 bg-info bg-opacity-10 hover-lift transition">
                                    <div class="display-6 text-info mb-3">
                                        <i class="bi bi-search"></i>
                                    </div>
                                    <h6 class="fw-bold text-info">View Students</h6>
                                    <small class="text-muted">Browse directory</small>
                                </div>
                            </a>
                        </div>

                        <div class="col-12 col-md-3">
                            <a href="<?php echo e(route('staff.index')); ?>" class="text-decoration-none">
                                <div class="card border-0 shadow-sm h-100 text-center py-4 bg-secondary bg-opacity-10 hover-lift transition">
                                    <div class="display-6 text-secondary mb-3">
                                        <i class="bi bi-person-lines-fill"></i>
                                    </div>
                                    <h6 class="fw-bold text-secondary">Manage Staff</h6>
                                    <small class="text-muted">Add/edit members</small>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activities -->
        <!-- <div class="col-12 col-lg-6">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-white border-0 pt-3 border-bottom border-light">
                    <h5 class="mb-0 fw-semibold d-flex align-items-center">
                        <i class="bi bi-activity text-success me-3 fs-4"></i>
                        Recent Activities
                    </h5>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <div class="d-flex mb-4 align-items-start timeline-item hover-shadow transition">
                            <div class="flex-shrink-0 me-3">
                                <div class="bg-success bg-opacity-10 text-success rounded-circle p-3 ra-icon">
                                    <i class="bi bi-currency-rupee fs-4"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <strong>Fee Collected</strong>
                                <p class="mb-1">₹50,000 from Class 5-A</p>
                                <small class="text-muted">2 hours ago</small>
                            </div>
                        </div>

                        <div class="d-flex mb-4 align-items-start timeline-item hover-shadow transition">
                            <div class="flex-shrink-0 me-3">
                                <div class="bg-primary bg-opacity-10 text-primary rounded-circle p-3 ra-icon">
                                    <i class="bi bi-person-plus-fill fs-4"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <strong>New Student Registered</strong>
                                <p class="mb-1">Raj Kumar (Admission #1246)</p>
                                <small class="text-muted">Yesterday, 3:45 PM</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div> -->
    </div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/school-ramkrishna/resources/views/dashboard/index.blade.php ENDPATH**/ ?>