<?php $__env->startSection('title','Fees'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item active">Fee Configuration</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div id="fees-page" class="page-content">
    <h1 class="mb-4">Fee Configuration</h1>
    <ul class="nav nav-tabs mb-4" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link <?php echo e($tab == 'fee_head' ? 'active' : ''); ?>" id="fee_head" data-bs-toggle="tab" data-bs-target="#fee-head" type="button" role="tab">Fee Head</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link <?php echo e($tab == 'class_fee' ? 'active' : ''); ?>" id="fee_config" data-bs-toggle="tab" data-bs-target="#fee-config" type="button" role="tab">Class-wise Fee Configuration</button>
        </li>
    </ul>

    <div class="tab-content">

        <div class="tab-pane fade <?php echo e($tab == 'fee_head' ? 'show active' : ''); ?>" id="fee-head" role="tabpanel">
            <?php echo $__env->make('fees.head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
        <!-- Fee Configuration Tab -->
        <div class="tab-pane fade <?php echo e($tab == 'class_fee' ? 'show active' : ''); ?>" id="fee-config" role="tabpanel">
            <?php echo $__env->make('fees.config', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>

    <div class="modal fade" id="editFeeHeadModal" tabindex="-1">
        <div class="modal-dialog">
            <form id="editFeeHeadForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <input type="hidden" id="edit_id">

                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Fee Head</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body">

                        <div class="mb-3">
                            <label class="form-label">Fee Head Name *</label>
                            <input type="text" class="form-control" id="edit_name" name="name">
                            <small class="text-danger d-none" id="error_name"></small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" id="edit_description" name="description"></textarea>
                            <small class="text-danger d-none" id="error_description"></small>
                        </div>

                    </div>


                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" id="saveBtn">
                            <span id="saveText">Update</span>
                            <span id="saveSpinner" class="spinner-border spinner-border-sm d-none"></span>
                        </button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>

                </div>
            </form>
        </div>
    </div>

    <!-- Edit Class Fee Modal -->
    <div class="modal fade" id="editClassFeeModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title">Edit Class Fee</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input type="hidden" id="edit_id">
                    <input type="hidden" id="c_fee_url">

                    <div class="row g-3">

                        <!-- Class -->
                        <div class="col-md-6">
                            <label class="form-label">Class</label>
                            <select id="edit_class_id" class="form-select">
                                <option value="all">All Classes</option>
                                <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($class->id); ?>"><?php echo e($class->class_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="invalid-feedback" id="error_class_id"></div>
                        </div>

                        <!-- Fee Head -->
                        <div class="col-md-6">
                            <label class="form-label">Fee Head</label>
                            <select id="edit_fee_head_id" class="form-select">
                                <?php $__currentLoopData = $feeHeads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $head): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($head->id); ?>"><?php echo e($head->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="invalid-feedback" id="error_fee_head_id"></div>
                        </div>

                        <!-- Academic Year -->
                        <div class="col-md-6">
                            <label class="form-label">Academic Year</label>
                            <select id="edit_financial_year_id" class="form-select">
                                <?php $__currentLoopData = $academic_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($year->id); ?>"><?php echo e($year->label); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="invalid-feedback" id="error_financial_year_id"></div>
                        </div>

                        <!-- Amount -->
                        <div class="col-md-6">
                            <label class="form-label">Amount</label>
                            <input type="number" id="edit_amount" class="form-control">
                            <div class="invalid-feedback" id="error_amount"></div>
                        </div>

                        <!-- Fee Type -->
                        <div class="col-md-6">
                            <label class="form-label">Fee Type</label>
                            <select id="edit_fee_type" class="form-select">
                                <option value="recurring">Recurring</option>
                                <option value="one_time">One Time</option>
                            </select>
                            <div class="invalid-feedback" id="error_fee_type"></div>
                        </div>

                        <!-- Due Day (Recurring) -->
                        <div class="col-md-6" id="edit_due_day_wrapper">
                            <label class="form-label">Due Day of Month</label>
                            <select id="edit_due_day_of_month" class="form-select">
                                <option value="">Select Day</option>
                                <?php for($i = 1; $i <= 15; $i++): ?>
                                    <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                <?php endfor; ?>
                            </select>
                            <div class="invalid-feedback" id="error_due_day_of_month"></div>
                        </div>

                        <!-- Due Date (One Time) -->
                        <div class="col-md-6 d-none" id="edit_due_date_wrapper">
                            <label class="form-label">Due Date</label>
                            <input type="date" id="edit_due_date" class="form-control">
                            <div class="invalid-feedback" id="error_due_date"></div>
                        </div>
                        <!-- Late fee Amount -->
                        <div class="col-md-6">
                            <label class="form-label">Late Fee Amount</label>
                            <input type="number" id="edit_late_fee_amount" class="form-control">
                            <div class="invalid-feedback" id="error_late_fee_amount"></div>
                        </div>

                    </div>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button class="btn btn-primary" id="updateClassFeeBtn">
                        <span class="spinner-border spinner-border-sm d-none" id="updateSpinner"></span>
                        Save Changes
                    </button>
                </div>

            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {
            $(document).on('change', '.fee-status', function () {
                let checkbox = $(this);
                let fee_status = checkbox.prop('checked') ? 1 : 0;

                $.ajax({
                    url: checkbox.data('url'),
                    type: "PUT",             
                    //dataType: "json",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",    
                        status: fee_status
                    },
                    success: function (data) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success',
                            text: data.message
                        });
                    },
                    error: function (xhr) {
                        let message = 'Status not updated';

                        if (xhr.responseJSON && xhr.responseJSON.message) {
                            message = xhr.responseJSON.message;
                        }

                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: message
                        });

                        checkbox.prop('checked', !checkbox.prop('checked'));
                    }
                });
            });


            // document.querySelector('input[name="q"]').addEventListener('keydown', e => {
            //     if (e.key === 'Escape') window.location.href = "<?php echo e(route('students.index')); ?>";
            // });

            

        });

    </script>
    <script>
        document.addEventListener('click', function (e) {
            if (!e.target.classList.contains('deleteFeeHeadBtn')) return;

            const url = e.target.dataset.url;
            const row = e.target.closest('tr');

            Swal.fire({
                title: "Are you sure?",
                text: "This Fee head will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
            }).then(result => {
                if (!result.isConfirmed) return;

                fetch(url, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        row.remove();
                        Swal.fire('Deleted!', res.message, 'success');
                    } else {
                        Swal.fire('Error!', res.message, 'error');
                    }
                });
            });
        });

    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {

            let editModal = new bootstrap.Modal(
                document.getElementById('editFeeHeadModal')
            );

            const saveBtn = document.getElementById('saveBtn');
            const saveText = document.getElementById('saveText');
            const saveSpinner = document.getElementById('saveSpinner');

            function resetErrors() {
                document.querySelectorAll('[id^="error_"]').forEach(el => {
                    el.classList.add('d-none');
                    el.innerText = '';
                });
            }

            function toggleLoading(state) {
                saveBtn.disabled = state;
                saveSpinner.classList.toggle('d-none', !state);
                saveText.classList.toggle('d-none', state);
            }

            // Open modal
            document.querySelectorAll('.edit-fee-head').forEach(btn => {
                btn.addEventListener('click', function () {

                    resetErrors();

                    document.getElementById('edit_id').value = this.dataset.id;
                    document.getElementById('edit_name').value = this.dataset.name;
                    document.getElementById('edit_description').value = this.dataset.description;

                    editModal.show();
                });
            });

            // AJAX Save
            document.getElementById('editFeeHeadForm').addEventListener('submit', function (e) {
                e.preventDefault();

                resetErrors();
                toggleLoading(true);

                let id = document.getElementById('edit_id').value;

                fetch("<?php echo e(url('fees/fee-head')); ?>/" + id, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'X-HTTP-Method-Override': 'PUT',
                        'Accept': 'application/json'
                    },
                    body: new FormData(this)
                })
                .then(async res => {
                    toggleLoading(false);

                    if (!res.ok) {
                        let data = await res.json();
                        throw data;
                    }
                    return res.json();
                })
                .then(data => {

                    Swal.fire({
                        icon: 'success',
                        title: 'Updated',
                        text: data.message,
                        timer: 1500,
                        showConfirmButton: false
                    });

                    const newName = document.getElementById('edit_name').value;
                    const newDescription = document.getElementById('edit_description').value;

                    // Find edit button
                    let editBtn = document.querySelector(
                        `.edit-fee-head[data-id="${id}"]`
                    );

                    // Update table row text
                    let row = editBtn.closest('tr');
                    row.children[0].innerText = newName;
                    row.children[1].innerText = newDescription;

                    //  Update data attributes (IMPORTANT)
                    editBtn.dataset.name = newName;
                    editBtn.dataset.description = newDescription;

                    editModal.hide();
                })

                .catch(err => {
                    toggleLoading(false);

                    if (err.errors) {
                        Object.keys(err.errors).forEach(field => {
                            let errorEl = document.getElementById('error_' + field);
                            if (errorEl) {
                                errorEl.innerText = err.errors[field][0];
                                errorEl.classList.remove('d-none');
                            }
                        });
                    } else if (err.message) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: err.message
                        });
                    }
                });
            });

        });
    </script>
    <script>
        document.querySelectorAll('.editClassFeeBtn').forEach(btn => {
            btn.addEventListener('click', function () {

                const row = this.closest('tr');

                document.getElementById('edit_id').value = row.dataset.id;
                document.getElementById('edit_class_id').value = row.dataset.classId;
                document.getElementById('edit_fee_head_id').value = row.dataset.feeHeadId;
                document.getElementById('edit_financial_year_id').value = row.dataset.financialYearId;
                document.getElementById('edit_amount').value = row.dataset.amount;
                document.getElementById('edit_late_fee_amount').value = row.dataset.late_fee_amount;

                // 🔥 Fee Type
                const feeType = row.dataset.feeType;
                document.getElementById('edit_fee_type').value = feeType;

                // 🔥 Due values
                document.getElementById('edit_due_day_of_month').value = row.dataset.dueDay ?? '';
                document.getElementById('edit_due_date').value = row.dataset.dueDate ?? '';

                toggleEditFeeTypeUI(feeType);

                document.getElementById('c_fee_url').value = this.dataset.url;

                clearErrors();

                new bootstrap.Modal('#editClassFeeModal').show();
            });
        });


    </script>

    <script>
        document.getElementById('updateClassFeeBtn').addEventListener('click', function () {

            const id = document.getElementById('edit_id').value;

            const btn = this;
            const spinner = document.getElementById('updateSpinner');

            btn.disabled = true;
            spinner.classList.remove('d-none');

            clearErrors();

            fetch(document.getElementById('c_fee_url').value, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    _method: 'PUT',
                    class_id: document.getElementById('edit_class_id').value,
                    fee_head_id: document.getElementById('edit_fee_head_id').value,
                    financial_year_id: document.getElementById('edit_financial_year_id').value,
                    amount: document.getElementById('edit_amount').value,
                    late_fee_amount : document.getElementById('edit_late_fee_amount').value,
                    fee_type: document.getElementById('edit_fee_type').value,
                    due_day_of_month: document.getElementById('edit_due_day_of_month').value,
                    due_date: document.getElementById('edit_due_date').value
                })

            })
            .then(async res => {
                const data = await res.json();
                if (!res.ok) throw data;
                return data;
            })
            .then(res => {

                // ❌ Validation errors
                if (res.errors) {
                    showErrors(res.errors);
                    return;
                }


                // ✅ Update table row instantly
                /*const row = document.querySelector(`tr[data-id="${id}"]`);

                const amount = document.getElementById('edit_amount').value;
                const dueDate = document.getElementById('edit_due_date').value || '-';

                row.dataset.classId = document.getElementById('edit_class_id').value;
                row.dataset.feeHeadId = document.getElementById('edit_fee_head_id').value;
                row.dataset.financialYearId = document.getElementById('edit_financial_year_id').value;
                row.dataset.amount = amount;
                row.dataset.dueDate = dueDate;

                row.children[3].innerText = amount;
                row.children[4].innerText = dueDate;

                // ✅ Close modal
                bootstrap.Modal.getInstance(
                    document.getElementById('editClassFeeModal')
                ).hide();*/

                // 🎉 SUCCESS TOASTER
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'success',
                    title: res.message || 'Class fee updated successfully',
                    showConfirmButton: false,
                    timer: 3000
                });

                location.reload();
            })
            .catch(err => {
                // 🚨 Server / exception error
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: err.message || 'Something went wrong'
                });
            })
            .finally(() => {
                btn.disabled = false;
                spinner.classList.add('d-none');
            });
        });


        function clearErrors() {
            document.querySelectorAll('.invalid-feedback').forEach(el => el.innerText = '');
            document.querySelectorAll('.form-control, .form-select').forEach(el => el.classList.remove('is-invalid'));
        }

        function showErrors(errors) {
            Object.keys(errors).forEach(key => {
                const input = document.getElementById(`edit_${key}`);
                const error = document.getElementById(`error_${key}`);

                if (input && error) {
                    input.classList.add('is-invalid');
                    error.innerText = errors[key][0];
                }
            });
        }
    </script>

    <script>
        document.getElementById('fee_type').addEventListener('change', function () {

            const dueDay  = document.getElementById('due_day_wrapper');
            const dueDate = document.getElementById('due_date_wrapper');

            if (this.value === 'recurring') {
                dueDay.classList.remove('d-none');
                dueDate.classList.add('d-none');
            } else {
                dueDay.classList.add('d-none');
                dueDate.classList.remove('d-none');
            }
        });
    </script>

    <script>
        function toggleEditFeeTypeUI(type) {
            const dueDay  = document.getElementById('edit_due_day_wrapper');
            const dueDate = document.getElementById('edit_due_date_wrapper');

            if (type === 'recurring') {
                dueDay.classList.remove('d-none');
                dueDate.classList.add('d-none');
            } else {
                dueDay.classList.add('d-none');
                dueDate.classList.remove('d-none');
            }
        }

        document.getElementById('edit_fee_type').addEventListener('change', function () {
            toggleEditFeeTypeUI(this.value);
        });

        document.addEventListener('click', function (e) {
            if (!e.target.classList.contains('deleteClassFeeBtn')) return;

            const url = e.target.dataset.url;
            const row = e.target.closest('tr');

            Swal.fire({
                title: "Are you sure?",
                text: "This Fee config will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
            }).then(result => {
                if (!result.isConfirmed) return;

                fetch(url, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        row.remove();
                        Swal.fire('Deleted!', res.message, 'success');
                    } else {
                        Swal.fire('Error!', res.message, 'error');
                    }
                });
            });
        });

    </script>

    <script>
        let today = new Date().toISOString().split('T')[0];

        $('#due_date').attr({
            min: today   // disable past dates
            // no max → future dates allowed
        });

        $('#edit_due_date').attr({
            min: today   // disable past dates
            // no max → future dates allowed
        });
        
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {

            const urlParams = new URLSearchParams(window.location.search);
            const tab = urlParams.get('tab') || 'list';

            const tabMap = {
                fee_head: 'fee_head',
                fee_config: 'fee_head'
            };

            if (tabMap[tab]) {
                console.log(tabMap[tab]);
                const triggerEl = document.getElementById(tabMap[tab]);
                if (triggerEl) {
                    new bootstrap.Tab(triggerEl).show();
                }
            }
        });
    </script>





<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/school-ramkrishna/resources/views/fees/index.blade.php ENDPATH**/ ?>