

<?php $__env->startSection('title','School Setup'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item active">School Setup</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div id="school-setup-page" class="page-content">

        <h1 class="mb-4">School Setup</h1>

        <div class="row">
            <div class="col-md-8">

                
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">School Details</h5>
                    </div>

                    <div class="card-body">
                        <form action="<?php echo e(route('school.save')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">School Name *</label>
                                    <input type="text" name="name" class="form-control"
                                        value="<?php echo e($school->name ?? ''); ?>" required>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Established Year *</label>
                                    <input type="text"
                                        name="established_year"
                                        class="form-control"
                                        value="<?php echo e($school->established_year ?? ''); ?>"
                                        maxlength="4"
                                        inputmode="numeric"
                                        pattern="[0-9]{4}"
                                        required>

                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <label class="form-label">Address *</label>
                                    <input type="text" name="address" class="form-control"
                                        value="<?php echo e($school->address ?? ''); ?>" required>
                                </div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Phone *</label>
                                    <input type="text"
                                        name="phone"
                                        class="form-control"
                                        value="<?php echo e($school->phone ?? ''); ?>"
                                        maxlength="10"
                                        inputmode="numeric"
                                        pattern="[0-9]{10}"
                                        required>

                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">Email *</label>
                                    <input type="email" name="email" class="form-control"
                                        value="<?php echo e($school->email ?? ''); ?>" required>
                                </div>
                            </div>

                            <div class="row mb-3" id="logoPreview">
                                <?php if($school->logo): ?>
                                    <div class="col-md-3">
                                        <div class="card mb-3">
                                            <img src="<?php echo e(asset('storage/'.$school->logo)); ?>" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <label class="form-label">School Logo</label>
                                    <input type="file" name="logo" class="form-control" id="logo_file" accept="image/*">
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary">Save School Details</button>
                        </form>
                    </div>
                </div>

                
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Academic Year</h5>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('year.add')); ?>" method="POST" class="mb-3">
                            <?php echo csrf_field(); ?>

                            <label class="form-label">Add New Academic Year</label>

                            <div class="input-group mb-1">
                                <input type="date" name="year_from"
                                    value="<?php echo e(old('year_from')); ?>"
                                    class="form-control a_year_from <?php $__errorArgs = ['year_from'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    required>

                                <input type="date" name="year_to"
                                    value="<?php echo e(old('year_to')); ?>"
                                    class="form-control a_year_to <?php $__errorArgs = ['year_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    required>

                                <input type="text" name="label"
                                    value="<?php echo e(old('label')); ?>"
                                    class="a_year_label form-control <?php $__errorArgs = ['label'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    readonly required
                                    style="cursor: not-allowed; background-color: var(--bs-secondary-bg); opacity: 1; border: 1px solid #c7ccd6;">

                                <button class="btn btn-outline-secondary" type="submit">Add</button>
                            </div>

                            
                            <div class="text-danger small">
                                <?php $__errorArgs = ['year_from'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <?php $__errorArgs = ['year_to'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>   <div><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <?php $__errorArgs = ['label'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>     <div>The Academic Year has already been taken</div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </form>
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Academic Year From</th>
                                    <th>Academic Year To</th>
                                    <th>Academic Year</th>
                                    <th>Set As Current</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $academic_years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(\Carbon\Carbon::parse($year->year_from)->format('d M Y')); ?></td>
                                        <td><?php echo e(\Carbon\Carbon::parse($year->year_to)->format('d M Y')); ?></td>
                                        <td><?php echo e($year->label); ?></td>
                                        <td>
                                            <div class="form-check form-switch">
                                                <input
                                                    class="form-check-input year-status"
                                                    type="checkbox"
                                                    id="status_<?php echo e($year->id); ?>"
                                                    data-id="<?php echo e($year->id); ?>"
                                                    data-url="<?php echo e(route('year.update', $year->id)); ?>"
                                                    <?php echo e($year->status ? 'checked' : ''); ?>

                                                >
                                            </div>
                                        </td>

                                        <td>
                                            <button class="btn btn-sm btn-outline-primary year-edit-btn"
                                                data-id="<?php echo e($year->id); ?>"
                                                data-label="<?php echo e($year->label); ?>"
                                                data-y_from="<?php echo e($year->year_from); ?>"
                                                data-y_to="<?php echo e($year->year_to); ?>"
                                                data-url="<?php echo e(route('year.update', $year->id)); ?>"
                                                title="Edit Academic Year">
                                                <i class="bi bi-pencil"></i>
                                            </button>

                                            <!-- <button class="btn btn-sm btn-outline-danger year-delete-btn"
                                                data-id="<?php echo e($year->id); ?>"
                                                data-url="<?php echo e(route('year.delete', $year->id)); ?>"
                                                title="Delete Academic Year">
                                                <i class="bi bi-trash"></i>
                                            </button> -->
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                
                

            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>

    <!-- Edit Academic Year Modal -->
    <div class="modal fade" id="editYearModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="editYearForm" action="">
                    <?php echo csrf_field(); ?> 
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Academic Year</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="edit_year_id" name="id">
                        <div class="mb-3">
                            <label>Academic Year From</label>
                            <input type="date" id="edit_year_from" name="year_from" class="a_year_from form-control" required>
                        </div>
                        <div class="mb-3">
                            <label>Academic Year To</label>
                            <input type="date" id="edit_year_to" name="year_to" class="a_year_to form-control" required>
                        </div>
                        <div class="mb-3">
                            <label>Label</label>
                            <input type="text" id="edit_year_label" name="label" class="a_year_label form-control" readonly required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="updateYearBtn" class="btn btn-primary">
                            Update
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Academic Year Modal -->
    <div class="modal fade" id="editSessionModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="editSessionForm" action="">
                    <?php echo csrf_field(); ?> 
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Session</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="edit_session_id" name="id">
                        <div class="mb-3">
                            <label>Name</label>
                            <input type="text" id="edit_session_name" name="session_name" class="a_session_name form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="updateSessionBtn" class="btn btn-primary">
                            Update
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {

            // OPEN MODAL AND LOAD DATA
            $('.year-edit-btn').on('click', function () {

                let id = $(this).data('id');
                let label = $(this).data('label');
                let y_from = $(this).data('y_from');
                let y_to = $(this).data('y_to');
                let url = $(this).data('url');

                // fill modal
                $('#edit_year_id').val(id);
                $('#edit_year_label').val(label);
                $('#edit_year_from').val(y_from);
                $('#edit_year_to').val(y_to);
                $('#editYearForm').attr('action',url);

                // open modal
                $('#editYearModal').modal('show');
            });



            // UPDATE FORM SUBMIT
            $('#editYearForm').on('submit', function (e) {
                e.preventDefault();

                let id = $('#edit_year_id').val();
                let url = $('#editYearForm').attr('action');

                let btn = $('#updateYearBtn');
                btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Updating...');

                $.ajax({
                    url: url,
                    type: "POST",
                    data: $(this).serialize(),
                    success: function (res) {
                        Swal.fire("Updated!", 'Academic Year updated successfully', "success");
                        $('#editYearModal').modal('hide');
                        location.reload();
                    },
                    error: function (xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let msg = "";

                            $.each(errors, function (k, v) {
                                msg += v + "<br>";
                            });

                            Swal.fire({
                                title: "Validation Error!",
                                html: msg,
                                icon: "error"
                            });
                        } else {
                            Swal.fire("Error!", "Something went wrong.", "error");
                        }
                    },
                    complete: function () {
                        btn.prop('disabled', false).html('Update');
                    }
                });
            });
        });
    </script>
    <script>
        $(document).ready(function () {

            $('.year-status').on('change', function () {

                let checkbox = $(this);
                let id = checkbox.data('id');
                let url = checkbox.data('url');
                let status = checkbox.is(':checked') ? 1 : 0;

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        status: status
                    },
                    success: function (res) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Updated',
                            text: 'Status updated successfully',
                            timer: 1200,
                            showConfirmButton: false
                        });
                        location.reload();
                    },
                    error: function (xhr) {
                        Swal.fire("Error!", xhr.responseJSON.message, "error");

                        // revert checkbox state
                        checkbox.prop('checked', !checkbox.prop('checked'));
                    }
                });

            });

        });
    </script>

    <script>
        $(document).ready(function () {

            function updateAcademicYearLabel() {
                let fromDate = $('.a_year_from').val();
                let toDate   = $('.a_year_to').val();

                if (fromDate && toDate) {
                    let fromYear = new Date(fromDate).getFullYear();
                    let toYear   = new Date(toDate).getFullYear();
                    if(fromYear==toYear){
                        $('.a_year_label').val(fromYear);
                    } else {
                        $('.a_year_label').val(fromYear + '-' + toYear);
                    }
                    
                }
            }

            $('.a_year_from, .a_year_to').on('change', function () {
                updateAcademicYearLabel();
            });

        });
    </script>

    <script>
        $(document).ready(function() {

            // OPEN MODAL AND LOAD DATA
            $('.session-edit-btn').on('click', function () {

                let id = $(this).data('id');
                let name = $(this).data('name');
                let url = $(this).data('url');

                // fill modal
                $('#edit_session_id').val(id);
                $('#edit_session_name').val(name);
                $('#editSessionForm').attr('action',url);

                // open modal
                $('#editSessionModal').modal('show');
            });



            // UPDATE FORM SUBMIT
            $('#editSessionForm').on('submit', function (e) {
                e.preventDefault();

                let id = $('#edit_session_id').val();
                let url = $('#editSessionForm').attr('action');

                let btn = $('#updateSessionBtn');
                btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Updating...');

                $.ajax({
                    url: url,
                    type: "POST",
                    data: $(this).serialize(),
                    success: function (res) {
                        Swal.fire("Updated!", 'Session updated successfully', "success");
                        $('#editSessionModal').modal('hide');
                        location.reload();
                    },
                    error: function (xhr) {
                        if (xhr.status === 422) {
                            let errors = xhr.responseJSON.errors;
                            let msg = "";

                            $.each(errors, function (k, v) {
                                msg += v + "<br>";
                            });

                            Swal.fire({
                                title: "Validation Error!",
                                html: msg,
                                icon: "error"
                            });
                        } else {
                            Swal.fire("Error!", "Something went wrong.", "error");
                        }
                    },
                    complete: function () {
                        btn.prop('disabled', false).html('Update');
                    }
                });
            });

            $('.session-status').on('change', function () {

                let checkbox = $(this);
                let id = checkbox.data('id');
                let url = checkbox.data('url');
                let status = checkbox.is(':checked') ? 1 : 0;

                $.ajax({
                    url: url,
                    type: "POST",
                    data: {
                        _token: "<?php echo e(csrf_token()); ?>",
                        status: status
                    },
                    success: function (res) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Updated',
                            text: 'Status updated successfully',
                            timer: 1200,
                            showConfirmButton: false
                        });
                        location.reload();
                    },
                    error: function (xhr) {
                        Swal.fire("Error!", xhr.responseJSON.message, "error");

                        // revert checkbox state
                        checkbox.prop('checked', !checkbox.prop('checked'));
                    }
                });

            });
        });
    </script>
    <script>
        /* ==== Primary Image Preview ==== */
        document.getElementById('logo_file').addEventListener('change', function(event) {
            let input = event.target;
            let file = input.files[0];
            let preview = document.getElementById('logoPreview');
            // Clear old preview

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && file.type.startsWith('image/')) {
                dt.items.add(file); // Keep valid file

                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-3', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = "";
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }

            // Replace with filtered file list (empty if invalid)
            input.files = dt.files;
        });
    </script>

    <script>
        function initAcademicYear(container = document) {

            const yearFrom = container.querySelector('.a_year_from');
            const yearTo   = container.querySelector('.a_year_to');

            if (!yearFrom || !yearTo) return;

            yearTo.disabled = !yearFrom.value;

            function includesLeapDay(start, end) {
                let s = new Date(start);
                let e = new Date(end);

                for (let y = s.getFullYear(); y <= e.getFullYear(); y++) {
                    if ((y % 4 === 0 && y % 100 !== 0) || (y % 400 === 0)) {
                        let feb29 = new Date(y, 1, 29);
                        if (feb29 >= s && feb29 <= e) {
                            return true;
                        }
                    }
                }
                return false;
            }

            function diffDays(start, end) {
                return Math.round(
                    (new Date(end) - new Date(start)) / 86400000
                );
            }

            yearFrom.addEventListener('change', function () {

                if (!this.value) {
                    yearTo.value = '';
                    yearTo.disabled = true;
                    yearTo.removeAttribute('min');
                    yearTo.removeAttribute('max');
                    return;
                }

                yearTo.disabled = false;

                // ✅ Disable all dates before "from"
                yearTo.min = this.value;

                // ✅ Optional UX: reset invalid previous value
                if (yearTo.value && yearTo.value <= this.value) {
                    yearTo.value = '';
                }
            });

            yearTo.addEventListener('change', validateRange);

            function validateRange() {

                if (!yearFrom.value || !yearTo.value) return;

                const start = yearFrom.value;
                const end   = yearTo.value;

                if (end <= start) {
                    //alert('End date must be greater than start date');
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'To date must be greater than From date',
                        timer: 1200,
                        showConfirmButton: false
                    });
                    yearTo.value = '';
                    yearTo.focus();
                    return;
                }

                const days = diffDays(start, end);
                const hasLeap = includesLeapDay(start, end);

                // ✅ Correct expected days
                const expectedDays = hasLeap ? 365 : 364;

                if (days !== expectedDays) {
                    alert(`Academic year must be exactly ${expectedDays} days`);
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'To date must be greater than From date',
                        timer: 1200,
                        showConfirmButton: false
                    });
                    yearTo.value = '';
                    yearTo.focus();
                }
            }
        }

        /* PAGE */
        document.addEventListener('DOMContentLoaded', () => initAcademicYear(document));

        /* MODAL */
        document.addEventListener('shown.bs.modal', e => initAcademicYear(e.target));
    </script>



    <script>
        document.addEventListener('input', function (e) {
            if (e.target.name === 'established_year') {
                e.target.value = e.target.value
                    .replace(/\D/g, '')     // remove non-numeric
                    .slice(0, 4);           // max 4 digits
            }
        });
        document.addEventListener('input', function (e) {
            if (e.target.name === 'phone') {
                e.target.value = e.target.value
                    .replace(/\D/g, '')    // remove non-numeric
                    .slice(0, 10);         // limit to 10 digits
            }
        });
        
    </script>






<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/school-ramkrishna/resources/views/school/setup.blade.php ENDPATH**/ ?>