<div class="card mb-4">
    <div class="card-header bg-light">
        <div class="row align-items-center">
            <div class="col">
                <h5 class="mb-0">Search Student</h5>
            </div>
        </div>
    </div>
    <div class="card-body">
        <form>
            <div class="row mb-3">
                <div class="col-md-2">
                    <select name="financial_year_id" class="form-select" required>
                        @foreach($academic_years as $year)
                            <option value="{{ $year->id }}" {{ request('financial_year_id', $active_academic_year->id) == $year->id ? 'selected' : '' }}>
                                {{ $year->label }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="class_id" id="class_id" class="form-select" required>
                        <option value="all">All Class</option>
                        @foreach($classes as $class)
                            <option value="{{ $class->id }}" {{ (request('class_id')==$class->id)?'selected':'' }}>
                                {{ $class->class_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="section_id"
                            id="section_id"
                            class="form-select form-select-sm"
                            {{ request('class_id') ? '' : 'disabled' }}>
                        <option value="">All Sections</option>

                        {{-- When page reloads --}}
                        @if(request('class_id'))
                            @foreach($sections as $section)
                                <option value="{{ $section->id }}"
                                    {{ request('section_id') == $section->id ? 'selected' : '' }}>
                                    {{ $section->section_name }}
                                </option>
                            @endforeach
                        @endif
                    </select>
                </div>
                <div class="col-md-2">
                    <input
                        type="month"
                        name="month"
                        class="form-control form-control-sm"
                        value="{{ request()->filled('month') ? request('month') : now()->format('Y-m') }}"
                    >
                </div>
                <div class="col-md-4">
                    <input type="search"
                        name="q"
                        value="{{ request('q') }}"
                        class="form-control form-control-sm"
                        placeholder="Search by name or admission #">
                </div>
            </div>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    Search
                </button>

                {{-- Clear Filter --}}
                <a href="{{ url()->current() }}"
                class="btn btn-outline-secondary">
                    Clear Filter
                </a>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Student Fee Status</h5>
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead>
                    <tr>
                        <th>Admission No.</th>
                        <th>Student Name</th>
                        <th>Class</th>
                        <!-- <th>Roll No</th> -->
                        <th>Due Amount</th>
                        <!-- <th>Paid</th>
                        <th>Pending</th> -->
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>

                <tbody>
                    @forelse($students as $student)
                        <tr>
                            <td>{{ $student->admission_no }}</td>
                            <td>{{ $student->name }}</td>

                            <td>
                                {{ $student->activeClass->class->class_name ?? '-' }}
                                ({{ $student->activeClass->section->section_name ?? '-' }})
                            </td>

                            <!-- <td>{{ $student->activeClass->roll_no ?? '-' }}</td> -->

                            <td>₹{{ number_format($student->total_fee, 2) }}</td>
                            <!-- <td>₹{{ number_format($student->paid_fee, 2) }}</td>
                            <td>₹{{ number_format($student->pending_fee, 2) }}</td> -->


                            <td>
                                @if($student->fee_status == 'paid')
                                    <span class="badge bg-success">Paid</span>
                                @else
                                    <span class="badge bg-danger">Unpaid</span>
                                @endif
                            </td>

                            <td>
                                @if($student->fee_status == 'paid')
                                    <button
                                        class="btn btn-sm btn-outline-secondary viewFeeBtn"
                                        data-student-id="{{ $student->id }}"
                                        data-month="{{ request('month', now()->format('Y-m')) }}">
                                        View
                                    </button>
                                @else
                                    <button
                                        class="btn btn-sm btn-outline-primary collectFeeBtn"
                                        data-student-id="{{ $student->id }}"
                                        data-month="{{ request('month', now()->format('Y-m')) }}">
                                        Collect
                                    </button>
                                @endif
                            </td>

                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center text-muted">
                                No students found
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        <div class="mt-3">
            {{ $students->links() }}
        </div>
    </div>
</div>
