<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Collect Student Fee</h5>
    </div>

    <div class="card-body">
        <form id="feeForm" method="post" action="{{ route('fee.collection.store') }}">
            @csrf
            {{-- STUDENT --}}
            <div class="row mb-3">
                <div class="col-md-12">
                    <label class="form-label">Select Student *</label>
                    <select id="student_id" class="form-select" name="student_id" required></select>

                    <input name="financial_year_id" type="hidden" id="financial_year_id" value="{{ $active_academic_year->id }}">

                </div>
            </div>
            <div class="mb-3" id="not_found"></div>

            <div id="payment-sec" style="display:none;">
                {{-- FEES --}}
                <h6 class="mb-3 text-muted">Pending Fees (Select applicable fees)</h6>

                <div class="mb-3" id="monthWiseFees"></div>

                <div id="month-fee-collection">
                    {{-- PAYMENT --}}
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label class="form-label">Total Amount *</label>
                            <input type="number" id="grandTotal" class="form-control" readonly>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Payment Method *</label>
                            <select name="payment_method" id="payment_method" class="form-select" required>
                                <option value="">Select</option>
                                <option value="cash">Cash</option>
                                <option value="online">Online</option>
                                <option value="cheque">Cheque</option>
                                <option value="bank">Bank</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Transaction ID / Money Receipt No *</label>
                            <input name="transaction_id" type="text" id="transaction_id" class="form-control" required>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <button type="submit"  class="btn btn-primary btn-sm ">
                            Record Fee Collection
                        </button>
                        <a href="{{ route('student-fees.index') }}" class="btn btn-secondary btn-sm">
                            Cancel
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
