<!-- ================= PROCESS MONTHLY SALARY ================= -->
<div class="card mb-4">
    <div class="card-header bg-light">
        <h5 class="mb-0">Process Monthly Salary</h5>
    </div>

    <div class="card-body">
        <form method="GET">
            <input type="hidden" name="tab" value="salary">

            <div class="row mb-3">
                <div class="col-md-4">
                    <input type="month"
                        name="month"
                        value="{{ request('month') }}"
                        class="form-control"
                        required>
                </div>

                <div class="col-md-4">
                    <select name="financial_year_id" class="form-select">
                        @foreach($academic_years as $year)
                            <option value="{{ $year->id }}"
                                {{ request('financial_year_id') == $year->id ? 'selected' : '' }}>
                                {{ $year->label }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-4">
                    <select name="category" class="form-select">
                        <option value="">All Category</option>
                        <option value="Teacher"
                            {{ request('category') == 'Teacher' ? 'selected' : '' }}>
                            Teacher
                        </option>
                        <option value="Non-Teacher"
                            {{ request('category') == 'Non-Teacher' ? 'selected' : '' }}>
                            Non-Teacher
                        </option>
                    </select>
                </div>
            </div>

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary">
                    Search & Preview
                </button>

                {{-- Clear Filter --}}
                <a href="{{ url()->current() }}"
                class="btn btn-outline-secondary">
                    Clear Filter
                </a>
            </div>
        </form>

    </div>
</div>

<!-- ================= SALARY SLIP PREVIEW ================= -->
<div class="card">
    <div class="card-header bg-light">
        <h5 class="mb-0">Salary Slip Preview</h5>
    </div>

    <div class="card-body">
        <div class="table-responsive mb-3">
            <table class="table table-sm align-middle">
                <thead>
                    <tr>
                        <th>Staff Name</th>
                        <th>Basic</th>
                        <th>Employer Contribution</th>
                        <th>CTC</th>
                        <th>Total Deduction</th>
                        <th>Net Salary</th>
                        <th>Status</th>
                        <th>Paid Date</th>
                        <th width="160">Actions</th>
                    </tr>
                </thead>

                <tbody>
                    @forelse($salaryStaffs as $row)
                        <tr>
                            <td>{{ $row['staff']->name }}</td>

                            <td>{{ number_format($row['salary']->basic, 2) }}</td>
                            <td>
                                {{ number_format(
                                    $row['salary']->employer_pf +
                                    $row['salary']->employer_esi,
                                    2
                                ) }}
                            </td>
                            <td>
                                <strong>
                                    {{ number_format($row['salary']->ctc, 2) }}
                                </strong>
                            </td>
                            <td>{{ number_format($row['salary']->total_deductions, 2) }}</td>

                            

                            <td>{{ number_format($row['salary']->net_salary, 2) }}</td>

                            <td>
                                @if($row['status'] === 'paid')
                                    <span class="badge bg-success">Paid</span>
                                @else
                                    <span class="badge bg-warning">Pending</span>
                                @endif
                            </td>
                            <td>{{ $row['salary']->paid_date ? \Carbon\Carbon::parse($row['salary']->paid_date)->format('d-m-Y: H:i:s') : '--' }}</td>
                            <td>
                                {{-- PENDING → PAY --}}
                                @if($row['status'] === 'pending')
                                    <form method="POST"
                                        action="{{ route('staff.salary.pay') }}"
                                        class="d-inline pay-form">
                                        @csrf

                                        <input type="hidden" name="staff_id" value="{{ $row['staff']->id }}">
                                        <input type="hidden" name="financial_year_id" value="{{ request('financial_year_id') }}">
                                        <input type="hidden" name="month" value="{{ request('month') }}">

                                        <button type="button"
                                                class="btn btn-sm btn-primary pay-btn">
                                            Pay
                                        </button>
                                    </form>
                                @endif

                                {{-- PAID → VIEW SLIP --}}
                                @if($row['status'] === 'paid')
                                    <a href="{{ route('staff.salary.slip', [$row['staff']->id, $row['salary']->pay_for_month]) }}"
                                        target="_blank"
                                        class="btn btn-sm btn-outline-secondary">
                                        View Slip
                                    </a>

                                @endif
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="text-center text-muted">
                                No salary records found for selected month
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($salaryStaffs->where('status','pending')->count() > 0)
            <div class="d-flex justify-content-end gap-2">
                <form action="{{ route('staff.pay-all-pending') }}" method="POST" class="d-inline bluk-pay-form">
                    @csrf
                    <input type="hidden" name="month" value="{{ request('month') }}">
                    <input type="hidden" name="financial_year_id" value="{{request('financial_year_id')}}">
                    <input type="hidden" name="category" value="{{request('category')}}">
                    <button type="submit" class="btn btn-warning btn-sm mb-3">Pay All Pending Salaries</button>
                </form>
            </div>
        @endif
    </div>
</div>
