@extends('layouts.app')

@section('title','Expense Ledger')

@section('breadcrumb')
<li class="breadcrumb-item">
    <a href="{{ route('ledgers.index') }}">Ledger</a>
</li>
<li class="breadcrumb-item active">Expense Ledger</li>
@endsection

@section('content')

<div class="container-fluid">

    <div class="card mb-4">
        <div class="card-header bg-light">
            <div class="row align-items-center">
                <div class="d-flex gap-2">
                    <div class="col">
                        <h5 class="mb-0">{{ $head->name }}</h5>
                    </div>

                </div>
            </div>
        </div>

        <div class="card-body">
            <form method="GET" class="search-form">
                <div class="row mb-3">

                    <div class="col-md-4">
                        <!-- <label>From Date</label> -->
                        <input type="date" name="from_date" value="{{ request('from_date') }}" class="form-control">
                    </div>
                    
                    <div class="col-md-4">
                        <!-- <label>To Date</label> -->
                        <input type="date" name="to_date" value="{{ request('to_date') }}" class="form-control">
                    </div>

                    <div class="col-md-4">
                        <button type="submit" class="btn btn-primary">
                            Filter
                        </button>

                        <a href="{{ route('ledger.expense.head', $head->id) }}"
                        class="btn btn-outline-secondary">
                            Clear Filter
                        </a>
                    </div>
                </div>
            </form>
            {{-- PAYMENT METHOD GROUPS --}}
            @php $grandTotal = 0; @endphp
            @foreach($transactions as $method => $rows)
                <div class="card mb-4">
                    <div class="card-header bg-secondary text-white fw-semibold">
                        {{ ucfirst($method) }} Payments
                    </div>

                    <div class="card-body p-0">
                        <table class="table table-bordered table-sm mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Date</th>
                                    <th>Narration</th>
                                    <th class="text-end">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $groupTotal = 0; @endphp

                                @foreach($rows as $t)
                                    @php $groupTotal += $t->transaction_amount; @endphp
                                    <tr>
                                        <td>{{ \Carbon\Carbon::parse($t->transaction_date)->format('d M Y') }}</td>
                                        <td>{{ $t->transaction_details ?? '-' }}</td>
                                        <td class="text-end">
                                            {{ number_format($t->transaction_amount, 2) }}
                                        </td>
                                    </tr>
                                @endforeach

                                {{-- GROUP TOTAL --}}
                                <tr class="table-light fw-bold">
                                    <td colspan="2" class="text-end">Total</td>
                                    <td class="text-end">
                                        {{ number_format($groupTotal, 2) }}
                                    </td>
                                </tr>
                                @php $grandTotal += $groupTotal; @endphp
                            </tbody>
                        </table>
                    </div>
                </div>
            @endforeach
            <table class="table table-bordered table-sm mb-0">
                <tbody>
                    <tr class="table-light fw-bold">
                        <td colspan="2" class="text-end">Grand Total</td>
                        <td class="text-end">
                            <span class="text-danger fw-bold">
                                ₹{{ number_format($grandTotal, 2) }}
                            </span>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection
