<?php $__env->startSection('title','Staff'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item active">Staff</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Staff Management Page -->
    <div id="staff-page" class="page-content">
        <h1 class="mb-4">Staff Management</h1>
        <ul class="nav nav-tabs mb-4" role="tablist">
            <li class="nav-item" role="presentation">
                <button
                    class="nav-link <?php echo e(session('tab', 'list') == 'list' ? 'active' : ''); ?>"
                    id="staff-list-tab"
                    data-bs-toggle="tab"
                    data-bs-target="#staff-list"
                    type="button"
                    role="tab">
                    Staff List
                </button>
            </li>

            <li class="nav-item" role="presentation">
                <button
                    class="nav-link <?php echo e(session('tab') == 'add_staff' ? 'active' : ''); ?>"
                    id="add-staff-tab"
                    data-bs-toggle="tab"
                    data-bs-target="#add-staff"
                    type="button"
                    role="tab">
                    Add Staff
                </button>
            </li>

            <li class="nav-item" role="presentation">
                <button
                    class="nav-link <?php echo e(session('tab') == 'staff_salary' ? 'active' : ''); ?>"
                    id="salary-tab"
                    data-bs-toggle="tab"
                    data-bs-target="#salary-management"
                    type="button"
                    role="tab">
                    Salary Management
                </button>
            </li>
        </ul>



        <div class="tab-content">
            <div class="tab-pane fade <?php echo e(session('tab') == 'list' ? 'show active' : ''); ?>"
                id="staff-list" role="tabpanel">
                <?php echo $__env->make('staff.list', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>

            <div class="tab-pane fade <?php echo e(session('tab') == 'add_staff' ? 'show active' : ''); ?>"
                id="add-staff" role="tabpanel">
                <?php echo $__env->make('staff.create', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>

            <div class="tab-pane fade <?php echo e(session('tab') == 'staff_salary' ? 'show active' : ''); ?>"
                id="salary-management" role="tabpanel">
                <?php echo $__env->make('staff.salary', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function () {

        /* ================= STAFF STATUS TOGGLE ================= */
        $(document).on('change', '.staff-status', function () {
            let checkbox = $(this);
            let status = checkbox.prop('checked') ? 1 : 0;

            $.ajax({
                type: "PUT",
                dataType: "json",
                url: checkbox.data('url'),
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    status: status
                },
                success: function (data) {
                    Swal.fire('Success', data.message, 'success');
                },
                error: function () {
                    Swal.fire('Error', 'Something went wrong', 'error');
                    checkbox.prop('checked', !checkbox.prop('checked'));
                }
            });
        });

        /* ================= SEARCH ESC KEY ================= */
        const nameInput = document.querySelector('input[name="name"]');
        if (nameInput) {
            nameInput.addEventListener('keydown', function (e) {
                if (e.key === 'Escape') {
                    window.location.href = "<?php echo e(route('staff.index')); ?>";
                }
            });
        }

        /* ================= CATEGORY AUTO SUBMIT ================= */
        const categorySelect = document.getElementById('category_id');
        if (categorySelect) {
            categorySelect.addEventListener('change', function () {
                this.form.submit();
            });
        }

    });
</script>

<script>
    $(document).on('click', '.pay-btn', function () {

        let form = $(this).closest('.pay-form');

        Swal.fire({
            title: 'Confirm Salary Payment',
            text: 'Are you sure you want to pay salary for this month?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Pay',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });

    });

    $(document).on('click', '.bluk-pay-form', function () {

        let form = $(this).closest('.bluk-pay-form');

        Swal.fire({
            title: 'Confirm Salary Payment',
            text: 'Are you sure you want to pay salary for this month?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Pay',
            cancelButtonText: 'Cancel'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });

    });
</script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\school\resources\views/staff/index.blade.php ENDPATH**/ ?>