<div class="card">
    <div class="card-header bg-light">
        <div class="row align-items-center">
            <div class="col-md-4">
                <h5 class="mb-0">All Staff Members</h5>
            </div>
            <div class="col-md-8">
                <form method="GET" action="{{ route('staff.index') }}" class="row g-2">

                    {{-- Category --}}
                    <div class="col-md-6">
                        <select name="category"
                                id="category_id"
                                class="form-select form-select-sm">
                            <option value="">All Category</option>
                            <option value="Teacher" {{ request('category') == 'Teacher' ? 'selected' : '' }}>Teacher</option>
                            <option value="Non-Teacher" {{ request('category') == 'Non-Teacher' ? 'selected' : '' }}>Non-Teacher
                            </option>
                        </select>
                    </div>

                    {{-- Search --}}
                    <div class="col-md-6">
                        <input type="search"
                            name="name"
                            value="{{ request('name') }}"
                            class="form-control form-control-sm"
                            placeholder="Search by name">
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Category</th>
                        <th>Designation</th>
                        <th>Qualification</th>
                        <th>Phone</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>

                <tbody>
                    @forelse($staffs as $staff)
                        <tr>
                            <td>{{ $staff->name }}</td>

                            <td>
                                <span class="badge bg-info">
                                    {{ ucfirst($staff->category) }}
                                </span>
                            </td>

                            <td>{{ $staff->designation }}</td>
                            <td>{{ $staff->qualification }}</td>
                            <td>{{ $staff->phone }}</td>
                            <td>{{ $staff->email ?? '-' }}</td>

                            <td>
                                <div class="form-check form-switch">
                                    <input
                                        class="form-check-input staff-status"
                                        type="checkbox"
                                        id="status_{{ $staff->id }}"
                                        data-id="{{ $staff->id }}"
                                        data-url="{{ route('staff.update', $staff->id) }}"
                                        {{ $staff->status ? 'checked' : '' }}
                                    >
                                </div>
                            </td>

                            <td>
                                <a href="{{ route('staff.edit', $staff->id) }}"
                                   class="btn btn-sm btn-outline-primary">
                                    Edit
                                </a>
                                <a href="{{ route('staff.show', $staff->id) }}" class="btn btn-sm btn-outline-secondary">View</a>

                                <!-- <form action="{{ route('staff.destroy', $staff->id) }}"
                                      method="POST"
                                      class="d-inline"
                                      onsubmit="return confirm('Remove staff from current academic year?')">
                                    @csrf
                                    @method('DELETE')
                                    <button class="btn btn-sm btn-outline-danger">
                                        Remove
                                    </button>
                                </form> -->
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center text-muted">
                                No staff found for the current academic year
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        <div class="mt-3">
            {{ $staffs->links() }}
        </div>
    </div>
</div>
