<?php if($paginator->lastPage() > 1): ?>
    <ul class="pagination justify-content-center">
        
        
        <li class="page-item <?php echo e($paginator->onFirstPage() ? 'disabled' : ''); ?>">
            <a href="<?php echo e($paginator->previousPageUrl()); ?>" class="page-link">&lt;</a>
        </li>

        
        <?php for($i = 1; $i <= $paginator->lastPage(); $i++): ?>
            <li class="page-item <?php echo e($paginator->currentPage() == $i ? 'active' : ''); ?>">
                <a href="<?php echo e($paginator->url($i)); ?>" class="page-link"><?php echo e($i); ?></a>
            </li>
        <?php endfor; ?>

        
        <li class="page-item <?php echo e(!$paginator->hasMorePages() ? 'disabled' : ''); ?>">
            <a href="<?php echo e($paginator->nextPageUrl()); ?>" class="page-link">&gt;</a>
        </li>
    </ul>
<?php endif; ?>
<?php /**PATH /var/www/html/cholantravels/backend/resources/views/admin/common/pagination.blade.php ENDPATH**/ ?>