<?php $__env->startSection('title','Packages'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h2">
                    <i class="fas fa-envelope me-2"></i>Tour Reviews
                </h1>
            </div>
        </div>
    </div>
    
    <!-- Inquiry Type Tabs -->
    <div class="row mb-3">
        <div class="col-12">
            <ul class="nav nav-pills">
                <li class="nav-item">
                    <a class="nav-link active" href="<?php echo e(route('admin.reviews.packages')); ?>">
                        <i class="fas fa-map-marked-alt me-1"></i>Tour Reviews
                    </a>
                </li>
                <!-- <li class="nav-item">
                    <a class="nav-link" href="inquiries-cab.html">
                        <i class="fas fa-taxi me-1"></i>Cab Booking
                    </a>
                </li> -->
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.reviews.hotels')); ?>">
                        <i class="fas fa-bed me-1"></i>Hotel Reviews
                    </a>
                </li>
            </ul>
        </div>
    </div>
    
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Package</th>
                                    <th>Customer Name</th>
                                    <th>Rating</th>
                                    <th>Comment</th>
                                    <th>Approval Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <div>
                                            <strong class="text-primary d-block package-details" data-id="<?php echo e($review->package->id); ?>"><?php echo e($review->package->title ?? 'N/A'); ?></strong>
                                            <small class="text-muted">Duration :
                                                <?php echo e($review->package->details->duration_days.' D/ '.$review->package->details->duration_nights.' N'); ?>

                                        </small>
                                        </div>
                                    </td>
                                    <td>
                                        <strong class="text-primary"><?php echo e($review->customer_name); ?></strong>
                                    </td>
                                    <td>
                                        <?php echo e($review->rating); ?>

                                    </td>
                                    <td>
                                        <?php echo \Illuminate\Support\Str::words($review->comment, 5, '...'); ?>


                                    </td>
                                    <td>
                                        <input id="status_<?php echo e($review->id); ?>" type="checkbox" data-id="<?php echo e($review->id); ?>" data-url="<?php echo e(route('admin.reviews.status',$review->id)); ?>" class="js-switch update-review" <?php echo $review->is_approved == 1 ? 'checked' : '' ?>>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary get-review" data-url="<?php echo e(route('admin.reviews.package.detail',$review->id)); ?>">
                                            <i class="fas fa-eye icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-danger delete-review" data-url="<?php echo e(route('admin.reviews.package.delete',$review->id)); ?>">
                                            <i class="fas fa-trash icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo $__env->make('admin.common.pagination', ['paginator' => $reviews], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="viewReviewModal1" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function () {

    // ================== VIEW ENQUIRY ==================
    $(document).on("click", ".get-review", function () {
        let btn = $(this);
        btn.find('.spinner-border').removeClass('d-none');
        btn.find('.icon').addClass('d-none');

        let url = $(this).data("url");
        let upurl = $(this).data("upurl");

        $.get(url, function (res) {
            if (res.success) {
                let data = res.data;

                // populate modal
                let modal = $("#viewReviewModal1");

                modal.find(".modal-title").text("Review #" + data.package.title);
                modal.find(".modal-body").html(`
                    <h6 class="fw-bold">Customer Information</h6>
                    <p><strong>Name:</strong> ${data.customer_name}</p>
                    <p><strong>Status</strong> ${data.is_approved == 1 ? 'Approved' : 'Not Approved'}</p>
                    <h6 class="fw-bold mt-3">Comment</h6>
                    <p class="text-muted">${data.comment ?? ''}</p>
                `);

                modal.modal("show");
            }
        }).fail(function () {
            Swal.fire("Error", "Failed to fetch review details.", "error");
        }).always(function () {
            // This runs after success or failure
            btn.find('.spinner-border').addClass('d-none');
            btn.find('.icon').removeClass('d-none');
        });
    });

    // ================== UPDATE STATUS ==================
    $(document).on('change', '.update-review', function() {
            let review_status = $(this).prop('checked') === true ? 1 : 0;
            $.ajax({
                type: "PUT",
                dataType: "json",
                url: $(this).data('url'),
                data: {
                    'status': review_status
                },
                success: function(data) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: data.message
                    });
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while processing your request.'
                    });
                }

            });
        });


    // ================== DELETE ENQUIRY ==================
    $(document).on("click", ".delete-review", function () {
        let url = $(this).data("url");
        Swal.fire({
            title: "Are you sure?",
            text: "This review will be permanently deleted.",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#d33",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, Delete",
        }).then((result) => {
            if (result.isConfirmed) {
                let btn = $(this);
                btn.find('.spinner-border').removeClass('d-none');
                btn.find('.icon').addClass('d-none');
                $.ajax({
                    url: url,
                    type: "DELETE",
                    data: { _token: "<?php echo e(csrf_token()); ?>" },
                    success: function (res) {
                        if (res.success) {
                            Swal.fire("Deleted!", "Review has been removed.", "success").then(() => {
                                location.reload();
                            });
                        }
                    },
                    error: function () {
                        Swal.fire("Error", "Failed to delete review.", "error");
                    },
                    complete: function () {
                        // Hide loader, show button text back
                        btn.find('.spinner-border').addClass('d-none');
                        btn.find('.icon').removeClass('d-none');
                    }
                });
            }
        });
    });

});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/cholantravels/backend/resources/views/admin/reviews/packages.blade.php ENDPATH**/ ?>