<?php $__env->startSection('title','Luxury Hotel'); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h2">
                    <i class="fas fa-cog me-2"></i>Luxury Hotel Page Settings
                </h1>
            </div>
        </div>
    </div>
     <!-- Action Buttons -->
    <div class="row mb-4">
        <div class="col-12">
            <button class="btn btn-warning" onclick="addHotel();">
                <i class="fas fa-plus me-2"></i>Add Luxury Hotel
            </button>
        </div>
    </div>
    
    <!-- Inquiry Type Tabs -->
    <div class="row mb-3">
        <div class="col-12">
            <ul class="nav nav-pills">
                <li class="nav-item">
                    <a class="nav-link tab_link <?php echo e((session('active_tab') && session('active_tab') == 'hotel_page') ? 'active' :''); ?> <?php echo e(!session('active_tab') ? 'active' : ''); ?>"  data-tab="hotel_page_tab">
                        <i class="fas fa-cog me-1"></i>Luxury Hotel Page Info
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link tab_link <?php echo e((session('active_tab') && session('active_tab') == 'hotel_list') ? 'active' :''); ?>" data-tab="hotel_list_tab">
                        <i class="fas fa-hotel me-1"></i>Luxury Hotels
                    </a>
                </li>
            </ul>
        </div>
    </div>
    
    <div class="row tab_details <?php echo e((session('active_tab') && session('active_tab') != 'hotel_page') ? 'd-none' :''); ?>" id="hotel_page_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-cog me-2"></i>Page Details
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <strong><?php echo e($page_details->title); ?></strong>
                                    </td>
                                    <td>
                                        <?php echo \Illuminate\Support\Str::words($page_details->description, 10, '...'); ?>


                                    </td>
                                    <td>
                                        <div class="card mb-3">
                                            <img id="page-banner-image" src="<?php echo e(storage_link($page_details->banner_image)); ?>" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                        </div>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editPageModal">
                                            <i class="fas fa-edit icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-primary page-faqs" data-id="<?php echo e($page_details->id); ?>"  data-url="<?php echo e(route('admin.page.faqUpdate',$page_details->id)); ?>">
                                            <i class="fa fa-question-circle icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-primary page-meta" data-id="<?php echo e($page_details->id); ?>" data-url="<?php echo e(route('admin.page-meta.show.meta',$page_details->id)); ?>">
                                            <i class="fas fa-globe icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row tab_details <?php echo e((session('active_tab') && session('active_tab') == 'hotel_list') ? '' :'d-none'); ?>" id="hotel_list_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-hotel me-2"></i>Luxury Hotels
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Title</th>
                                    <th>Location</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $hotels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hotel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <strong class="text-primary d-block"><?php echo e($hotel->title); ?></strong>
                                        </td>
                                        <td>
                                            <?php echo e($hotel->location); ?>

                                        </td>
                                        <td>
                                            <?php echo \Illuminate\Support\Str::words($hotel->short_description, 10, '...'); ?>


                                        </td>
                                        <td>
                                            <div class="card mb-3">
                                                <img id="page-banner-image" src="<?php echo e(storage_link($hotel->primary_image)); ?>" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                            </div>
                                            <!-- <div class="card mb-3">
                                                <img id="page-banner-image" src="<?php echo e(Storage::disk('s3')->url($hotel->primary_image)); ?>" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                            </div> -->
                                        </td>
                                        <td>
                                            <input id="status_<?php echo e($hotel->id); ?>" type="checkbox" data-id="<?php echo e($hotel->id); ?>" data-url="<?php echo e(route('admin.hotels.update',$hotel->id)); ?>" class="js-switch hotel-status" <?php echo $hotel->is_active == 1 ? 'checked' : '' ?>>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-primary hotel-details" data-id="<?php echo e($hotel->id); ?>" data-url="<?php echo e(route('admin.hotels.show',$hotel->id)); ?>">
                                                <i class="fas fa-eye icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-success hotel-edit" data-id="<?php echo e($hotel->id); ?>" data-url="<?php echo e(route('admin.hotels.show',$hotel->id)); ?>" data-udurl="<?php echo e(route('admin.hotels.update',$hotel->id)); ?>">
                                                <i class="fas fa-edit icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-success update-rooms" data-id="<?php echo e($hotel->id); ?>" data-url="<?php echo e(route('admin.hotel.roomUpdate',$hotel->id)); ?>" title="Add Room">
                                                <i class="fas fa-bed icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-success update-todos" data-id="<?php echo e($hotel->id); ?>" data-url="<?php echo e(route('admin.hotel.todoUpdate',$hotel->id)); ?>" title="Add To Do">
                                                <i class="fas fa-map-marker icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-primary hotel-faqs" data-id="<?php echo e($hotel->id); ?>" data-url="<?php echo e(route('admin.hotel.faqUpdate',$hotel->id)); ?>">
                                                <i class="fa fa-question-circle icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-primary hotel-meta" data-id="<?php echo e($hotel->id); ?>" data-upurl="<?php echo e(route('admin.hotels.update',$hotel->id)); ?>" data-url="<?php echo e(route('admin.hotel-meta.show.meta',$hotel->id)); ?>">
                                                <i class="fa fa-globe icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-danger delete-hotel" data-id="<?php echo e($hotel->id); ?>" data-url="<?php echo e(route('admin.hotels.destroy',$hotel->id)); ?>"><i class="fas fa-trash"></i></button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>

<div class="modal fade" id="editPageModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-pencil me-2"></i>Edit Luxury Hotel Page
                </h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="editPage" method="POST" action="<?php echo e(route('admin.page.update',$page_details->id)); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?> 
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_page_title" class="form-label">Title</label>
                        <input type="text" class="form-control" id="edit_page_title" name="title" value="<?php echo e(old('title',$page_details->title)); ?>" required>
                    </div>
                    <div class="row" id="praimaryPreview">
                        <div class="col-md-12">
                            <div class="card mb-3">
                                <img id="edit-banner-image" src="<?php echo e(storage_link($page_details->banner_image)); ?>" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <input type="text" class="form-control mb-2" id="edit_banner_image_alt" name="banner_image_alt" required placeholder="Banner Image Alt Text" value="<?php echo e(old('banner_image_alt',$page_details->banner_image_alt)); ?>">
                        <div class="text-danger d-none" id="edit-banner-image-alt-error"></div>
                        <label for="edit_banner_image" class="form-label">Image</label>
                        <input type="file" class="form-control" id="edit_banner_image" name="banner_image" accept=".webp,image/webp" <?php echo e(!$page_details->banner_image ? 'required' : ''); ?>>
                        <div class="text-danger d-none" id="edit-banner-image-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control tinymce" 
                        id="description" name="description" rows="5">
                            <?php echo e(old('description',$page_details->description)); ?>

                        </textarea>
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="submit-btn">
                        <i class="fas fa-save me-2"></i>Update Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="faqModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="city-title">Faqs</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="faqForm" method="POST" action="" enctype="multipart/form-data">
            <?php echo csrf_field(); ?> 
            <?php echo method_field('PUT'); ?>
                <div class="modal-body"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-page-setting-btn" data-url="">
                        <i class="fas fa-save me-2"></i>Save Faqs
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="addHotelModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i>Add New Luxury Hotel
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="addHotelForm" method="POST" action="<?php echo e(route('admin.hotels.store')); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?> 
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="add_hotel_title" class="form-label">Title<span class="required-text">*</span></label>
                        <input type="text" class="form-control" id="add_hotel_title" name="title" required>
                        <div class="invalid-feedback title-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="add_hotel_location" class="form-label">Location<span class="required-text">*</span></label>
                        <input type="text" class="form-control" id="add_hotel_location" name="location" required>
                        <div class="invalid-feedback location-error"></div>
                    </div>
                    <div class="row mb-3" id="addPrimaryImagePreview"></div>
                    <div class="mb-3">
                        <label for="add_primary_image" class="form-label">Primary Image<span class="required-text">*</span> (accept only .webp)</label>
                        <input type="file" class="form-control mb-2" id="add_primary_image" name="primary_image" accept=".webp,image/webp" required>
                        <div class="invalid-feedback primary-image-error"></div>
                        <input type="text"  class="form-control"  id="add_primary_image_alt" name="primary_image_alt" 
                        value="" required placeholder="Primary Image Alt Text" >
                    </div>
                    <div class="row" id="galleryPreview"></div>
                    <div class="mb-3">
                        <label for="add_gallery_image" class="form-label">Gallery Images<span class="required-text">*</span>(accept only .webp)(Select Multiple Image)</label>
                        <input type="file" name="images[]" accept=".webp,image/webp" id="galleryInput" multiple class="form-control">
                    </div>
                    <div class="mb-3">
                        <label for="add_short_description" class="form-label">Short Description<span class="required-text">*</span></label>
                        <textarea class="form-control tinymce" id="add_short_description" name="short_description" rows="3" ></textarea>
                        <div class="invalid-feedback short-description-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="add_refund_cancellation_policy" class="form-label">Refund/Cancellation Policy<span class="required-text">*</span></label>
                        <textarea class="form-control tinymce" id="add_refund_cancellation_policy" name="refund_cancellation_policy" rows="3" ></textarea>
                        <div class="invalid-feedback refund-cancellation-policy-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="add_facilities" class="form-label">Facilities</label>
                        <div class="row">
                            <?php $__currentLoopData = $facilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-2 mb-3">
                                <label class="form-label"><?php echo e($f->name); ?></label>
                                <input type="checkbox" name="facilities[]"  value="<?php echo e($f->icon); ?>"
                                    <?php echo e(in_array($f->icon, old('facilities', [])) ? 'checked' : ''); ?>

                                >
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="is_top_luxury" class="form-label">Top Luxury Hotel?</label>
                        <input type="checkbox"  id="is_top_luxury" value="1" name="is_top_luxury" >
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success rounded-md" id="add-submit-btn">
                        <i class="fas fa-plus me-2"></i>Add Hotel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="editHotelModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-pencil me-2"></i>Edit Luxury Hotel
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <input type="hidden" id="hotel_id" name="id">
            <form id="editHotelForm" method="POST"  enctype="multipart/form-data">
                <?php echo csrf_field(); ?> 
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_hotel_title" class="form-label">Title<span class="required-text">*</span></label>
                        <input type="text" class="form-control" id="edit_hotel_title" name="title" required>
                        <div class="invalid-feedback title-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_hotel_location" class="form-label">Location<span class="required-text">*</span></label>
                        <input type="text" class="form-control" id="edit_hotel_location" name="location" required>
                        <div class="invalid-feedback location-error"></div>
                    </div>
                    <div class="row mb-3" id="editPrimaryImagePreview">
                        <div class="col-md-12 text-center">
                            <div class="card mb-3">
                                <img src="" id="edit_primary_image_preview" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <input type="text"  class="form-control mb-2"  id="edit_primary_image_alt" name="primary_image_alt" 
                        value="" required placeholder="Primary Image Alt Text" >
                        <label for="edit_primary_image" class="form-label">Primary Image</label>
                        <input type="file" class="form-control" id="edit_primary_image" name="primary_image" accept=".webp,image/webp" >
                        <div class="invalid-feedback primary-image-error"></div>
                    </div>
                    <div class="row" id="galleryPreviewEdit"></div>
                    <div class="mb-3">
                        <label for="edit_images" class="form-label">Gallery Images<span class="required-text">*</span>(accept only .webp)(Select Multiple Image)</label>
                        <input type="file" name="images[]" accept=".webp,image/webp" id="galleryInputEdit" multiple class="form-control" >
                    </div>
                    <div class="mb-3">
                        <label for="edit_short_description" class="form-label">Short Description<span class="required-text">*</span></label>
                        <textarea class="form-control tinymce" id="edit_short_description" name="short_description" rows="3" ></textarea>
                        <div class="invalid-feedback short-description-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_refund_cancellation_policy" class="form-label">Refund/Cancellation Policy<span class="required-text">*</span></label>
                        <textarea class="form-control tinymce" id="edit_refund_cancellation_policy" name="refund_cancellation_policy" rows="3" ></textarea>
                        <div class="invalid-feedback refund-cancellation-policy-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_facilities" class="form-label">Facilities<span class="required-text">*</span></label>
                        <div class="row">
                            <?php $__currentLoopData = $facilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-2 mb-3">
                                <label class="form-label"><?php echo e($f->name); ?></label>
                                <input type="checkbox" name="facilities[]"  value="<?php echo e($f->icon); ?>"
                                    <?php echo e(in_array($f->icon, old('facilities', [])) ? 'checked' : ''); ?>

                                >
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="is_top_luxury_edit" class="form-label">Top Luxury Hotel?</label>
                        <input type="checkbox"  id="is_top_luxury_edit" value="1" name="is_top_luxury" >
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning rounded-md" id="edit-submit-btn">
                        <i class="fas fa-save me-2"></i>Update Hotel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="viewHotelModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body"></div>
        </div>
    </div>
</div>

<div class="modal fade" id="addHotelRoomModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i>Add New Room
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>

            <form id="roomForm" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?> 
                <?php echo method_field('PUT'); ?>

                <div class="modal-body">
                    <div id="room-wrapper"></div>

                </div>

                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-outline-success" id="addMoreRoom">
                        <i class="fas fa-plus"></i> Add Another Room
                    </button>
                    <div>
                        <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-warning rounded-md" id="add-room-submit-btn">
                            <i class="fas fa-save me-2"></i>Save Room
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="addHotelTodoModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i>Add New Top Things To Do
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>

            <form id="todoForm" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?> 
                <?php echo method_field('PUT'); ?>

                <div class="modal-body">
                    <div id="todo-wrapper"></div>

                </div>

                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-outline-success" id="addMoreTodo">
                        <i class="fas fa-plus"></i> Add Another To Do
                    </button>
                    <div>
                        <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-warning rounded-md" id="add-todo-submit-btn">
                            <i class="fas fa-save me-2"></i>Save To Do
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="pageMetaModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="page-title">Edit Meta Info</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="pageMeta" method="POST" action="<?php echo e(route('admin.page.update',$page_details->id)); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?> 
            <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <input type="hidden" name="meta_setting">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_title" class="form-label">Meta Title<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_title" name="meta_title" required>
                                <div class="text-danger d-none" id="page-meta-title-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_description" class="form-label">Meta Description<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_description" name="meta_description" required>
                                <div class="text-danger d-none" id="page-meta-description-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_keywords" class="form-label">Meta Keywords<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_keywords" name="meta_keywords" required>
                                <div class="text-danger d-none" id="page-meta-keyords-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_h1_heading" class="form-label">H1 Heading<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_h1_heading" name="h1_heading" required>
                                <div class="text-danger d-none" id="page-meta-keyords-error"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-3">
                            <label for="page_meta_details" class="form-label">Extra Meta Tag<span class="required-text">*</span></label>
                            <textarea class="form-control"  name="meta_details" id="page_meta_details" rows="5" id="meta_details"></textarea>
                            <div class="text-danger d-none" id="page-meta-details-error"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-page-meta-btn">
                        <i class="fas fa-save me-2"></i>Update Meta Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="hotelMetaModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="hotel-title">Edit Meta Info</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="hotelMeta" method="POST" action="" enctype="multipart/form-data">
            <?php echo csrf_field(); ?> 
            <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <input type="hidden" name="meta_setting">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="hotel_meta_title" class="form-label">Meta Title<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="hotel_meta_title" name="meta_title" required>
                                <div class="text-danger d-none" id="hotel-meta-title-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="hotel_meta_description" class="form-label">Meta Description<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="hotel_meta_description" name="meta_description" required>
                                <div class="text-danger d-none" id="hotel-meta-description-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="hotel_meta_keywords" class="form-label">Meta Keywords<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="hotel_meta_keywords" name="meta_keywords" required>
                                <div class="text-danger d-none" id="hotel-meta-keyords-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="hotel_h1_heading" class="form-label">H1 Heading<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="hotel_h1_heading" name="h1_heading" required>
                                <div class="text-danger d-none" id="hotel-meta-keyords-error"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-3">
                            <label for="hotel_meta_details" class="form-label">Extra Meta Tag<span class="required-text">*</span></label>
                            <textarea class="form-control"  name="meta_details" id="hotel_meta_details" rows="5" id="meta_details"></textarea>
                            <div class="text-danger d-none" id="hotel-meta-details-error"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-hotel-meta-btn">
                        <i class="fas fa-save me-2"></i>Update Meta Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    let faqIndex = 0;
    let selectedFiles = [];
    let imageCounter = 0;

    function activeTab(ele){
        // Remove active from all nav links
        let nav = document.querySelectorAll('.tab_link');
        nav.forEach(function(element) {
            element.classList.remove('active');
            if (element.getAttribute('data-tab') === ele) {
                element.classList.add('active');
            }
        });

        // Hide all tabs
        let tab = document.querySelectorAll('.tab_details');
        tab.forEach(function(element) {
            element.classList.add('d-none');
        });

        let selectTab = document.getElementById(ele);
        if (selectTab) {
            selectTab.classList.remove('d-none');
        }
    }

    function addHotel() {
        activeTab('hotel_list_tab');
        let oldInput = document.querySelector('.static-input');
        if (oldInput) {
            oldInput.remove();
        }
        let dealModal = new bootstrap.Modal(document.getElementById('addHotelModal'));
        dealModal.show();
    }

    function deleteImage(imageId){
        Swal.fire({
            title: "Are you sure?",
            text: "This image will be deleted!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#e3342f",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it",
            cancelButtonText: "Cancel",
            customClass: {
                popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                confirmButton: 'px-4 py-2 text-white',
                cancelButton: 'px-4 py-2 text-white'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "<?php echo e(route('admin.hotel.images.delete')); ?>", // create this route
                    type: 'DELETE',
                    data: {
                        id: imageId
                    },
                    success: function(res){
                        if(res.success){
                            $('#img-' + imageId).remove();
                        } else {
                            toastr.error('Hotel image not deleted', 'Failed');
                        }
                    }
                });
            }
        });
    }

    function renderPreview(emptyGallery=false) {
        if(emptyGallery) $(".new-uplod").remove();
        let dt = new DataTransfer(true);

        selectedFiles.forEach((file, index) => {
            if (file && (file.type === 'image/webp')) {
                let reader = new FileReader();
                reader.onload = function(e) {
                    let cardId = "preview-card-" + index;
                    let col = `
                        <div class="col-md-3 mb-3 new-uplod text-center" id="${cardId}">
                            <div class="card">
                                <img src="${e.target.result}" class="card-img-top img-fluid" 
                                    style="height:150px; object-fit:cover;">
                                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeImage(${index})"><i class="fas fa-trash"></i> Remove</button> 
                            </div>
                        </div>`;
                    $("#galleryPreviewEdit").append(col);
                };
                reader.readAsDataURL(file);
            }
            dt.items.add(file); // rebuild FileList
        });

        // update the input with new FileList
        document.getElementById("galleryInputEdit").files = dt.files;
    }

    function removeImage(index) {
        selectedFiles.splice(index, 1); // remove file from array
        renderPreview(true); // re-render & rebuild FileList
    }


    $(document).ready(function () {
        <?php if(session('success')): ?>
            toastr.success("<?php echo e(session('success')); ?> ", 'Success');
        <?php endif; ?>

        $(document).on('click', '.tab_link', function() {
            $('.tab_link').removeClass('active');
            $(this).addClass('active');
            $('.tab_details').addClass('d-none');
            let ele = $(this).data('tab');
            $('#'+ele).removeClass('d-none');
        });


        document.getElementById('editPage').addEventListener('submit', function(event) {
            tinymce.triggerSave();
            event.preventDefault(); 
            $('.invalid-feedback').addClass('d-none');
            $('#submit-btn').prop('disabled',true);
            let isError = 0;
            let description = document.getElementById('description');
            if(!description.value.trim()) {
                $('.invalid-feedback').removeClass('d-none');
                $('.invalid-feedback').addClass('d-block');
                $('.invalid-feedback').text('Descriptions required');
                $('#submit-btn').prop('disabled',false);
            } else {
                this.submit();
            }

        });

        
    
        /* ==== Primary Image Preview ==== */
        document.getElementById('edit_banner_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = event.target.files[0];
            let preview = document.getElementById('praimaryPreview');
            

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && (file.type === 'image/webp')) {
                dt.items.add(file); // Keep valid file
                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; // Clear old preview
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }
            input.files = dt.files;
        });

        $(document).on('click', '.page-faqs', function() {
            faqIndex = 0;
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let dataUrl = btn.data('url');
            
            $('#faqForm').attr('action',dataUrl);
            $.ajax({
                type: "GET",
                dataType: "json",
                url: "<?php echo e(route('admin.page.faq')); ?>", // better to point this to a dedicated faq route
                data: { id: id },
                success: function(data) {
                    let faqs = data.faqs || [];
                    let body = `
                    <table class="table" id="faqTable">
                        <thead>
                            <tr>
                                <th>Question</th>
                                <th>Answer</th>
                                <th><button type="button" class="btn btn-sm btn-outline-success" id="addFaqRow"><i class="fas fa-plus"></button></th>
                            </tr>
                        </thead>
                        <tbody>
                    `;

                    if (faqs.length > 0) {
                        $.each(faqs, function(index, faq) {
                            body += `
                                <tr class="b-none">
                                    <td><input type="text" name="faqs[${faqIndex}][question]" value="${faq.question}" class="form-control" required /></td>
                                    <td><textarea name="faqs[${faqIndex}][answer]" class="form-control">${faq.answer ?? ''}</textarea></td>
                                    <td><button type="button" class="btn btn-sm btn-outline-danger removeFaqRow"><i class="fas fa-trash"></button></td>
                                </tr>
                            `;
                            faqIndex++;
                        });
                    } else {
                        body += `
                            <tr class="b-none">
                                <td><input type="text" name="faqs[${faqIndex}][question]" class="form-control" required/></td>
                                <td><textarea name="faqs[${faqIndex}][answer]" class="form-control"></textarea></td>
                                <td></td>
                            </tr>
                        `;
                        faqIndex++;
                    }

                    body += `</tbody></table>`;

                    $('#faqModal .modal-body').html(body);

                    // open modal
                    $('#faqModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching hotel FAQs.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $(document).on('click', '#addFaqRow', function() {
            let row = `
                <tr class="b-none">
                    <td><input type="text" name="faqs[${faqIndex}][question]" class="form-control" required /></td>
                    <td><textarea name="faqs[${faqIndex}][answer]" class="form-control"></textarea></td>
                    <td><button type="button" class="btn btn-sm btn-outline-danger removeFaqRow"><i class="fas fa-trash"></button></td>
                </tr>`;
            faqIndex++;
            $('#faqTable tbody').append(row);
            
        });

        $(document).on('click', '.removeFaqRow', function() {
            $(this).closest('tr').remove();
        });


        document.getElementById('add_primary_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = input.files[0];
            let preview = document.getElementById('addPrimaryImagePreview');
            // Clear old preview

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && (file.type === 'image/webp')) {
                dt.items.add(file); // Keep valid file

                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = "";
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }

            // Replace with filtered file list (empty if invalid)
            input.files = dt.files;
        });


        /* ==== Gallery Images Preview ==== */
        document.getElementById('galleryInput').addEventListener('change', function(event) {
            let input = event.target;
            let files = input.files;
            let preview = document.getElementById('galleryPreview');
            preview.innerHTML = ""; // Clear old previews

            let dt = new DataTransfer(); // New file list

            Array.from(files).forEach(file => {
                // Keep only .webp
                if (file.type === 'image/webp') {
                    dt.items.add(file); // Add valid file to new list

                    let reader = new FileReader();
                    reader.onload = function(e) {
                        let col = document.createElement('div');
                        col.classList.add('col-md-3', 'mb-3');
                        col.innerHTML = `
                            <div class="card">
                                <img src="${e.target.result}" class="card-img-top img-fluid" 
                                    style="height:150px; object-fit:cover;">
                            </div>
                            <input type="text" name="images_alt[]"  class="form-control" placeholder="Image Alt Text">
                        `;
                        preview.appendChild(col);
                    };
                    reader.readAsDataURL(file);
                } else {
                    toastr.error("Only .webp images are allowed!", 'Error');
                }
            });

            // Replace input files with filtered list
            input.files = dt.files;
        });

        document.getElementById('addHotelForm').addEventListener('submit', function(event) {
            tinymce.triggerSave();
            event.preventDefault(); 
            $('.invalid-feedback').hide();
            $('#add-submit-btn').prop('disabled',true);
            let isError = 0;
            let short_description = document.getElementById('add_short_description');
            if(!short_description.value.trim()) {
                isError = 1;
                $('.short-description-error').show();
                $('.short-description-error').text('Short descriptions required');
                // $('html, body').animate({
                //     scrollTop: short_description.offset().top - 100   // adjust -100 for some spacing from top
                // }, 600);
            }

            let refund_cancellation_policy = document.getElementById('add_refund_cancellation_policy');
            if(!refund_cancellation_policy.value.trim()) {
                isError = 1;
                $('.refund-cancellation-policy-error').show();
                $('.refund-cancellation-policy-error').text('Policy required');
                // $('html, body').animate({
                //     scrollTop: short_description.offset().top - 100   // adjust -100 for some spacing from top
                // }, 600);
            }


            if(isError){
                $('#add-submit-btn').prop('disabled',false);
            } else {
                let form = this;
                let title = document.getElementById('add_hotel_title').value.trim();
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('admin.hotels.slug.duplicate_check')); ?>",
                    data: {'title':title},
                    success: function(res) {
                        if (res.exists) {
                            $('.title-errorr').show();
                            $('.title-error').text('This title already exists');
                        } else {
                            $('.title-errorr').hide();
                            form.submit();
                        }
                    },
                    error:function(err){
                        form.submit();
                    }
                });
            }

        });

        $(document).on('change', '.hotel-status', function() {
            let hotel_status = $(this).prop('checked') === true ? 1 : 0;
            $.ajax({
                type: "PUT",
                dataType: "json",
                url: $(this).data('url'),
                data: {
                    'status': hotel_status
                },
                success: function(data) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: data.message
                    });
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while processing your request.'
                    });
                }

            });
        });

        $(document).on('click', '.hotel-faqs', function() {
            faqIndex = 0;
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let title = btn.data('title');
            let dataUrl = btn.data('url');
            
            $('#faqForm').attr('action',dataUrl);
            $.ajax({
                type: "GET",
                dataType: "json",
                url: "<?php echo e(route('admin.hotels.index')); ?>", // better to point this to a dedicated faq route
                data: { id: id, faqs: 'list' },
                success: function(data) {
                    let faqs = data.faqs || [];
                    $('#faqModal .modal-title').text(title);

                    let body = `
                    <table class="table" id="faqTable">
                        <thead>
                            <tr>
                                <th>Question</th>
                                <th>Answer</th>
                                <th><button type="button" class="btn btn-sm btn-outline-success" id="addFaqRow"><i class="fas fa-plus"></button></th>
                            </tr>
                        </thead>
                        <tbody>
                    `;

                    if (faqs.length > 0) {
                        $.each(faqs, function(index, faq) {
                            body += `
                                <tr class="b-none">
                                    <td><input type="text" name="faqs[${faqIndex}][question]" value="${faq.question}" class="form-control" required /></td>
                                    <td><textarea name="faqs[${faqIndex}][answer]" class="form-control">${faq.answer ?? ''}</textarea></td>
                                    <td><button type="button" class="btn btn-sm btn-outline-danger removeFaqRow"><i class="fas fa-trash"></button></td>
                                </tr>
                            `;
                            faqIndex++;
                        });
                    } else {
                        body += `
                            <tr class="b-none">
                                <td><input type="text" name="faqs[${faqIndex}][question]" class="form-control" required/></td>
                                <td><textarea name="faqs[${faqIndex}][answer]" class="form-control"></textarea></td>
                                <td></td>
                            </tr>
                        `;
                        faqIndex++;
                    }

                    body += `</tbody></table>`;

                    $('#faqModal .modal-body').html(body);

                    // open modal
                    $('#faqModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching hotel FAQs.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $(document).on("click", ".delete-hotel", function(e) {
            e.preventDefault();
            let itemId = $(this).data("id");
            let itemUrl = $(this).data("url");
            let row = $(this).closest("tr"); // parent <tr>
            Swal.fire({
                title: "Are you sure?",
                text: "This item will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                customClass: {
                    popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                    confirmButton: 'px-4 py-2 text-white',
                    cancelButton: 'px-4 py-2 text-white'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: itemUrl,
                        success: function(res) {
                            if(res.success){
                                row.remove();
                                Swal.fire(
                                    "Deleted!",
                                    "The item has been deleted successfully.",
                                    "success"
                                );
                            }
                        },
                        error: function(xhr) {
                            toastr.error('Hotel not deleted!', 'Failed');
                        }
                    });
                    
                }
            });
        });

        $(document).on('click', '.hotel-details', function() {
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let dataurl = btn.data('url');
            $.ajax({
                type: "GET",
                dataType: "json",
                url: dataurl,
                data: { id: id },
                success: function(data) {
                    $('#viewHotelModal .modal-title').text(data.title + (data.is_top_luxury ? ' (Top Luxury Hotel)' :''));

                    let body = `
                        <div class="row">
                            <div class="col-md-12">
                                <p><strong>Location:</strong> ${data.location}</p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p><strong>Facilities:</strong> ${
                                    Array.isArray(data.facilities)
                                        ? data.facilities
                                            .map(f => f.replace(/\b\w/g, c => c.toUpperCase())) // Title Case each word
                                            .join(', ')
                                        : (typeof data.facilities === "string"
                                            ? data.facilities.replace(/\b\w/g, c => c.toUpperCase())
                                            : '')
                                }</p>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <h6 class="fw-bold">Gallery</h6>
                            <div class="col-md-12 text-center">
                                <div class="card mb-3">
                                    <img src="${s3BaseUrl+data.primary_image}" 
                                        class="card-img-top img-fluid" 
                                        style="height:150px; object-fit:cover;">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            ${data.images && data.images.length > 0 
                                ? data.images.map(img => `
                                    <div class="col-md-3 text-center">
                                        <div class="card mb-2">
                                            <img src="${s3BaseUrl+img.image_path}" 
                                                class="card-img-top img-fluid" 
                                                style="height:120px; object-fit:cover;">
                                        </div>
                                    </div>
                                `).join('')
                                : `<p class="text-muted">No images available</p>`
                            }
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <h6 class="fw-bold">Short Description</h6>
                                <p>${data.short_description}</p>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <h6 class="fw-bold">Refund/Cancellation Policy</h6>
                                <p>${data.refund_cancellation_policy}</p>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <h6 class="fw-bold">Rooms</h6>
                            ${data.rooms && data.rooms.length > 0 
                                ? data.rooms.map(room => `
                                    <div class="col-md-12 mb-3">
                                        <h6 class="text-success">${room.title}</h6>
                                        <div class="row">
                                            ${room.images && room.images.length > 0 
                                                ? room.images.map(img => `
                                                    <div class="col-md-3 text-center">
                                                        <div class="card mb-2">
                                                            <img src="${s3BaseUrl+img.image_path}" 
                                                                class="card-img-top img-fluid" 
                                                                style="height:120px; object-fit:cover;">
                                                        </div>
                                                    </div>
                                                `).join('')
                                                : `<p class="text-muted">No images available</p>`
                                            }
                                        </div>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <h6 class="fw-bold">Details</h6>
                                                <p>${room.details}</p>
                                            </div>
                                        </div>
                                        <hr>
                                    </div>
                                `).join('')
                                : `<p class="text-muted">No rooms available</p>`
                            }
                        </div>
                    `;


                    $('#viewHotelModal .modal-body').html(body);

                    // open modal
                    $('#viewHotelModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching hotel details.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $(document).on('click', '.hotel-edit', function() {
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let dataurl = btn.data('url');
            let updateurl = btn.data('udurl');

            $.ajax({
                type: "GET",
                dataType: "json",
                url: dataurl,
                data: { id: id },
                success: function(data) {
                    $('#editHotelForm').attr('action', updateurl);
                    $('#hotel_id').val(data.id);
                    $('#edit_hotel_title').val(data.title);
                    $('#edit_hotel_location').val(data.location);
                    $('#edit_primary_image_alt').val(data.primary_image_alt);
                    tinymce.get('edit_short_description').setContent(data.short_description);
                    tinymce.get('edit_refund_cancellation_policy').setContent(data.refund_cancellation_policy);

                    $('input[name="facilities[]"]').prop('checked', false); // clear first
                    if (data.facilities && Array.isArray(data.facilities)) {
                        data.facilities.forEach(facility => {
                            $(`input[name="facilities[]"][value="${facility}"]`).prop('checked', true);
                        });
                    }
                    if (data.is_top_luxury == 1) {
                        $('#is_top_luxury_edit').prop('checked', true);   // check
                    } else {
                        $('#is_top_luxury_edit').prop('checked', false);  // uncheck
                    }

                    $('#edit_primary_image_preview').attr('src', s3BaseUrl+ data.primary_image);

 
                    $('#galleryPreviewEdit').empty(); // clear old previews
                    if (data.images && Array.isArray(data.images)) {
                        data.images.forEach(image => {
                            let cardId = "img-" + image.id;
                            const galleryImageHtml = `
                            <div class="col-md-3 mb-3 text-center" id="${cardId}">
                                <div class="card">
                                    <img src="${s3BaseUrl+image.image_path}" class="img-fluid rounded-lg shadow-sm mb-2" style="height:150px; object-fit:cover;">
                                    <input type="text" 
                                        name="existing_images_alt[${image.id}]" 
                                        class="form-control"
                                        placeholder="Image Alt"
                                        value="${image.image_alt}">
                                    <button type="button" class="btn btn-sm btn-outline-danger" onclick="deleteImage(${image.id})"><i class="fas fa-trash"></i> Remove</button> 
                                </div>
                            </div>`;
                            $('#galleryPreviewEdit').append(galleryImageHtml);
                        });
                    }

                    $('#editHotelModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Note: The original code used a Swal.fire() which is a SweetAlert2 library function.
                    // If you don't have this library, you would use a standard alert or a custom modal.
                    console.error('An error occurred while fetching hotel details:', textStatus, errorThrown);
                    alert('An error occurred while fetching hotel details.');
                },
                complete: function() {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        document.getElementById('edit_primary_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = input.files[0];
            let preview = document.getElementById('editPrimaryImagePreview');
            // Clear old preview

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && (file.type === 'image/webp' || file.name.toLowerCase().endsWith('.webp'))) {
                dt.items.add(file); // Keep valid file

                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; 
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }

            // Replace with filtered file list (empty if invalid)
            input.files = dt.files;
        });

        $("#galleryInputEdit").on("change", function(e) {
            selectedFiles = Array.from(e.target.files); // store files
            renderPreview(selectedFiles);
        });

        document.getElementById('editHotelForm').addEventListener('submit', function(event) {
            tinymce.triggerSave();
            event.preventDefault(); 
            $('.invalid-feedback').hide();
            $('#edit-submit-btn').prop('disabled',true);
            let isError = 0;
            let short_description = document.getElementById('edit_short_description');
            if(!short_description.value.trim()) {
                isError = 1;
                $('.short-description-error').show();
                $('.short-description-error').text('Short descriptions required');
                
                let $modalBody = $(short_description).closest('.modal-body');
                // scroll modal to the input
                $modalBody.animate({
                    scrollTop: $(short_description).offset().top - $modalBody.offset().top + $modalBody.scrollTop() - 50
                }, 600);
            }

            let refund_cancellation_policy = document.getElementById('edit_refund_cancellation_policy');
            if(!refund_cancellation_policy.value.trim()) {
                isError = 1;
                $('.refund-cancellation-policy-error').show();
                $('.refund-cancellation-policy-error').text('Policy required');
                
                let $modalBody = $(refund_cancellation_policy).closest('.modal-body');
                // scroll modal to the input
                $modalBody.animate({
                    scrollTop: $(refund_cancellation_policy).offset().top - $modalBody.offset().top + $modalBody.scrollTop() - 50
                }, 600);
            }

            if(isError){
                $('#edit-submit-btn').prop('disabled',false);
            } else {
                let form = this;
                let title = document.getElementById('edit_hotel_title').value.trim();
                let id = document.getElementById('hotel_id').value.trim();
                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('admin.hotels.slug.duplicate_check')); ?>",
                    data: {'id':id,'title':title},
                    success: function(res) {
                        if (res.exists) {
                            $('.invalid-feedback').show();
                            $('.title-error').text('This title already exists');
                        } else {
                            $('.invalid-feedback').hide();
                            form.submit();
                        }
                    },
                    error:function(err){
                        //form.submit();
                    }
                });
            }

        });

    });
</script>


<script>
    
    document.addEventListener("DOMContentLoaded", function () {
        let roomIndex = 0;

        function loadRooms(hotel,btn) {
            
            $.ajax({
                url: "<?php echo e(route('admin.hotels.index')); ?>", // adjust route if different
                type: "GET",
                dataType: "json",
                data:{'id':hotel,'rooms':'list'},
                success: function (response) {
                    if (response.status === "success") {
                        let wrapper = $("#room-wrapper");
                        wrapper.empty();
                        roomIndex = 0;

                        if (response.rooms.length > 0) {
                            response.rooms.forEach((room, index) => {
                                addRoomBlock(index, room);
                                roomIndex++;
                            });
                        } else {
                            addRoomBlock(roomIndex);
                            roomIndex++;
                        }

                        $("#addHotelRoomModal").modal("show");
                    }
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                },
                error: function (xhr) {
                    console.error("Error loading todos:", xhr.responseText);
                }
            });
        }

        $(document).on("click", ".update-rooms", function () {
            let url   = $(this).data("url");
            let hotel = $(this).data("id");
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            // load rooms from backend
            loadRooms(hotel,btn);

            // set correct form action
            $('#roomForm').attr('action', url);
        });

        // Add new blank room block
        function addRoomBlock(index, room = null) {
            let html = `
            <div class="room-item border p-3 mb-3 rounded">
                ${room && room.id ? `<input type="hidden" name="rooms[${index}][id]" value="${room.id}">` : ""}
                <div class="d-flex justify-content-end align-items-center mb-2">
                    <button type="button" class="btn btn-danger btn-sm remove-room" data-id="${room && room.id ? room.id : '' }">
                        <i class="fas fa-trash"></i> Remove
                    </button>
                </div>
                <div class="mb-3">
                    <label class="form-label">Title<span class="required-text">*</span></label>
                    <input type="text" class="form-control" name="rooms[${index}][title]" 
                        value="${room ? room.title : ""}" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Details<span class="required-text">*</span></label>
                    <textarea class="form-control" name="rooms[${index}][details]" required> ${room ? room.details : ""}
                    </textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">Gallery Images (accept only .webp)(Select Multiple Image)</label>
                    <input type="file" class="form-control gallery-input" 
                        name="rooms[${index}][images][]" accept=".webp,image/webp" multiple>
                    <div class="row mt-2 gallery" id="gallery-${index}"></div>
                    <div class="row mt-2 gallery-preview" id="gallery-preview-${index}">
                        ${
                            room && room.images
                            ? room.images.map(img => `
                                <div class="col-md-3 mb-2 text-center" id="image-${img.id}">
                                    <img src="${s3BaseUrl+img.image_path}" class="img-fluid rounded border mb-1" style="height:150px; object-fit:cover;">
                                    <button type="button" class="btn btn-sm btn-outline-danger delete-room-image" data-id="${img.id}">
                                        <i class="fas fa-trash"></i> Remove
                                    </button>
                                </div>
                            `).join("")
                            : ""
                        }
                    </div>
                </div>
            </div>
            `;
            $("#room-wrapper").append(html);
        }

        // Add blank room manually
        $("#addMoreRoom").on("click", function () {
            addRoomBlock(roomIndex);
            roomIndex++;
        });

        // Remove room block (only if more than 1)
        $(document).on("click", ".remove-room", function () {
            let roomId = $(this).data("id"); // we set this in the loadCabins() builder
            if (roomId) {
                $("#roomForm").append(`<input type="hidden" name="deleted_rooms[]" value="${roomId}">`);
            }
            $(this).closest(".room-item").remove();
        });

        // Preview newly selected images
        $(document).on("change", ".gallery-input", function () {
            let preview = $(this).closest(".mb-3").find(".gallery-preview");
            //preview.empty();

            let input = this;
            let dt = new DataTransfer(); // helper to rebuild file list

            Array.from(input.files).forEach((file, index) => {
                if (file.type === "image/webp") {
                    dt.items.add(file); // add back all files initially

                    let reader = new FileReader();
                    reader.onload = function (e) {
                        let id = "preview-" + index + "-" + Date.now();
                        preview.append(`
                            <div class="col-md-3 mb-2 text-center" id="${id}">
                                <img src="${e.target.result}" class="img-fluid rounded border mb-1" style="height:150px;">
                                <input type="text" name="images_alt[]"  class="form-control" placeholder="Image Alt Text">
                                <button type="button" class="btn btn-sm btn-outline-danger remove-new-image" data-index="${index}" data-id="${id}">
                                    <i class="fas fa-trash"></i> Remove
                                </button>
                            </div>
                        `);
                    };
                    reader.readAsDataURL(file);
                }
            });

            // replace files with current selection
            input.files = dt.files;
        });

        // remove button for selected (unsaved) images
        $(document).on("click", ".remove-new-image", function () {
            let input = $(this).closest(".mb-3").find(".gallery-input")[0];
            let indexToRemove = $(this).data("index");
            let containerId = $(this).data("id");

            let dt = new DataTransfer();

            Array.from(input.files).forEach((file, index) => {
                if (index !== indexToRemove) {
                    dt.items.add(file); // keep other files
                }
            });

            input.files = dt.files; // reset input
            $("#" + containerId).remove(); // remove preview
        });

        // Delete existing image
        $(document).on("click", ".delete-room-image", function () {
            let imageId = $(this).data("id");
            let container = $("#image-" + imageId);
            $(this).text('removing.....');
            Swal.fire({
                title: "Are you sure?",
                text: "This image will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                customClass: {
                    popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                    confirmButton: 'px-4 py-2 text-white',
                    cancelButton: 'px-4 py-2 text-white'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "<?php echo e(route('admin.hotel.room.image.delete')); ?>",
                        type: "DELETE",
                        data:{'id':imageId},
                        success: function (res) {
                            if (res.status === "success") {
                                container.remove();
                            } else {
                                $(this).text('Remove');
                                toastr.error('Room image not deleted', 'Failed');
                            }
                        },
                        error: function () {
                            alert("Error deleting image.");
                        }
                    });
                }
            });
        });



        let todoIndex = 0;

        function loadTodos(hotel,btn) {
            
            $.ajax({
                url: "<?php echo e(route('admin.hotels.index')); ?>", // adjust route if different
                type: "GET",
                dataType: "json",
                data:{'id':hotel,'todos':'list'},
                success: function (response) {
                    if (response.status === "success") {
                        let wrapper = $("#todo-wrapper");
                        wrapper.empty();
                        todoIndex = 0;

                        if (response.todos.length > 0) {
                            response.todos.forEach((todo, index) => {
                                addTodoBlock(index, todo);
                                todoIndex++;
                            });
                        } else {
                            addTodoBlock(todoIndex);
                            todoIndex++;
                        }

                        $("#addHotelTodoModal").modal("show");
                    }
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                },
                error: function (xhr) {
                    console.error("Error loading todos:", xhr.responseText);
                }
            });
        }

        $(document).on("click", ".update-todos", function () {
            let url   = $(this).data("url");
            let hotel = $(this).data("id");
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            // load todos from backend
            loadTodos(hotel,btn);

            // set correct form action
            $('#todoForm').attr('action', url);
        });

        // Add new blank todo block
        function addTodoBlock(index, todo = null) {
            let html = `
            <div class="todo-item border p-3 mb-3 rounded">
                ${todo && todo.id ? `<input type="hidden" name="todos[${index}][id]" value="${todo.id}">` : ""}
                <div class="d-flex justify-content-end align-items-center mb-2">
                    <button type="button" class="btn btn-danger btn-sm remove-todo" data-id="${todo && todo.id ? todo.id : '' }">
                        <i class="fas fa-trash"></i> Remove
                    </button>
                </div>
                <div class="mb-3">
                    <label class="form-label">Title<span class="required-text">*</span></label>
                    <input type="text" class="form-control" name="todos[${index}][title]" 
                        value="${todo ? todo.title : ""}" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Details<span class="required-text">*</span></label>
                    <textarea class="form-control" name="todos[${index}][details]" required> ${todo ? todo.details : ""}
                    </textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label">Image (accept only .webp)</label>
                    <input type="file" class="form-control gallery-input-todo" 
                        name="todos[${index}][banner_image]" accept=".webp,image/webp">
                    <div class="row mt-2 gallery" id="gallery-${index}"></div>
                    <div class="row mt-2 gallery-preview-todo" id="gallery-preview-${index}">
                        ${
                            todo && todo.banner_image ? `
                                <div class="col-md-12 mb-2" id="image-${todo.id}">
                                    <img src="${s3BaseUrl + todo.banner_image}" class="img-fluid rounded border mb-1" style="height:150px; object-fit:cover;">
                                </div>
                            `: ''
                        }
                    </div>
                </div>
            </div>
            `;
            $("#todo-wrapper").append(html);
        }

        // Add blank room manually
        $("#addMoreTodo").on("click", function () {
            addTodoBlock(todoIndex);
            todoIndex++;
        });

        // Remove room block (only if more than 1)
        $(document).on("click", ".remove-todo", function () {
            let todoId = $(this).data("id"); // we set this in the loadCabins() builder
            if (todoId) {
                $("#todoForm").append(`<input type="hidden" name="deleted_todos[]" value="${todoId}">`);
            }
            $(this).closest(".todo-item").remove();
        });

        // Preview newly selected images
        $(document).on("change", ".gallery-input-todo", function () {
            let preview = $(this).closest(".mb-3").find(".gallery-preview-todo");
            //preview.empty();

            let input = this;
            let dt = new DataTransfer(); // helper to rebuild file list

            Array.from(input.files).forEach((file, index) => {
                if (file.type === "image/webp") {
                    dt.items.add(file); // add back all files initially

                    let reader = new FileReader();
                    reader.onload = function (e) {
                        let id = "preview-" + index + "-" + Date.now();
                        preview.append(`
                            <div class="col-md-12 mb-2 text-center" id="${id}">
                                <img src="${e.target.result}" class="img-fluid rounded border mb-1" style="height:150px;">
                            </div>
                        `);
                    };
                    reader.readAsDataURL(file);
                }
            });

            // replace files with current selection
            input.files = dt.files;
        });
    });

    $(document).on('click', '.page-meta', function() {
        let btn = $(this);
        let id = $(this).data('id');
        let dataUrl = $(this).data('url').trim();
        btn.find('.spinner-border').removeClass('d-none');
        btn.find('.icon').addClass('d-none');
        $.ajax({
            type: "GET",
            dataType: "json",
            url: dataUrl,
            success: function(data) {
                $('#page-title').text('# '+data.title+'-Meta Info');
                if(data.meta != null){
                    $('#page_meta_title').val(data.meta.meta_title);
                    $('#page_meta_description').val(data.meta.meta_description);
                    $('#page_meta_keywords').val(data.meta.meta_keywords);
                    $('#page_h1_heading').val(data.meta.h1_heading);
                    $('#page_meta_details').val(data.meta.meta_details);
                }
                $('#pageMetaModal').modal('show');
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred while fetching city details.'
                });
            },
            complete: function () {
                // Hide loader, show button text back
                btn.find('.spinner-border').addClass('d-none');
                btn.find('.icon').removeClass('d-none');
            }
        });
    });

    $(document).on('click', '.hotel-meta', function() {
        let btn = $(this);
        let id = $(this).data('id');
        let dataUrl = $(this).data('url').trim();
        let dataupUrl = $(this).data('upurl').trim();
        btn.find('.spinner-border').removeClass('d-none');
        btn.find('.icon').addClass('d-none');
        $.ajax({
            type: "GET",
            dataType: "json",
            url: dataUrl,
            success: function(data) {
                $('#hotel-title').text('# '+data.title+'-Meta Info');
                if(data.meta != null){
                    $('#hotel_meta_title').val(data.meta.meta_title);
                    $('#hotel_meta_description').val(data.meta.meta_description);
                    $('#hotel_meta_keywords').val(data.meta.meta_keywords);
                    $('#hotel_h1_heading').val(data.meta.h1_heading);
                    $('#hotel_meta_details').val(data.meta.meta_details);
                }
                $('#hotelMeta').attr('action',dataupUrl);
                $('#hotelMetaModal').modal('show');
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred while fetching hotel details.'
                });
            },
            complete: function () {
                // Hide loader, show button text back
                btn.find('.spinner-border').addClass('d-none');
                btn.find('.icon').removeClass('d-none');
            }
        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/cholantravels/backend/resources/views/admin/settings/hotel.blade.php ENDPATH**/ ?>