<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\ContinentController;
use App\Http\Controllers\Admin\CountryController;
use App\Http\Controllers\Admin\LocationController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\BannerController;
use App\Http\Controllers\Admin\SpecialPackageController;
use App\Http\Controllers\Admin\TourServiceController;
use App\Http\Controllers\Admin\PromotionalAdsController;
use App\Http\Controllers\Admin\DealPackageController;
use App\Http\Controllers\Admin\PageController;
use App\Http\Controllers\Admin\TrainController;
use App\Http\Controllers\Admin\TrainTourController;
use App\Http\Controllers\Admin\HotelController;
use App\Http\Controllers\Admin\ReviewController;
use App\Http\Controllers\Admin\EnquiryController;
use App\Http\Controllers\Admin\CarCategoryController;
use App\Http\Controllers\Admin\CarRouteController;
use App\Http\Controllers\Admin\CarController;


Route::prefix('admin')->name('admin.')->group(function(){

    //Route::middleware(['guest'])->group(function () {
        Route::get('login', [AuthController::class, 'showLogin'])->name('login');
        Route::post('login', [AuthController::class, 'login'])->name('login.post');
    //});
    
    Route::middleware(['auth','isadmin'])->group(function(){
        Route::get('logout', [AuthController::class,'logout'])->name('logout');
        Route::get('logout', [AuthController::class,'logout'])->name('logout');

        Route::get('/', [DashboardController::class,'index'])->name('dashboard');

        Route::get('dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');

        Route::get('master/countries', [CountryController::class, 'masterCountries'])->name('master.countries');

        Route::resource('categories', CategoryController::class);

        Route::get('categories/slug/duplicate_check', [CategoryController::class,'slugDuplicateCheck'])->name('categories.slug.duplicate_check');

        Route::post('continents', [ContinentController::class, 'store'])->name('continents.store');

        Route::resource('countries', CountryController::class);

        Route::put('countries/faq/{country}', [CountryController::class, 'updateFaq'])->name('countries.faqUpdate');

        Route::get('countries-meta/{country}', [CountryController::class, 'showMeta'])->name('countries-meta.show.meta');

        Route::resource('locations', LocationController::class);

        Route::put('locations/faq/{location}', [LocationController::class, 'updateFaq'])->name('locations.faqUpdate');

        Route::get('locations-meta/{location}', [LocationController::class, 'showMeta'])->name('locations-meta.show.meta');

        Route::resource('packages', PackageController::class);

        Route::put('packages/faq/{package}', [PackageController::class, 'updateFaq'])->name('packages.faqUpdate');

        Route::get('packages-meta/{package}', [PackageController::class, 'showMeta'])->name('packages-meta.show.meta');

        Route::get('packages/slug/duplicate_check', [PackageController::class,'slugDuplicateCheck'])->name('packages.slug.duplicate_check');

        Route::delete('packages/images/delete', [PackageController::class,'deleteImage'])->name('packages.images.delete');

        Route::resource('banners', BannerController::class);

        Route::resource('spackages', SpecialPackageController::class);

        Route::resource('tour-services', TourServiceController::class);

        Route::resource('promotional-ads', PromotionalAdsController::class);

        Route::resource('dpackage', DealPackageController::class);

        Route::get('page-meta/{page}', [PageController::class, 'showMeta'])->name('page-meta.show.meta');

        Route::get('page/faq', [PageController::class, 'faqs'])->name('page.faq');

        Route::put('page/faq/{page}', [PageController::class, 'updateFaq'])->name('page.faqUpdate');

        Route::put('page/{page}', [PageController::class, 'update'])->name('page.update');

        Route::get('page-settings/home', [SettingsController::class, 'home'])->name('page-settings.home');

        Route::get('page-settings/international', [SettingsController::class, 'international'])->name('page-settings.international');

        Route::get('page-settings/india', [SettingsController::class, 'india'])->name('page-settings.india');

        Route::get('page-settings/srilanka', [SettingsController::class, 'srilanka'])->name('page-settings.srilanka');

        Route::get('page-settings/customized-holiday', [SettingsController::class, 'customizedHoliday'])->name('page-settings.customized-holiday');


        Route::get('page-settings/luxury-train', [SettingsController::class, 'luxuryTrain'])->name('page-settings.luxury-train');

        Route::resource('trains', TrainController::class);

        Route::get('trains/slug/duplicate_check', [TrainController::class,'slugDuplicateCheck'])->name('trains.slug.duplicate_check');

        Route::get('train-meta/{train}', [TrainController::class, 'showMeta'])->name('train-meta.show.meta');

        Route::put('train/faq/{train}', [TrainController::class, 'updateFaq'])->name('train.faqUpdate');

        Route::delete('train/images/delete', [TrainController::class,'deleteImage'])->name('train.images.delete');

        Route::put('train/cabin/{train}', [TrainController::class, 'updateCabin'])->name('train.cabinUpdate');

        Route::delete('train/cabin/image', [TrainController::class, 'deleteCabinImage'])->name('train.cabin.image.delete');

        Route::resource('train-tours', TrainTourController::class);

        Route::get('train-tours/slug/duplicate_check', [TrainTourController::class,'slugDuplicateCheck'])->name('train-tours.slug.duplicate_check');

        Route::put('train-tours/faq/{trainTour}', [TrainTourController::class, 'updateFaq'])->name('train-tours.faqUpdate');

        Route::get('train-tour-meta/{trainTour}', [TrainTourController::class, 'showMeta'])->name('train-tour-meta.show.meta');

        Route::get('page-settings/luxury-hotel', [SettingsController::class, 'luxuryHotel'])->name('page-settings.luxury-hotel');

        Route::resource('hotels', HotelController::class);

        Route::get('hotels/slug/duplicate_check', [HotelController::class,'slugDuplicateCheck'])->name('hotels.slug.duplicate_check');

        Route::get('hotel-meta/{hotel}', [HotelController::class, 'showMeta'])->name('hotel-meta.show.meta');

        Route::put('hotel/faq/{hotel}', [HotelController::class, 'updateFaq'])->name('hotel.faqUpdate');

        Route::delete('hotel/images/delete', [HotelController::class,'deleteImage'])->name('hotel.images.delete');

        Route::put('hotel/room/{hotel}', [HotelController::class, 'updateRoom'])->name('hotel.roomUpdate');

        Route::delete('hotel/room/image', [HotelController::class, 'deleteRoomImage'])->name('hotel.room.image.delete');

        Route::put('hotel/todo/{hotel}', [HotelController::class, 'updateTodo'])->name('hotel.todoUpdate');

        Route::get('page-settings/car', [SettingsController::class, 'car'])->name('page-settings.car');

        Route::resource('car-categories', CarCategoryController::class);

        Route::get('car-categories/slug/duplicate_check', [CarCategoryController::class,'slugDuplicateCheck'])->name('car-categories.slug.duplicate_check');

        Route::resource('cars', CarController::class);

        Route::get('cars/slug/duplicate_check', [CarController::class,'slugDuplicateCheck'])->name('cars.slug.duplicate_check');

        Route::resource('car-routes', CarRouteController::class);

        Route::get('car-routes/slug/duplicate_check', [CarRouteController::class,'slugDuplicateCheck'])->name('car-routes.slug.duplicate_check');

        Route::get('car-routes/cars/{id}', [CarRouteController::class,'getRouteCars'])->name('car-routes.cars');

        Route::post('car-routes/sync-cars', [CarRouteController::class, 'syncCars'])->name('car-routes.syncCars');

        Route::get('car-routes-meta/{car_route}', [CarRouteController::class, 'showMeta'])->name('car-routes-meta.show.meta');
        Route::get('car-routes-page/{car_route}', [CarRouteController::class, 'showPage'])->name('car-routes-page.show.page');

        Route::get('car/routes/faq', [CarRouteController::class, 'faqs'])->name('car.routes.faq');

        Route::put('car-routes/faq/{car_route}', [CarRouteController::class, 'updateFaq'])->name('car-routes.faqUpdate');

    });
});

Route::prefix('admin/enquiries')->name('admin.enquiries.')->group(function () {
    Route::get('/packages', [EnquiryController::class, 'packages'])->name('packages');
    Route::get('/trains', [EnquiryController::class, 'trains'])->name('trains');
    Route::get('/cars', [EnquiryController::class, 'cars'])->name('cars');
    Route::get('/hotels', [EnquiryController::class, 'hotels'])->name('hotels');
    Route::get('/customized', [EnquiryController::class, 'customized'])->name('customized');
    Route::get('/general', [EnquiryController::class, 'general'])->name('general');
    Route::get('/plan-trip', [EnquiryController::class, 'planTrip'])->name('plan.trip');

    Route::get('/package/{id}', [EnquiryController::class, 'packageDetail'])->name('package.detail');
    Route::get('/train/{id}', [EnquiryController::class, 'trainDetail'])->name('train.detail');
    Route::get('/hotel/{id}', [EnquiryController::class, 'hotelDetail'])->name('hotel.detail');
    Route::get('/car/{id}', [EnquiryController::class, 'carDetail'])->name('car.detail');
    Route::get('/general/{id}', [EnquiryController::class, 'generalDetail'])->name('general.detail');
    Route::get('/plan-trip/{id}', [EnquiryController::class, 'planTripDetail'])->name('plan.trip.detail');

    Route::delete('/package/{id}', [EnquiryController::class, 'deletePackage'])->name('package.delete');
    Route::delete('/train/{id}', [EnquiryController::class, 'deleteTrain'])->name('train.delete');
    Route::delete('/hotel/{id}', [EnquiryController::class, 'deleteHotel'])->name('hotel.delete');
    Route::delete('/car/{id}', [EnquiryController::class, 'carHotel'])->name('car.delete');
    Route::delete('/general/{id}', [EnquiryController::class, 'deleteGeneral'])->name('general.delete');
    Route::delete('/plan-trip/{id}', [EnquiryController::class, 'deletePlanTrip'])->name('plan.trip.delete');

    Route::post('/package/{id}/status', [EnquiryController::class, 'changePackageStatus'])->name('package.status');
    Route::post('/train/{id}/status', [EnquiryController::class, 'changeTrainStatus'])->name('train.status');
    Route::post('/hotel/{id}/status', [EnquiryController::class, 'changeHotelStatus'])->name('hotel.status');
    Route::post('/car/{id}/status', [EnquiryController::class, 'changeCarStatus'])->name('car.status');
    Route::post('/general/{id}/status', [EnquiryController::class, 'changeGeneralStatus'])->name('general.status');
    Route::post('/plan-trip/{id}/status', [EnquiryController::class, 'changePlanTripStatus'])->name('plan.trip.status');
});

Route::prefix('admin/reviews')->name('admin.reviews.')->group(function () {
    Route::get('/packages', [ReviewController::class, 'packages'])->name('packages');
    Route::get('/hotels', [ReviewController::class, 'hotels'])->name('hotels');

    Route::get('/package/{id}', [ReviewController::class, 'packageDetail'])->name('package.detail');
    Route::get('/hotel/{id}', [ReviewController::class, 'hotelDetail'])->name('hotel.detail');

    Route::delete('/package/{id}', [ReviewController::class, 'deletePackage'])->name('package.delete');
    Route::delete('/hotel/{id}', [ReviewController::class, 'deleteHotel'])->name('hotel.delete');

    Route::put('{id}/status', [ReviewController::class, 'changeStatus'])->name('status');
});

Route::fallback(function () {
    abort(404);
});
