@section('title','Luxury Train')
@extends('layouts.app')
@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h2">
                    <i class="fas fa-cog me-2"></i>Luxury Train Page Settings
                </h1>
            </div>
        </div>
    </div>
     <!-- Action Buttons -->
    <div class="row mb-4">
        <div class="col-12">
            <button class="btn btn-warning" onclick="addTrain();">
                <i class="fas fa-plus me-2"></i>Add Luxury Train
            </button>
            <a class="btn btn-success" href="{{ route('admin.train-tours.create') }}">
                <i class="fas fa-plus me-2"></i>Add Luxury Train Tour
            </a>
        </div>
    </div>
    
    <!-- Inquiry Type Tabs -->
    <div class="row mb-3">
        <div class="col-12">
            <ul class="nav nav-pills">
                <li class="nav-item">
                    <a class="nav-link tab_link {{ (session('active_tab') && session('active_tab') == 'train_page') ? 'active' :'' }} {{ !session('active_tab') ? 'active' : ''  }}"  data-tab="train_page_tab">
                        <i class="fas fa-cog me-1"></i>Luxury Train Page Info
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link tab_link {{ (session('active_tab') && session('active_tab') == 'train_list') ? 'active' :'' }}" data-tab="train_list_tab">
                        <i class="fas fa-train me-1"></i>Luxury Trains
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link tab_link {{ (session('active_tab') && session('active_tab') == 'tour_list') ? 'active' :'' }}" data-tab="tour_list_tab">
                        <i class="fas fa-map me-1"></i>Luxury Train Tour 
                    </a>
                </li>
            </ul>
        </div>
    </div>
    
    <div class="row tab_details {{ (session('active_tab') && session('active_tab') != 'train_page') ? 'd-none' :'' }}" id="train_page_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-cog me-2"></i>Page Details
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <strong>{{$page_details->title}}</strong>
                                    </td>
                                    <td>
                                        {!! \Illuminate\Support\Str::words($page_details->description, 10, '...') !!}

                                    </td>
                                    <td>
                                        <div class="card mb-3">
                                            <img id="page-banner-image" src="{{ storage_link($page_details->banner_image) }}" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                        </div>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editPageModal">
                                            <i class="fas fa-edit icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-primary page-faqs" data-id="{{$page_details->id}}"  data-url="{{ route('admin.page.faqUpdate',$page_details->id) }}">
                                            <i class="fa fa-question-circle icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-primary page-meta" data-id="{{$page_details->id}}" data-url="{{ route('admin.page-meta.show.meta',$page_details->id) }}">
                                            <i class="fas fa-globe icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row tab_details {{ (session('active_tab') && session('active_tab') == 'train_list') ? '' :'d-none' }}" id="train_list_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-train me-2"></i>Luxury Trains
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Title</th>
                                    <th>Short Description</th>
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($trains as $train)
                                    <tr>
                                        <td>
                                            <strong class="text-primary d-block">{{ $train->title }}</strong>
                                        </td>
                                        <td>
                                            {!! \Illuminate\Support\Str::words($train->short_description, 10, '...') !!}

                                        </td>
                                        <td>
                                            <div class="card mb-3">
                                                <img id="page-banner-image" src="{{ storage_link($train->primary_image) }}" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                            </div>
                                        </td>
                                        <td>
                                            <input id="status_{{$train->id }}" type="checkbox" data-id="{{$train->id }}" data-url="{{ route('admin.trains.update',$train->id) }}" class="js-switch train-status" <?php echo $train->is_active == 1 ? 'checked' : '' ?>>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-primary train-details" data-id="{{$train->id}}" data-url="{{ route('admin.trains.show',$train->id) }}">
                                                <i class="fas fa-eye icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-success train-edit" data-id="{{$train->id}}" data-url="{{ route('admin.trains.show',$train->id) }}" data-udurl="{{ route('admin.trains.update',$train->id) }}">
                                                <i class="fas fa-edit icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-success update-cabins" data-id="{{$train->id}}" data-url="{{ route('admin.train.cabinUpdate',$train->id) }}" title="Add Cabin">
                                                <!-- <i class="fas fa-train icon"></i> -->
                                                <i class="fas fa-couch"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-primary train-faqs" data-id="{{$train->id}}" data-url="{{ route('admin.train.faqUpdate',$train->id) }}">
                                                <i class="fa fa-question-circle icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-primary train-meta" data-id="{{$train->id}}" data-upurl="{{ route('admin.trains.update',$train->id) }}" data-url="{{ route('admin.train-meta.show.meta',$train->id) }}">
                                            <i class="fa fa-globe icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-danger delete-train" data-id="{{ $train->id }}" data-url="{{ route('admin.trains.destroy',$train->id) }}"><i class="fas fa-trash"></i></button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row tab_details {{ (session('active_tab') && session('active_tab') == 'tour_list') ? '' :'d-none' }}" id="tour_list_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-map me-2"></i>Luxury Train Tour
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Tour</th>
                                    <th>Train</th>
                                    <th>Route</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                
                            @foreach($tours as $tour)
                                <tr>
                                    <td>
                                        <strong class="text-primary d-block">{{ $tour->title }}</strong>
                                        <small class="text-muted">
                                            Duration : {{ $tour->details->duration_days }} Days /
                                            {{ $tour->details->duration_nights }} Nights
                                        </small>
                                    </td>
                                    <td>
                                        {{ $tour->train->title;}}
                                    </td>
                                    <td>
                                        <small class="text-muted">
                                            {{ $tour->details->route_details ?? '' }}
                                        </small>
                                    </td>
                                    <td>
                                        <input id="tour_status_{{$tour->id }}" type="checkbox" data-id="{{$tour->id }}" data-url="{{ route('admin.train-tours.update',$tour->id) }}" class="js-switch tour-status" <?php echo $tour->is_active == 1 ? 'checked' : '' ?>>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary tour-details" data-id="{{$tour->id}}">
                                            <i class="fas fa-eye icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <a href="{{ route('admin.train-tours.edit',$tour->id) }}" class="btn btn-sm btn-outline-success">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button class="btn btn-sm btn-outline-primary tour-faqs" data-id="{{$tour->id}}" data-title="{{$tour->title}}" data-url="{{ route('admin.train-tours.faqUpdate',$tour->id) }}">
                                            <i class="fa fa-question-circle icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-primary train-tour-meta" data-id="{{$tour->id}}" data-upurl="{{ route('admin.train-tours.update',$tour->id) }}" data-url="{{ route('admin.train-tour-meta.show.meta',$tour->id) }}">
                                            <i class="fa fa-globe icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                        <button class="btn btn-sm btn-outline-danger delete-tour" data-id="{{ $tour->id }}" data-url="{{ route('admin.train-tours.destroy',$tour->id) }}"><i class="fas fa-trash"></i></button>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    @include('admin.common.pagination', ['paginator' => $tours])
                </div>
            </div>
        </div>
    </div>

</div>
@endsection
@section('modal')

<div class="modal fade" id="editPageModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-pencil me-2"></i>Edit Luxury Train Page
                </h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="editPage" method="POST" action="{{ route('admin.page.update',$page_details->id) }}" enctype="multipart/form-data">
                @csrf 
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_page_title" class="form-label">Title</label>
                        <input type="text" class="form-control" id="edit_page_title" name="title" value="{{ old('title',$page_details->title) }}" required>
                    </div>
                    <div class="row" id="praimaryPreview">
                        <div class="col-md-12">
                            <div class="card mb-3">
                                <img id="edit-banner-image" src="{{ storage_link($page_details->banner_image) }}" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <input type="text" class="form-control mb-2" id="edit_banner_image_alt" name="banner_image_alt" required placeholder="Banner Image Alt Text" value="{{ old('banner_image_alt',$page_details->banner_image_alt) }}">
                        <label for="edit_banner_image" class="form-label">Image</label>
                        <input type="file" class="form-control" id="edit_banner_image" name="banner_image" accept=".webp,image/webp" {{!$page_details->banner_image ? 'required' : ''}}>
                        <div class="text-danger d-none" id="edit-banner-image-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control tinymce" 
                        id="description" name="description" rows="5">
                            {{ old('description',$page_details->description) }}
                        </textarea>
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="submit-btn">
                        <i class="fas fa-save me-2"></i>Update Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="faqModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="city-title">Faqs</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="faqForm" method="POST" action="" enctype="multipart/form-data">
            @csrf 
            @method('PUT')
                <div class="modal-body"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-page-setting-btn" data-url="">
                        <i class="fas fa-save me-2"></i>Save Faqs
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="addTrainModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i>Add New Luxury Train
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="addTrainForm" method="POST" action="{{ route('admin.trains.store') }}" enctype="multipart/form-data">
                @csrf 
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="add_train_title" class="form-label">Title<span class="required-text">*</span></label>
                        <input type="text" class="form-control" id="add_train_title" name="title" required>
                        <div class="invalid-feedback title-error"></div>
                    </div>
                    <div class="row mb-3" id="addPrimaryImagePreview"></div>
                    <div class="mb-3">
                        <label for="add_primary_image" class="form-label">Primary Image<span class="required-text">*</span> (accept only .webp)</label>
                        <input type="file" class="form-control mb-2" id="add_primary_image" name="primary_image" accept=".webp,image/webp" required>
                        <div class="invalid-feedback primary-image-error"></div>
                        <input type="text"  class="form-control"  id="add_primary_image_alt" name="primary_image_alt" 
                        value="" required placeholder="Primary Image Alt Text" >
                    </div>
                    <div class="row" id="galleryPreview"></div>
                    <!-- <div class="mb-3">
                        <label for="add_primary_image" class="form-label">Gallery Images<span class="required-text">*</span>(accept only .webp)(Select Multiple Image)</label>
                        <input type="file" name="images[]" accept=".webp,image/webp" id="galleryInput" multiple class="form-control">
                    </div> -->
                    <div class="mb-3">
                        <label for="add_short_description" class="form-label">Short Description<span class="required-text">*</span></label>
                        <textarea class="form-control tinymce" id="add_short_description" name="short_description" rows="3" ></textarea>
                        <div class="invalid-feedback short-description-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="add_long_description" class="form-label">About The Train<span class="required-text">*</span></label>
                        <textarea class="form-control tinymce" id="add_long_description" name="long_description" rows="5" ></textarea>
                        <div class="invalid-feedback long-description-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="add_destinations" class="form-label">Destinations<span class="required-text">*</span></label>
                        <textarea class="form-control tinymce" id="add_destinations" name="destinations" rows="3" ></textarea>
                        <div class="invalid-feedback destinations-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="add_facilities" class="form-label">Facilities<span class="required-text">*</span></label>
                        <textarea class="form-control tinymce" id="add_facilities" name="facilities" rows="3" ></textarea>
                        <div class="invalid-feedback facilities-error"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success rounded-md" id="add-submit-btn">
                        <i class="fas fa-plus me-2"></i>Add Train
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="editTrainModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-pencil me-2"></i>Edit Luxury Train
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <input type="hidden" id="train_id" name="id">
            <form id="editTrainForm" method="POST"  enctype="multipart/form-data">
                @csrf 
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_train_title" class="form-label">Title<span class="required-text">*</span></label>
                        <input type="text" class="form-control" id="edit_train_title" name="title" required>
                        <div class="invalid-feedback title-error"></div>
                    </div>
                    <div class="row mb-3" id="editPrimaryImagePreview">
                        <div class="col-md-12 text-center">
                            <div class="card mb-3">
                                <img src="" id="edit_primary_image_preview" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <input type="text"  class="form-control mb-2"  id="edit_primary_image_alt" name="primary_image_alt" 
                        value="" required placeholder="Primary Image Alt Text" >
                        <label for="edit_primary_image" class="form-label">Primary Image</label>
                        <input type="file" class="form-control" id="edit_primary_image" name="primary_image" accept=".webp,image/webp" >
                        <div class="invalid-feedback primary-image-error"></div>
                    </div>
                    <div class="row" id="galleryPreviewEdit"></div>
                    <!-- <div class="mb-3">
                        <label for="edit_images" class="form-label">Gallery Images(Allow Multiple Image)</label>
                        <input type="file" name="images[]" accept=".webp,image/webp" id="galleryInput" multiple class="form-control" >
                    </div> -->
                    <div class="mb-3">
                        <label for="edit_short_description" class="form-label">Short Description<span class="required-text">*</span></label>
                        <textarea class="form-control tinymce" id="edit_short_description" name="short_description" rows="3" ></textarea>
                        <div class="invalid-feedback short-description-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_long_description" class="form-label">About The Train<span class="required-text">*</span></label>
                        <textarea class="form-control tinymce" id="edit_long_description" name="long_description" rows="5" ></textarea>
                        <div class="invalid-feedback long-description-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_destinations" class="form-label">Destinations<span class="required-text">*</span></label>
                        <textarea class="form-control tinymce" id="edit_destinations" name="destinations" rows="3" ></textarea>
                        <div class="invalid-feedback destinations-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_facilities" class="form-label">Facilities<span class="required-text">*</span></label>
                        <textarea class="form-control tinymce" id="edit_facilities" name="facilities" rows="3" ></textarea>
                        <div class="invalid-feedback facilities-error"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning rounded-md" id="edit-submit-btn">
                        <i class="fas fa-save me-2"></i>Update Train
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="viewTrainModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body"></div>
        </div>
    </div>
</div>

<div class="modal fade" id="viewTourModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Title:</strong></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Train:</strong></p>
                        
                    </div>
                    <div class="col-md-12">
                        <p><strong>Tour Highlights:</strong></p>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="fw-bold">Description</h6>
                        <p></p>
                    </div>
                    <div class="col-md-6">
                        <h6 class="fw-bold">Refund Cancellation Policy</h6>
                        <p></p>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <h6 class="fw-bold">Gallery</h6>
                    <div class="col-md-3 text-center">
                        <div class="card mb-3">
                            <img src="" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <h6 class="fw-bold">Itinerary</h6>
                    <div class="mb-2">
                        <strong></strong>
                        <p class="text-muted mb-1"></p>
                    </div>
                </div>
                <hr>
                <div class="row">
                    <div class="col-md-6">
                        <h6 class="fw-bold">Inclusions</h6>
                        <p></p>
                    </div>
                    <div class="col-md-6">
                        <h6 class="fw-bold">Exclusions</h6>
                        <p></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="addCabinModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i>Add New Cabin
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>

            <form id="cabinForm" method="POST" enctype="multipart/form-data">
                @csrf 
                @method('PUT')

                <div class="modal-body">
                    <div id="cabin-wrapper"></div>

                </div>

                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-outline-success" id="addMoreCabin">
                        <i class="fas fa-plus"></i> Add Another Cabin
                    </button>
                    <div>
                        <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-warning rounded-md" id="add-cabin-submit-btn">
                            <i class="fas fa-save me-2"></i>Save Cabins
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="pageMetaModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="page-title">Edit Meta Info</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="pageMeta" method="POST" action="{{ route('admin.page.update',$page_details->id) }}" enctype="multipart/form-data">
            @csrf 
            @method('PUT')
                <div class="modal-body">
                    <input type="hidden" name="meta_setting">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_title" class="form-label">Meta Title<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_title" name="meta_title" required>
                                <div class="text-danger d-none" id="page-meta-title-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_description" class="form-label">Meta Description<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_description" name="meta_description" required>
                                <div class="text-danger d-none" id="page-meta-description-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_keywords" class="form-label">Meta Keywords<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_keywords" name="meta_keywords" required>
                                <div class="text-danger d-none" id="page-meta-keyords-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_h1_heading" class="form-label">H1 Heading<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_h1_heading" name="h1_heading" required>
                                <div class="text-danger d-none" id="page-meta-keyords-error"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-3">
                            <label for="page_meta_details" class="form-label">Extra Meta Tag<span class="required-text">*</span></label>
                            <textarea class="form-control"  name="meta_details" id="page_meta_details" rows="5" id="meta_details"></textarea>
                            <div class="text-danger d-none" id="page-meta-details-error"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-page-meta-btn">
                        <i class="fas fa-save me-2"></i>Update Meta Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="trainMetaModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="train-title">Edit Meta Info</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="trainMeta" method="POST" action="" enctype="multipart/form-data">
            @csrf 
            @method('PUT')
                <div class="modal-body">
                    <input type="hidden" name="meta_setting">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="train_meta_title" class="form-label">Meta Title<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="train_meta_title" name="meta_title" required>
                                <div class="text-danger d-none" id="train-meta-title-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="train_meta_description" class="form-label">Meta Description<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="train_meta_description" name="meta_description" required>
                                <div class="text-danger d-none" id="train-meta-description-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="train_meta_keywords" class="form-label">Meta Keywords<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="train_meta_keywords" name="meta_keywords" required>
                                <div class="text-danger d-none" id="train-meta-keyords-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="train_h1_heading" class="form-label">H1 Heading<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="train_h1_heading" name="h1_heading" required>
                                <div class="text-danger d-none" id="train-meta-keyords-error"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-3">
                            <label for="train_meta_details" class="form-label">Extra Meta Tag<span class="required-text">*</span></label>
                            <textarea class="form-control"  name="meta_details" id="train_meta_details" rows="5" id="meta_details"></textarea>
                            <div class="text-danger d-none" id="train-meta-details-error"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-train-meta-btn">
                        <i class="fas fa-save me-2"></i>Update Meta Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="trainTourMetaModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="train-title">Edit Meta Info</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="trainTourMeta" method="POST" action="" enctype="multipart/form-data">
            @csrf 
            @method('PUT')
                <div class="modal-body">
                    <input type="hidden" name="meta_setting">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="train__tour_meta_title" class="form-label">Meta Title<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="train_tour_meta_title" name="meta_title" required>
                                <div class="text-danger d-none" id="train-tour-meta-title-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="train_tour_meta_description" class="form-label">Meta Description<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="train_tour_meta_description" name="meta_description" required>
                                <div class="text-danger d-none" id="train-tour-meta-description-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="train_tour_meta_keywords" class="form-label">Meta Keywords<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="train_tour_meta_keywords" name="meta_keywords" required>
                                <div class="text-danger d-none" id="train-tour-meta-keyords-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="train_tour_h1_heading" class="form-label">H1 Heading<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="train_tour_h1_heading" name="h1_heading" required>
                                <div class="text-danger d-none" id="train-tour-meta-keyords-error"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-3">
                            <label for="train_tour_meta_details" class="form-label">Extra Meta Tag<span class="required-text">*</span></label>
                            <textarea class="form-control"  name="meta_details" id="train_tour_meta_details" rows="5" id="meta_details"></textarea>
                            <div class="text-danger d-none" id="train-tour-meta-details-error"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-train-meta-btn">
                        <i class="fas fa-save me-2"></i>Update Meta Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
    let faqIndex = 0;
    let selectedFiles = [];
    let imageCounter = 0;

    function activeTab(ele){
        // Remove active from all nav links
        let nav = document.querySelectorAll('.tab_link');
        nav.forEach(function(element) {
            element.classList.remove('active');
            if (element.getAttribute('data-tab') === ele) {
                element.classList.add('active');
            }
        });

        // Hide all tabs
        let tab = document.querySelectorAll('.tab_details');
        tab.forEach(function(element) {
            element.classList.add('d-none');
        });

        let selectTab = document.getElementById(ele);
        if (selectTab) {
            selectTab.classList.remove('d-none');
        }
    }

    function addTrain() {
        activeTab('train_list_tab');
        let oldInput = document.querySelector('.static-input');
        if (oldInput) {
            oldInput.remove();
        }
        let dealModal = new bootstrap.Modal(document.getElementById('addTrainModal'));
        dealModal.show();
    }

    function deleteImage(imageId){
        Swal.fire({
            title: "Are you sure?",
            text: "This image will be deleted!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#e3342f",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it",
            cancelButtonText: "Cancel",
            customClass: {
                popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                confirmButton: 'px-4 py-2 text-white',
                cancelButton: 'px-4 py-2 text-white'
            }
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('admin.train.images.delete') }}", // create this route
                    type: 'DELETE',
                    data: {
                        id: imageId
                    },
                    success: function(res){
                        if(res.success){
                            $('#img-' + imageId).remove();
                        } else {
                            toastr.error('Train image not deleted', 'Failed');
                        }
                    }
                });
            }
        });
    }

    function renderPreview(emptyGallery=false) {
        if(emptyGallery) $(".new-uplod").remove();
        let dt = new DataTransfer(true);

        selectedFiles.forEach((file, index) => {
            if (file && (file.type === 'image/webp')) {
                let reader = new FileReader();
                reader.onload = function(e) {
                    let cardId = "preview-card-" + index;
                    let col = `
                        <div class="col-md-3 mb-3 new-uplod" id="${cardId}">
                            <div class="card">
                                <img src="${e.target.result}" class="card-img-top img-fluid" 
                                    style="height:150px; object-fit:cover;">
                                <div class="card-body p-2">
                                    <button type="button" class="btn btn-sm btn-danger" onclick="removeImage(${index})">Delete</button> 
                                </div>
                            </div>
                        </div>`;
                    $("#galleryPreviewEdit").append(col);
                };
                reader.readAsDataURL(file);
            }
            dt.items.add(file); // rebuild FileList
        });

        // update the input with new FileList
        document.getElementById("galleryInputEdit").files = dt.files;
    }

    function removeImage(index) {
        selectedFiles.splice(index, 1); // remove file from array
        renderPreview(true); // re-render & rebuild FileList
    }


    $(document).ready(function () {
        @if(session('success'))
            toastr.success("{{ session('success') }} ", 'Success');
        @endif

        $(document).on('click', '.tab_link', function() {
            $('.tab_link').removeClass('active');
            $(this).addClass('active');
            $('.tab_details').addClass('d-none');
            let ele = $(this).data('tab');
            $('#'+ele).removeClass('d-none');
        });


        document.getElementById('editPage').addEventListener('submit', function(event) {
            tinymce.triggerSave();
            event.preventDefault(); 
            $('.invalid-feedback').addClass('d-none');
            $('#submit-btn').prop('disabled',true);
            let isError = 0;
            let description = document.getElementById('description');
            if(!description.value.trim()) {
                $('.invalid-feedback').removeClass('d-none');
                $('.invalid-feedback').addClass('d-block');
                $('.invalid-feedback').text('Descriptions required');
                $('#submit-btn').prop('disabled',false);
            } else {
                this.submit();
            }

        });

        
    
        /* ==== Primary Image Preview ==== */
        document.getElementById('edit_banner_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = event.target.files[0];
            let preview = document.getElementById('praimaryPreview');
            

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && (file.type === 'image/webp')) {
                dt.items.add(file); // Keep valid file
                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; // Clear old preview
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }
            input.files = dt.files;
        });

        $(document).on('click', '.page-faqs', function() {
            faqIndex = 0;
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let dataUrl = btn.data('url');
            
            $('#faqForm').attr('action',dataUrl);
            $.ajax({
                type: "GET",
                dataType: "json",
                url: "{{ route('admin.page.faq') }}", // better to point this to a dedicated faq route
                data: { id: id },
                success: function(data) {
                    let faqs = data.faqs || [];
                    let body = `
                    <table class="table" id="faqTable">
                        <thead>
                            <tr>
                                <th>Question</th>
                                <th>Answer</th>
                                <th><button type="button" class="btn btn-sm btn-outline-success" id="addFaqRow"><i class="fas fa-plus"></button></th>
                            </tr>
                        </thead>
                        <tbody>
                    `;

                    if (faqs.length > 0) {
                        $.each(faqs, function(index, faq) {
                            body += `
                                <tr class="b-none">
                                    <td><input type="text" name="faqs[${faqIndex}][question]" value="${faq.question}" class="form-control" required /></td>
                                    <td><textarea name="faqs[${faqIndex}][answer]" class="form-control">${faq.answer ?? ''}</textarea></td>
                                    <td><button type="button" class="btn btn-sm btn-outline-danger removeFaqRow"><i class="fas fa-trash"></button></td>
                                </tr>
                            `;
                            faqIndex++;
                        });
                    } else {
                        body += `
                            <tr class="b-none">
                                <td><input type="text" name="faqs[${faqIndex}][question]" class="form-control" required/></td>
                                <td><textarea name="faqs[${faqIndex}][answer]" class="form-control"></textarea></td>
                                <td></td>
                            </tr>
                        `;
                        faqIndex++;
                    }

                    body += `</tbody></table>`;

                    $('#faqModal .modal-body').html(body);

                    // open modal
                    $('#faqModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching train FAQs.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $(document).on('click', '#addFaqRow', function() {
            let row = `
                <tr class="b-none">
                    <td><input type="text" name="faqs[${faqIndex}][question]" class="form-control" required /></td>
                    <td><textarea name="faqs[${faqIndex}][answer]" class="form-control"></textarea></td>
                    <td><button type="button" class="btn btn-sm btn-outline-danger removeFaqRow"><i class="fas fa-trash"></button></td>
                </tr>`;
            faqIndex++;
            $('#faqTable tbody').append(row);
            
        });

        $(document).on('click', '.removeFaqRow', function() {
            $(this).closest('tr').remove();
        });

        // document.getElementById('add_primary_image').addEventListener('change', function(event) {
        //     let file = event.target.files[0];
        //     let preview = document.getElementById('addPrimaryImagePreview');
        //     preview.innerHTML = ""; // Clear old preview

        //     if (file && file.type.startsWith('image/')) {
        //         let reader = new FileReader();
        //         reader.onload = function(e) {
        //             let col = document.createElement('div');
        //             col.classList.add('col-md-12', 'mb-3');
        //             col.innerHTML = `
        //                 <div class="card">
        //                     <img src="${e.target.result}" class="card-img-top img-fluid" 
        //                         style="height:150px; object-fit:cover;">
        //                 </div>
        //             `;
        //             preview.appendChild(col);
        //         };
        //         reader.readAsDataURL(file);
        //     }
        // });

        document.getElementById('add_primary_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = input.files[0];
            let preview = document.getElementById('addPrimaryImagePreview');
            let dt = new DataTransfer(); // For rebuilding file list

            if (file && (file.type === 'image/webp')) {
                dt.items.add(file); // Keep valid file

                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; // Clear old preview
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }

            // Replace with filtered file list (empty if invalid)
            input.files = dt.files;
        });

        // document.getElementById('galleryInput').addEventListener('change', function(event) {
        //     let files = event.target.files;
        //     let preview = document.getElementById('galleryPreview');
        //     preview.innerHTML = ""; // Clear old previews

        //     Array.from(files).forEach(file => {
        //         if (file.type.startsWith('image/')) {
        //             let reader = new FileReader();
        //             reader.onload = function(e) {
        //                 let col = document.createElement('div');
        //                 col.classList.add('col-md-3', 'mb-3');
        //                 col.innerHTML = `
        //                     <div class="card">
        //                         <img src="${e.target.result}" class="card-img-top img-fluid" 
        //                             style="height:150px; object-fit:cover;">
        //                     </div>
        //                 `;
        //                 preview.appendChild(col);
        //             };
        //             reader.readAsDataURL(file);
        //         }
        //     });
        // });

        document.getElementById('addTrainForm').addEventListener('submit', function(event) {
            tinymce.triggerSave();
            event.preventDefault(); 
            $('.invalid-feedback').hide();
            $('#add-submit-btn').prop('disabled',true);
            let isError = 0;
            let short_description = document.getElementById('add_short_description');
            if(!short_description.value.trim()) {
                isError = 1;
                $('.short-description-error').show();
                $('.short-description-error').text('Short descriptions required');
                // $('html, body').animate({
                //     scrollTop: short_description.offset().top - 100   // adjust -100 for some spacing from top
                // }, 600);
            }

            let long_description = document.getElementById('add_long_description');
            if(!long_description.value.trim()) {
                isError = 1;
                $('.long-description-error').show();
                $('.long-description-error').text('About the train required');
                // $('html, body').animate({
                //     scrollTop: $("#add-long-description").offset().top - 100   // adjust -100 for some spacing from top
                // }, 600);
            }

            let destinations = document.getElementById('add_destinations');
            if(!destinations.value.trim()) {
                isError = 1;
                $('.destinations-error').show();
                $('.destinations-error').text('Destinations required');
                // $('html, body').animate({
                //     scrollTop: $("#add-destinations").offset().top - 100   // adjust -100 for some spacing from top
                // }, 600);
            }

            let facilities = document.getElementById('add_facilities');
            if(!facilities.value.trim()) {
                isError = 1;
                $('.facilities-error').show();
                $('.facilities-error').text('Facilities required');
                // $('html, body').animate({
                //     scrollTop: $("#add-facilities").offset().top - 100   // adjust -100 for some spacing from top
                // }, 600);
            }

            if(isError){
                $('#add-submit-btn').prop('disabled',false);
            } else {
                let form = this;
                let title = document.getElementById('add_train_title').value.trim();
                $.ajax({
                    type: "GET",
                    url: "{{ route('admin.trains.slug.duplicate_check') }}",
                    data: {'title':title},
                    success: function(res) {
                        if (res.exists) {
                            $('.title-errorr').show();
                            $('.title-error').text('This title already exists');
                        } else {
                            $('.title-errorr').hide();
                            form.submit();
                        }
                    },
                    error:function(err){
                        form.submit();
                    }
                });
            }

        });

        $(document).on('change', '.train-status', function() {
            let train_status = $(this).prop('checked') === true ? 1 : 0;
            $.ajax({
                type: "PUT",
                dataType: "json",
                url: $(this).data('url'),
                data: {
                    'status': train_status
                },
                success: function(data) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: data.message
                    });
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while processing your request.'
                    });
                }

            });
        });

        $(document).on('click', '.train-faqs', function() {
            faqIndex = 0;
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let title = btn.data('title');
            let dataUrl = btn.data('url');
            
            $('#faqForm').attr('action',dataUrl);
            $.ajax({
                type: "GET",
                dataType: "json",
                url: "{{ route('admin.trains.index') }}", // better to point this to a dedicated faq route
                data: { id: id, faqs: 'list' },
                success: function(data) {
                    let faqs = data.faqs || [];
                    $('#faqModal .modal-title').text(title);

                    let body = `
                    <table class="table" id="faqTable">
                        <thead>
                            <tr>
                                <th>Question</th>
                                <th>Answer</th>
                                <th><button type="button" class="btn btn-sm btn-outline-success" id="addFaqRow"><i class="fas fa-plus"></button></th>
                            </tr>
                        </thead>
                        <tbody>
                    `;

                    if (faqs.length > 0) {
                        $.each(faqs, function(index, faq) {
                            body += `
                                <tr class="b-none">
                                    <td><input type="text" name="faqs[${faqIndex}][question]" value="${faq.question}" class="form-control" required /></td>
                                    <td><textarea name="faqs[${faqIndex}][answer]" class="form-control">${faq.answer ?? ''}</textarea></td>
                                    <td><button type="button" class="btn btn-sm btn-outline-danger removeFaqRow"><i class="fas fa-trash"></button></td>
                                </tr>
                            `;
                            faqIndex++;
                        });
                    } else {
                        body += `
                            <tr class="b-none">
                                <td><input type="text" name="faqs[${faqIndex}][question]" class="form-control" required/></td>
                                <td><textarea name="faqs[${faqIndex}][answer]" class="form-control"></textarea></td>
                                <td></td>
                            </tr>
                        `;
                        faqIndex++;
                    }

                    body += `</tbody></table>`;

                    $('#faqModal .modal-body').html(body);

                    // open modal
                    $('#faqModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching train FAQs.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $(document).on("click", ".delete-train", function(e) {
            e.preventDefault();
            let itemId = $(this).data("id");
            let itemUrl = $(this).data("url");
            let row = $(this).closest("tr"); // parent <tr>
            Swal.fire({
                title: "Are you sure?",
                text: "This item will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                customClass: {
                    popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                    confirmButton: 'px-4 py-2 text-white',
                    cancelButton: 'px-4 py-2 text-white'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: itemUrl,
                        success: function(res) {
                            if(res.success){
                                row.remove();
                                Swal.fire(
                                    "Deleted!",
                                    "The item has been deleted successfully.",
                                    "success"
                                );
                            }
                        },
                        error: function(xhr) {
                            toastr.error('Train not deleted!', 'Failed');
                        }
                    });
                    
                }
            });
        });

        $(document).on('click', '.train-details', function() {
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let dataurl = btn.data('url');
            $.ajax({
                type: "GET",
                dataType: "json",
                url: dataurl,
                data: { id: id },
                success: function(data) {
                    $('#viewTrainModal .modal-title').text(data.title);

                    let body = `
                        <div class="row">
                            <div class="col-md-12">
                                <p><strong>Title:</strong> ${data.title}</p>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <h6 class="fw-bold">Short Description</h6>
                                <p>${data.short_description}</p>
                            </div>
                            <div class="col-md-12">
                                <h6 class="fw-bold">Long Description</h6>
                                <p>${data.long_description}</p>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <h6 class="fw-bold">Gallery</h6>
                            <div class="col-md-12 text-center">
                                <div class="card mb-3">
                                    <img src="${s3BaseUrl+data.primary_image}" 
                                        class="card-img-top img-fluid" 
                                        style="height:150px; object-fit:cover;">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <h6 class="fw-bold">Destinations</h6>
                                <p>${data.destinations}</p>
                            </div>
                            <div class="col-md-12">
                                <h6 class="fw-bold">Facilities</h6>
                                <p>${data.facilities}</p>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <h6 class="fw-bold">Cabins</h6>
                            ${data.cabins && data.cabins.length > 0 
                                ? data.cabins.map(cabin => `
                                    <div class="col-md-12 mb-3">
                                        <h6 class="text-success">${cabin.title}</h6>
                                        <div class="row">
                                            ${cabin.images && cabin.images.length > 0 
                                                ? cabin.images.map(img => `
                                                    <div class="col-md-3 text-center">
                                                        <div class="card mb-2">
                                                            <img src="${s3BaseUrl+img.image_path}" 
                                                                class="card-img-top img-fluid" 
                                                                style="height:120px; object-fit:cover;">
                                                        </div>
                                                    </div>
                                                `).join('')
                                                : `<p class="text-muted">No images available</p>`
                                            }
                                        </div>
                                    </div>
                                `).join('')
                                : `<p class="text-muted">No cabins available</p>`
                            }
                        </div>
                    `;


                    $('#viewTrainModal .modal-body').html(body);

                    // open modal
                    $('#viewTrainModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching train details.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $(document).on('click', '.train-edit', function() {
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let dataurl = btn.data('url');
            let updateurl = btn.data('udurl');

            $.ajax({
                type: "GET",
                dataType: "json",
                url: dataurl,
                data: { id: id },
                success: function(data) {
                    $('#editTrainForm').attr('action', updateurl);
                    $('#train_id').val(data.id);
                    $('#edit_train_title').val(data.title);
                    $('#edit_primary_image_alt').val(data.primary_image_alt);
                    tinymce.get('edit_short_description').setContent(data.short_description);
                    tinymce.get('edit_long_description').setContent(data.long_description);
                    tinymce.get('edit_destinations').setContent(data.destinations);
                    tinymce.get('edit_facilities').setContent(data.facilities);
                    $('#edit_primary_image_preview').attr('src',s3BaseUrl+data.primary_image);
                    // Display gallery images preview
                    // if (data.images && Array.isArray(data.images)) {
                    //     data.images.forEach(image => {
                    //         const galleryImageHtml = `<div class="col-3 mb-3">
                    //             <img src="${s3BaseUrl+image.image_path}" alt="Gallery Image" class="img-fluid rounded-lg shadow-sm">
                    //         </div>`;
                    //         $('#galleryPreviewEdit').append(galleryImageHtml);
                    //     });
                    // }
                    $('#editTrainModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Note: The original code used a Swal.fire() which is a SweetAlert2 library function.
                    // If you don't have this library, you would use a standard alert or a custom modal.
                    console.error('An error occurred while fetching train details:', textStatus, errorThrown);
                    alert('An error occurred while fetching train details.');
                },
                complete: function() {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });


        document.getElementById('edit_primary_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = input.files[0];
            let preview = document.getElementById('editPrimaryImagePreview');
        
            let dt = new DataTransfer(); // For rebuilding file list

            if (file && (file.type === 'image/webp')) {
                dt.items.add(file); // Keep valid file

                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; // Clear old preview
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }

            // Replace with filtered file list (empty if invalid)
            input.files = dt.files;
        });

        document.getElementById('editTrainForm').addEventListener('submit', function(event) {
            tinymce.triggerSave();
            event.preventDefault(); 
            $('.invalid-feedback').hide();
            $('#edit-submit-btn').prop('disabled',true);
            let isError = 0;
            let short_description = document.getElementById('edit_short_description');
            if(!short_description.value.trim()) {
                isError = 1;
                $('.short-description-error').show();
                $('.short-description-error').text('Short descriptions required');
                
                let $modalBody = $(short_description).closest('.modal-body');
                // scroll modal to the input
                $modalBody.animate({
                    scrollTop: $(short_description).offset().top - $modalBody.offset().top + $modalBody.scrollTop() - 50
                }, 600);
            }

            let long_description = document.getElementById('edit_long_description');
            if(!long_description.value.trim()) {
                isError = 1;
                $('.long-description-error').show();
                $('.long-description-error').text('About the train required');
                // $('html, body').animate({
                //     scrollTop: $("#add-long-description").offset().top - 100   // adjust -100 for some spacing from top
                // }, 600);
            }

            let destinations = document.getElementById('edit_destinations');
            if(!destinations.value.trim()) {
                isError = 1;
                $('.destinations-error').show();
                $('.destinations-error').text('Destinations required');
                // $('html, body').animate({
                //     scrollTop: $("#add-destinations").offset().top - 100   // adjust -100 for some spacing from top
                // }, 600);
            }

            let facilities = document.getElementById('edit_facilities');
            if(!facilities.value.trim()) {
                isError = 1;
                $('.facilities-error').show();
                $('.facilities-error').text('Facilities required');
                // $('html, body').animate({
                //     scrollTop: $("#add-facilities").offset().top - 100   // adjust -100 for some spacing from top
                // }, 600);
            }

            if(isError){
                $('#edit-submit-btn').prop('disabled',false);
            } else {
                let form = this;
                let title = document.getElementById('edit_train_title').value.trim();
                let id = document.getElementById('train_id').value.trim();
                $.ajax({
                    type: "GET",
                    url: "{{ route('admin.trains.slug.duplicate_check') }}",
                    data: {'id':id,'title':title},
                    success: function(res) {
                        if (res.exists) {
                            $('.title-errorr').show();
                            $('.title-error').text('This title already exists');
                        } else {
                            $('.title-errorr').hide();
                            form.submit();
                        }
                    },
                    error:function(err){
                        //form.submit();
                    }
                });
            }

        });

        $(document).on('click', '.tour-details', function() {
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            $.ajax({
                type: "GET",
                dataType: "json",
                url: "{{ route('admin.train-tours.index') }}",
                data: { id: id },
                success: function(data) {
                    data = data.tour;
                    $('#viewTourModal .modal-title').text(data.title);

                    let body = `
                        <div class="row">
                            <div class="col-md-12">
                                <p><strong>Train:</strong> ${data.train.title}</p>
                            </div>
                            <div class="col-md-12">
                                <p><strong>Facilities:</strong> ${
                                    Array.isArray(data.details.facilities)
                                        ? data.details.facilities
                                            .map(f => f.replace(/\b\w/g, c => c.toUpperCase())) // Title Case each word
                                            .join(', ')
                                        : (typeof data.details.facilities === "string"
                                            ? data.details.facilities.replace(/\b\w/g, c => c.toUpperCase())
                                            : '')
                                }</p>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <h6 class="fw-bold">Gallery</h6>
                            <div class="col-md-12 text-center">
                                <div class="card mb-3">
                                    <img src="${s3BaseUrl+data.primary_image}" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <h6 class="fw-bold">Description: </h6>
                                <p>${data.description}</p>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <h6 class="fw-bold">Refund Cancellation Policy: </h6>
                                <p>${data.refund_cancellation_policy}</p>
                            </div>
                        </div>
                        
                        <hr>
                        <div class="row">
                            <div class="col-md-12">
                                <p><strong>Route Details:</strong> ${data.details.route_details}</p>
                            </div>
                            <h6 class="fw-bold">Map Image</h6>
                            <div class="col-md-12 text-center">
                                <div class="card mb-3">
                                    <img src="${s3BaseUrl+data.details.map_image}" class="card-img-top img-fluid" style="height:50% !important; width:50% !important; object-fit:cover;">
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <h6 class="fw-bold">Itinerary</h6>
                            <div class="col-md-12">
                                <p>${data.details.itinerary_overview}</p>
                            </div>
                            ${data.itineraries.map((day, i) => `
                                <div class="col-md-6">
                                    <div class="card mt-3">
                                        <div class="card-header">
                                            <h6 class="mb-0">Day ${i+1}</h6>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label class="form-label">${day.title}</label>
                                            </div>
                                            <div class="mb-3">
                                                <p class="text-muted mb-1">${day.details}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `).join('')}
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="fw-bold">Inclusions</h6>
                                <p>
                                    ${data.details.includes ?? ''}
                                </p>
                            </div>
                            <div class="col-md-6">
                                <h6 class="fw-bold">Exclusions</h6>
                                <p>
                                    ${data.details.excludes ?? ''}
                                </p>
                            </div>
                        </div>
                    `;

                    $('#viewTourModal .modal-body').html(body);

                    // open modal
                    $('#viewTourModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching tour details.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $(document).on('click', '.tour-faqs', function() {
            faqIndex = 0;
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let title = btn.data('title');
            let dataUrl = btn.data('url');
            
            $('#faqForm').attr('action',dataUrl);
            $.ajax({
                type: "GET",
                dataType: "json",
                url: "{{ route('admin.train-tours.index') }}", // better to point this to a dedicated faq route
                data: { id: id, faqs: 'list' },
                success: function(data) {
                    let faqs = data.faqs || [];
                    $('#faqModal .modal-title').text(title);

                    let body = `
                    <table class="table" id="faqTable">
                        <thead>
                            <tr>
                                <th>Question</th>
                                <th>Answer</th>
                                <th><button type="button" class="btn btn-sm btn-outline-success" id="addFaqRow"><i class="fas fa-plus"></button></th>
                            </tr>
                        </thead>
                        <tbody>
                    `;

                    if (faqs.length > 0) {
                        $.each(faqs, function(index, faq) {
                            body += `
                                <tr class="b-none">
                                    <td><input type="text" name="faqs[${faqIndex}][question]" value="${faq.question}" class="form-control" required /></td>
                                    <td><textarea name="faqs[${faqIndex}][answer]" class="form-control">${faq.answer ?? ''}</textarea></td>
                                    <td><button type="button" class="btn btn-sm btn-outline-danger removeFaqRow"><i class="fas fa-trash"></button></td>
                                </tr>
                            `;
                            faqIndex++;
                        });
                    } else {
                        body += `
                            <tr class="b-none">
                                <td><input type="text" name="faqs[${faqIndex}][question]" class="form-control" required/></td>
                                <td><textarea name="faqs[${faqIndex}][answer]" class="form-control"></textarea></td>
                                <td></td>
                            </tr>
                        `;
                        faqIndex++;
                    }

                    body += `</tbody></table>`;

                    $('#faqModal .modal-body').html(body);

                    // open modal
                    $('#faqModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching train FAQs.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $(document).on("click", ".delete-tour", function(e) {
            e.preventDefault();
            let itemId = $(this).data("id");
            let itemUrl = $(this).data("url");
            let row = $(this).closest("tr"); // parent <tr>
            Swal.fire({
                title: "Are you sure?",
                text: "This item will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                customClass: {
                    popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                    confirmButton: 'px-4 py-2 text-white',
                    cancelButton: 'px-4 py-2 text-white'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: itemUrl,
                        success: function(res) {
                            if(res.success){
                                row.remove();
                                Swal.fire(
                                    "Deleted!",
                                    "The item has been deleted successfully.",
                                    "success"
                                );
                            }
                        },
                        error: function(xhr) {
                            toastr.error('Tour not deleted!', 'Failed');
                        }
                    });
                    
                }
            });
        });
    });
</script>


<script>
    
    document.addEventListener("DOMContentLoaded", function () {
        let cabinIndex = 0;

        $(document).on("click", ".update-cabins", function () {
            let url   = $(this).data("url");
            let train = $(this).data("id");
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            // load cabins from backend
            loadCabins(train,btn);

            // set correct form action
            $('#cabinForm').attr('action', url);
        });

        // Add new blank cabin block
        function addCabinBlock(index, cabin = null) {
            let html = `
            <div class="cabin-item border p-3 mb-3 rounded">
                ${cabin && cabin.id ? `<input type="hidden" name="cabins[${index}][id]" value="${cabin.id}">` : ""}
                <div class="d-flex justify-content-end align-items-center mb-2">
                    <button type="button" class="btn btn-danger btn-sm remove-cabin" data-id="${cabin && cabin.id ? cabin.id : '' }">
                        <i class="fas fa-trash"></i> Remove
                    </button>
                </div>
                <div class="mb-3">
                    <label class="form-label">Cabin Title<span class="required-text">*</span></label>
                    <input type="text" class="form-control" name="cabins[${index}][title]" 
                        value="${cabin ? cabin.title : ""}" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Gallery Images</label>
                    <input type="file" class="form-control gallery-input" 
                        name="cabins[${index}][images][]" accept=".webp,image/webp" multiple>
                    <div class="row mt-2 gallery" id="gallery-${index}"></div>
                    <div class="row mt-2 gallery-preview" id="gallery-preview-${index}">
                        ${
                            cabin && cabin.images
                            ? cabin.images.map(img => `
                                <div class="col-md-3 mb-2 text-center" id="image-${img.id}">
                                    <img src="${s3BaseUrl+img.image_path}" class="img-fluid rounded border mb-1" style="height:150px; object-fit:cover;">
                                    <button type="button" class="btn btn-sm btn-outline-danger delete-cabin-image" data-id="${img.id}">
                                        <i class="fas fa-trash"></i> Remove
                                    </button>
                                </div>
                            `).join("")
                            : ""
                        }
                    </div>
                </div>
            </div>
            `;
            $("#cabin-wrapper").append(html);
        }

        // Add blank cabin manually
        $("#addMoreCabin").on("click", function () {
            addCabinBlock(cabinIndex);
            cabinIndex++;
        });

        // Remove cabin block (only if more than 1)
        $(document).on("click", ".remove-cabin", function () {
            let cabinId = $(this).data("id"); // we set this in the loadCabins() builder
            if (cabinId) {
                $("#cabinForm").append(`<input type="hidden" name="deleted_cabins[]" value="${cabinId}">`);
            }
            $(this).closest(".cabin-item").remove();
        });

        // Preview newly selected images
        $(document).on("change", ".gallery-input", function () {
            let preview = $(this).closest(".mb-3").find(".gallery-preview");
            //preview.empty();

            let input = this;
            let dt = new DataTransfer(); // helper to rebuild file list

            Array.from(input.files).forEach((file, index) => {
                if (file.type === "image/webp") {
                    dt.items.add(file); // add back all files initially

                    let reader = new FileReader();
                    reader.onload = function (e) {
                        let id = "preview-" + index + "-" + Date.now();
                        preview.append(`
                            <div class="col-md-3 mb-2 text-center" id="${id}">
                                <img src="${e.target.result}" class="img-fluid rounded border mb-1" style="height:150px;">
                                <button type="button" class="btn btn-sm btn-outline-danger remove-new-image" data-index="${index}" data-id="${id}">
                                    <i class="fas fa-trash"></i> Remove
                                </button>
                            </div>
                        `);
                    };
                    reader.readAsDataURL(file);
                }
            });

            // replace files with current selection
            input.files = dt.files;
        });

        // remove button for selected (unsaved) images
        $(document).on("click", ".remove-new-image", function () {
            let input = $(this).closest(".mb-3").find(".gallery-input")[0];
            let indexToRemove = $(this).data("index");
            let containerId = $(this).data("id");

            let dt = new DataTransfer();

            Array.from(input.files).forEach((file, index) => {
                if (index !== indexToRemove) {
                    dt.items.add(file); // keep other files
                }
            });

            input.files = dt.files; // reset input
            $("#" + containerId).remove(); // remove preview
        });


        function loadCabins(train,btn) {
            
            $.ajax({
                url: "{{ route('admin.trains.index') }}", // adjust route if different
                type: "GET",
                dataType: "json",
                data:{'id':train,'cabins':'list'},
                success: function (response) {
                    if (response.status === "success") {
                        let wrapper = $("#cabin-wrapper");
                        wrapper.empty();
                        cabinIndex = 0;

                        if (response.cabins.length > 0) {
                            response.cabins.forEach((cabin, index) => {
                                addCabinBlock(index, cabin);
                                cabinIndex++;
                            });
                        } else {
                            addCabinBlock(cabinIndex);
                            cabinIndex++;
                        }

                        $("#addCabinModal").modal("show");
                    }
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                },
                error: function (xhr) {
                    console.error("Error loading cabins:", xhr.responseText);
                }
            });
        }

        // Delete existing image
        $(document).on("click", ".delete-cabin-image", function () {
            let imageId = $(this).data("id");
            let container = $("#image-" + imageId);
            $(this).text('removing.....');
            Swal.fire({
                title: "Are you sure?",
                text: "This image will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                customClass: {
                    popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                    confirmButton: 'px-4 py-2 text-white',
                    cancelButton: 'px-4 py-2 text-white'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "{{ route('admin.train.cabin.image.delete') }}",
                        type: "DELETE",
                        data:{'id':imageId},
                        success: function (res) {
                            if (res.status === "success") {
                                container.remove();
                            } else {
                                $(this).text('Remove');
                                toastr.error('Cabin image not deleted', 'Failed');
                            }
                        },
                        error: function () {
                            alert("Error deleting image.");
                        }
                    });
                }
            });
        });
    });

    $(document).on('click', '.page-meta', function() {
        let btn = $(this);
        let id = $(this).data('id');
        let dataUrl = $(this).data('url').trim();
        btn.find('.spinner-border').removeClass('d-none');
        btn.find('.icon').addClass('d-none');
        $.ajax({
            type: "GET",
            dataType: "json",
            url: dataUrl,
            success: function(data) {
                $('#page-title').text('# '+data.title+'-Meta Info');
                if(data.meta != null){
                    $('#page_meta_title').val(data.meta.meta_title);
                    $('#page_meta_description').val(data.meta.meta_description);
                    $('#page_meta_keywords').val(data.meta.meta_keywords);
                    $('#page_h1_heading').val(data.meta.h1_heading);
                    $('#page_meta_details').val(data.meta.meta_details);
                }
                $('#pageMetaModal').modal('show');
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred while fetching city details.'
                });
            },
            complete: function () {
                // Hide loader, show button text back
                btn.find('.spinner-border').addClass('d-none');
                btn.find('.icon').removeClass('d-none');
            }
        });
    });

    $(document).on('click', '.train-meta', function() {
        let btn = $(this);
        let id = $(this).data('id');
        let dataUrl = $(this).data('url').trim();
        let dataupUrl = $(this).data('upurl').trim();
        btn.find('.spinner-border').removeClass('d-none');
        btn.find('.icon').addClass('d-none');
        $.ajax({
            type: "GET",
            dataType: "json",
            url: dataUrl,
            success: function(data) {
                $('#train-title').text('# '+data.title+'-Meta Info');
                if(data.meta != null){
                    $('#train_meta_title').val(data.meta.meta_title);
                    $('#train_meta_description').val(data.meta.meta_description);
                    $('#train_meta_keywords').val(data.meta.meta_keywords);
                    $('#train_h1_heading').val(data.meta.h1_heading);
                    $('#train_meta_details').val(data.meta.meta_details);
                }
                $('#trainMeta').attr('action',dataupUrl);
                $('#trainMetaModal').modal('show');
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred while fetching city details.'
                });
            },
            complete: function () {
                // Hide loader, show button text back
                btn.find('.spinner-border').addClass('d-none');
                btn.find('.icon').removeClass('d-none');
            }
        });
    });

    $(document).on('click', '.train-tour-meta', function() {
        let btn = $(this);
        let id = $(this).data('id');
        let dataUrl = $(this).data('url').trim();
        let dataupUrl = $(this).data('upurl').trim();
        btn.find('.spinner-border').removeClass('d-none');
        btn.find('.icon').addClass('d-none');
        $.ajax({
            type: "GET",
            dataType: "json",
            url: dataUrl,
            success: function(data) {
                $('#train-title').text('# '+data.title+'-Meta Info');
                if(data.meta != null){
                    $('#train_tour_meta_title').val(data.meta.meta_title);
                    $('#train_tour_meta_description').val(data.meta.meta_description);
                    $('#train_tour_meta_keywords').val(data.meta.meta_keywords);
                    $('#train_tour_h1_heading').val(data.meta.h1_heading);
                    $('#train_tour_meta_details').val(data.meta.meta_details);
                }
                $('#trainTourMeta').attr('action',dataupUrl);
                $('#trainTourMetaModal').modal('show');
            },
            error: function(jqXHR, textStatus, errorThrown) {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'An error occurred while fetching city details.'
                });
            },
            complete: function () {
                // Hide loader, show button text back
                btn.find('.spinner-border').addClass('d-none');
                btn.find('.icon').removeClass('d-none');
            }
        });
    });
</script>

@endsection