@section('title','Settings')
@extends('layouts.app')
@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h2">
                    <i class="fas fa-image me-2"></i>Promotional Settings
                </h1>
            </div>
        </div>
    </div>
     <!-- Action Buttons -->
    <div class="row mb-4">
        <div class="col-12">
            <button class="btn btn-success" onclick="addPromotionalAds();">
                <i class="fas fa-plus me-2"></i>Add Promotional Ads.
            </button>
        </div>
    </div>

    <div class="row tab_details" id="tpromotional_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-image me-2"></i>Ads.
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Title</th>
                                    <th>Type</th>
                                    <th>Link</th>
                                    <th>Image</th>
                                    <th>Description</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($ads as $key => $s)
                                <tr>
                                    <td>
                                        <strong class="text-primary d-block">{{$s->title}}</strong>
                                    </td>
                                    <td>
                                        {{$s->type == 2 ? 'International' : 'National' }}
                                    </td>
                                    <td>
                                        {{$s->link}}
                                    </td>
                                    <td>
                                        {{$s->details}}
                                    </td>
                                    <td>
                                        <div class="card mb-3">
                                            <img id="page-promotional-image" src="{{ storage_link($s->banner_image) }}" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                        </div>
                                    </td>
                                    <td>
                                        <input id="promotional_status_{{$s->id }}" type="checkbox" data-id="{{$s->id }}" data-url="{{ route('admin.promotional-ads.update',$s->id) }}" class="js-switch promotional-status" <?php echo $s->is_active == 1 ? 'checked' : '' ?>>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary edit-promotional" data-id="{{$s->id}}" data-url="{{ route('admin.promotional-ads.edit',$s->id) }}" data-upurl="{{ route('admin.promotional-ads.update',$s->id) }}">
                                            <i class="fas fa-edit icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-danger delete-promotional" data-id="{{ $s->id }}" data-url="{{ route('admin.promotional-ads.destroy',$s->id) }}">
                                            <i class="fas fa-trash icon"></i>
                                        </button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('modal')

<div class="modal fade" id="addAdsModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i><span id="modal-header-text">Add Promotional Ads</span>
                </h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="addAds" action="{{ route('admin.promotional-ads.store') }}" method="POST" enctype="multipart/form-data">
                @csrf 
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="promotional_title" class="form-label">Title</label>
                        <input type="text" class="form-control" id="promotional_title" name="title" required>
                        <div class="text-danger d-none" id="promotional-title-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="add_promotional_type" class="form-label">Type</label>
                        <select class="form-select" id="add_promotional_type" name="type" required>
                            <option value="1">National</option>
                            <option value="2">International</option>
                        </select>
                        <div class="invalid-feedback type-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="promotional_link" class="form-label">Navigate Link</label>
                        <input type="text" class="form-control" id="promotional_link" name="link" required>
                        <div class="text-danger d-none" id="promotional-link-error"></div>
                    </div>
                    <div class="row" id="promotionalPreview"></div>
                    <div class="mb-3">
                        <label for="promotional_image" class="form-label">Image</label>
                        <input type="file" class="form-control mb-2" id="promotional_image" name="banner_image" accept=".webp,image/webp" required>
                        <div class="text-danger d-none" id="promotional-image-error"></div>

                        <input type="text" class="form-control" id="promotional_image_alt" name="banner_image_alt" required placeholder="Image Alt Text">
                        <div class="text-danger d-none" id="promotional-image-alt-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="add_details" class="form-label">Description</label>
                        <textarea class="form-control" id="add_details" name="details" rows="5" required></textarea>
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning promotional-submit-btn">
                        <i class="fas fa-save me-2"></i>Save Promotional Ads
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="editAdsModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">
                    <i class="fas fa-pencil me-2"></i>Edit Promotional Ads
                </h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="editAds" data-url="" method="POST" enctype="multipart/form-data">
                @csrf 
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_promotional_title" class="form-label">Title</label>
                        <input type="text" class="form-control" id="edit_promotional_title" name="title" required>
                        <div class="text-danger d-none" id="edit-promotional-title-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_promotional_type" class="form-label">Type</label>
                        <select class="form-select" id="edit_promotional_link" name="type" required>
                            <option value="1">National</option>
                            <option value="2">International</option>
                        </select>
                        <div class="invalid-feedback type-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_promotional_link" class="form-label">Navigate Link</label>
                        <input type="text" class="form-control" id="edit_promotional_link" name="link" required>
                        <div class="text-danger d-none" id="edit-promotional-link-error"></div>
                    </div>
                    <div class="row" id="promotionalPreviewEdit">
                        <div class="col-md-12">
                            <div class="card mb-3">
                                <img id="edit-promotional-image" src="" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_promotional_image" class="form-label">Image</label>
                        <input type="file" class="form-control mb-2" id="edit_promotional_image" name="banner_image" accept=".webp,image/webp">
                        <div class="text-danger d-none" id="edit-promotional-image-error"></div>

                        <input type="text" class="form-control" id="edit_promotional_image_alt" name="banner_image_alt" required placeholder="Image Alt Text">
                        <div class="text-danger d-none" id="edit_promotional-image-alt-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_details" class="form-label">Description</label>
                        <textarea class="form-control" id="edit_details" name="details" rows="5" required></textarea>
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning edit-promotional-submit-btn">
                        <i class="fas fa-save me-2"></i>Save Promotional Ads
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>

    function addPromotionalAds() {
        let oldInput = document.querySelector('.static-input');
        if (oldInput) {
            oldInput.remove();
        }

        let promotionalModal = new bootstrap.Modal(document.getElementById('addAdsModal'));
        promotionalModal.show();
    }

    

    $(document).ready(function () {
        @if(session('success'))
            toastr.success("{{ session('success') }}", 'Success');
        @endif

        $(document).on('change', '.promotional-status', function() {
            let checkbox = $(this);
            let promotional_status = checkbox.prop('checked') === true ? 1 : 0;
            $.ajax({
                type: "PUT",
                dataType: "json",
                url: $(this).data('url'),
                data: {
                    'status': promotional_status
                },
                success: function(data) {
                    Swal.fire({
                        icon: data.status,
                        title: data.status,
                        text: data.message
                    });
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    checkbox.prop('checked', !promotional_status);
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while processing your request.'
                    });
                }

            });
        });

        document.getElementById('promotional_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = event.target.files[0];
            let preview = document.getElementById('promotionalPreview');
            

            if (file && file.type === 'image/webp') {
                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; // Clear old preview
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid 
                preview.innerHTML = ""; // Clear old preview
            }
        });


        $(document).on('click', '.edit-promotional', function () {
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let dataUrl = $(this).data('url');
            let dataupUrl = $(this).data('upurl');
            $.ajax({
                url: dataUrl,
                type: 'GET',
                success: function (data) {
                    $('#edit_promotional_link').val(data.link);
                    $('#edit_promotional_title').val(data.title);
                    $('#edit_promotional_type').val(data.type);
                    $('#edit_details').val(data.details);
                    $('#edit_promotional_image_alt').val(data.banner_image_alt);
                    $('#edit-promotional-image').attr('src',s3BaseUrl+data.banner_image);
                    $('#editAds').attr('data-url',dataupUrl);
                    $('#editAdsModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching promotional ads. details.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $('#editAds').on('submit', function(e) {
            e.preventDefault();
            $('.edit-promotional-submit-btn').attr('disabled',true);
            $('.text-danger').addClass('d-none');
            let formData = new FormData(this);
            $.ajax({
                type: "POST",
                url: $(this).data('url'),
                data: formData,
                contentType: false,  // must be false for FormData
                processData: false,
                success: function(response) {
                    $('#editAds')[0].reset();
                    $('.edit-promotional-submit-btn').removeAttr('disabled');
                    $('#editAdsModal').modal('hide');
                    toastr.success('Promotional Ads updated successfully!', 'Success');
                    $('.text-danger').addClass('d-none');
                    setTimeout(function(){
                        location.reload();
                    }, 1000);
                },
                error: function(xhr) {
                    $('.edit-promotional-submit-btn').removeAttr('disabled');
                    if(xhr.status === 422) {
                        let errors = xhr.responseJSON.errors;
                        if (errors.title) $('#edit-promotional-title-error').text(errors.title[0]);
                        if (errors.link) $('#edit-promotional-package-id-error').text(errors.link[0]);
                        if (errors.banner_image) $('#edit-promotional-image-error').text(errors.package_id[0]);
                        $('.text-danger').removeClass('d-none');
                    }
                }
            });
        });

        $(document).on("click", ".delete-promotional", function(e) {
            e.preventDefault();
            let itemId = $(this).data("id");
            let itemUrl = $(this).data("url");
            let row = $(this).closest("tr"); // parent <tr>
            Swal.fire({
                title: "Are you sure?",
                text: "This item will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                customClass: {
                    popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                    confirmButton: 'px-4 py-2 text-white',
                    cancelButton: 'px-4 py-2 text-white'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: itemUrl,
                        success: function(res) {
                            if(res.success){
                                row.remove();
                                Swal.fire(
                                    "Deleted!",
                                    "The item has been deleted successfully.",
                                    "success"
                                );
                            }
                        },
                        error: function(xhr) {
                            toastr.error('Promotional Ads not deleted!', 'Failed');
                        }
                    });
                    
                }
            });
        });

        document.getElementById('edit_promotional_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = event.target.files[0];
            let preview = document.getElementById('promotionalPreviewEdit');
            

            if (file && file.type === 'image/webp') {
                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; // Clear old preview
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }
        });

    });
</script>
@endsection