@section('title','Car')
@extends('layouts.app')
@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h2">
                    <i class="fas fa-cog me-2"></i>Car Page Settings
                </h1>
            </div>
        </div>
    </div>
     <!-- Action Buttons -->
    <div class="row mb-4">
        <div class="col-12">
            <button class="btn btn-primary" onclick="addCarCategory();">
                <i class="fas fa-plus me-2"></i>Add Car Category
            </button>
            <button class="btn btn-success" onclick="addCar();">
                <i class="fas fa-plus me-2"></i>Add Car
            </button>
            <button class="btn btn-warning" onclick="addRoute();">
                <i class="fas fa-plus me-2"></i>Add Route
            </button>
        </div>
    </div>
    
    <!-- Inquiry Type Tabs -->
    <div class="row mb-3">
        <div class="col-12">
            <ul class="nav nav-pills">
                <li class="nav-item">
                    <a class="nav-link tab_link {{ (session('active_tab') && session('active_tab') == 'car_page') ? 'active' :'' }} {{ !session('active_tab') ? 'active' : ''  }}"  data-tab="car_page_tab">
                        <i class="fas fa-cog me-1"></i>Car Page Info
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link tab_link {{ (session('active_tab') && session('active_tab') == 'category_list') ? 'active' :'' }}" data-tab="car_category_tab">
                        <i class="fas fa-list me-1"></i>Car Categories
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link tab_link {{ (session('active_tab') && session('active_tab') == 'car_list') ? 'active' :'' }}" data-tab="car_list_tab">
                        <i class="fas fa-car me-1"></i>Car List
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link tab_link {{ (session('active_tab') && session('active_tab') == 'route_list') ? 'active' :'' }}" data-tab="route_list_tab">
                        <i class="fas fa-road me-1"></i>Route List
                    </a>
                </li>
            </ul>
        </div>
    </div>
    
    <div class="row tab_details {{ (session('active_tab') && session('active_tab') != 'car_page') ? 'd-none' :'' }}" id="car_page_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-cog me-2"></i>Page Details
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>
                                        <strong>{{$page_details->title}}</strong>
                                    </td>
                                    <td>
                                        {!! \Illuminate\Support\Str::words($page_details->description, 10, '...') !!}

                                    </td>
                                    <td>
                                        <div class="card mb-3">
                                            <img id="page-banner-image" src="{{ storage_link($page_details->banner_image) }}" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                        </div>
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editPageModal">
                                            <i class="fas fa-edit icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-primary page-faqs" data-id="{{$page_details->id}}"  data-url="{{ route('admin.page.faqUpdate',$page_details->id) }}">
                                            <i class="fa fa-question-circle icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        <button class="btn btn-sm btn-outline-primary page-meta" data-id="{{$page_details->id}}" data-url="{{ route('admin.page-meta.show.meta',$page_details->id) }}">
                                            <i class="fas fa-globe icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row tab_details {{ (session('active_tab') && session('active_tab') == 'category_list') ? '' :'d-none' }}" id="car_category_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-list me-2"></i>Car Categories
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($categories as $category)
                                    <tr>
                                        <td>
                                            <strong class="text-primary d-block">{{ $category->name }}</strong>
                                        </td>
                                        <td>
                                            <input id="status_{{$category->id }}" type="checkbox" data-id="{{$category->id }}" data-url="{{ route('admin.car-categories.update',$category->id) }}" class="js-switch category-status" <?php echo $category->is_active == 1 ? 'checked' : '' ?>>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-success category-edit" data-id="{{$category->id}}" data-url="{{ route('admin.car-categories.show',$category->id) }}" data-udurl="{{ route('admin.car-categories.update',$category->id) }}">
                                                <i class="fas fa-edit icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-danger delete-category" data-id="{{ $category->id }}" data-url="{{ route('admin.car-categories.destroy',$category->id) }}">
                                                <i class="fas fa-trash icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row tab_details {{ (session('active_tab') && session('active_tab') == 'car_list') ? '' :'d-none' }}" id="car_list_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-car me-2"></i>Cars
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Title</th>
                                    <th>Category</th>
                                    <th>Type</th>
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($cars as $car)
                                    <tr>
                                        <td>
                                            <strong class="text-primary d-block">{{ $car->title }}</strong>
                                            <small class="text-muted">
                                                Seats : {{ $car->seats }}
                                            </small>
                                        </td>
                                        <td>
                                            {{ $car->category->name}}
                                        </td>
                                        <td>
                                            {{ $car->type}}
                                        </td>
                                        <td>
                                            <div class="card mb-3">
                                                <img id="page-banner-image" src="{{ storage_link($car->primary_image) }}" class="card-img-top img-fluid" style="height:50px; object-fit:cover;">
                                            </div>
                                        </td>
                                        <td>
                                            <input id="status_{{$car->id }}" type="checkbox" data-id="{{$car->id }}" data-url="{{ route('admin.cars.update',$car->id) }}" class="js-switch car-status" <?php echo $car->is_active == 1 ? 'checked' : '' ?>>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-success car-edit" data-id="{{$car->id}}" data-url="{{ route('admin.cars.show',$car->id) }}" data-udurl="{{ route('admin.cars.update',$car->id) }}">
                                                <i class="fas fa-edit icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-danger delete-car" data-id="{{ $car->id }}" data-url="{{ route('admin.cars.destroy',$car->id) }}">
                                                <i class="fas fa-trash icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row tab_details {{ (session('active_tab') && session('active_tab') == 'route_list') ? '' :'d-none' }}" id="route_list_tab">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-warning text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-road me-2"></i>Routes
                    </h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Source City</th>
                                    <th>Destination City</th>
                                    <th>Url</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($car_routes as $route)
                                    <tr>
                                        <td>
                                            {{ $route->from_location }}
                                        </td>
                                        <td>
                                            {{ $route->to_location }}
                                        </td>
                                        <td>
                                            {{ $route->slug }}
                                        </td>
                                        <td>
                                            <input id="status_{{$route->id }}" type="checkbox" data-id="{{$route->id }}" data-url="{{ route('admin.car-routes.update',$route->id) }}" class="js-switch route-status" <?php echo $route->is_active == 1 ? 'checked' : '' ?>>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-success route-edit" data-id="{{$route->id}}" data-url="{{ route('admin.car-routes.show',$route->id) }}" data-udurl="{{ route('admin.car-routes.update',$route->id) }}">
                                                <i class="fas fa-edit icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-primary add-route-page-details" data-id="{{$route->id}}" data-url="{{ route('admin.car-routes.update',$route->id) }}" data-eurl="{{ route('admin.car-routes-page.show.page',$route->id) }}">
                                                <i class="fas fa-cog icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-success route-car" data-id="{{$route->id}}" data-url="{{ route('admin.car-routes.cars',$route->id) }}">
                                                <i class="fas fa-car icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-primary route-faqs" data-id="{{$route->id}}"  data-url="{{ route('admin.car-routes.faqUpdate',$route->id) }}">
                                                <i class="fa fa-question-circle icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-primary car-route-meta" data-id="{{$route->id}}" data-upurl="{{ route('admin.car-routes.update',$route->id) }}" data-url="{{ route('admin.car-routes-meta.show.meta',$route->id) }}">
                                                <i class="fa fa-globe icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                            <button class="btn btn-sm btn-outline-danger delete-route" data-id="{{ $route->id }}" data-url="{{ route('admin.car-routes.destroy',$route->id) }}">
                                                <i class="fas fa-trash icon"></i>
                                                <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @include('admin.common.pagination', ['paginator' => $car_routes])
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('modal')

<div class="modal fade" id="editPageModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-pencil me-2"></i>Edit Car Page
                </h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="editPage" method="POST" action="{{ route('admin.page.update',$page_details->id) }}" enctype="multipart/form-data">
                @csrf 
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_page_title" class="form-label">Title</label>
                        <input type="text" class="form-control" id="edit_page_title" name="title" value="{{ old('title',$page_details->title) }}" required>
                    </div>
                    <div class="row" id="praimaryPreview">
                        <div class="col-md-12">
                            <div class="card mb-3">
                                <img id="edit-banner-image" src="{{ storage_link($page_details->banner_image) }}" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <input type="text" class="form-control mb-2" id="edit_banner_image_alt" name="banner_image_alt" required placeholder="Banner Image Alt Text" value="{{ old('banner_image_alt',$page_details->banner_image_alt) }}">
                        <div class="text-danger d-none" id="edit-banner-image-alt-error"></div>
                        <label for="edit_banner_image" class="form-label">Image(accept only .webp)</label>
                        <input type="file" class="form-control" id="edit_banner_image" name="banner_image" accept=".webp,image/webp">
                        <div class="text-danger d-none" id="edit-banner-image-error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control tinymce" 
                        id="description" name="description" rows="5">
                            {{ old('description',$page_details->description) }}
                        </textarea>
                        <div class="invalid-feedback"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="submit-btn">
                        <i class="fas fa-save me-2"></i>Update Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="faqModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="city-title">Faqs</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="faqForm" method="POST" action="" enctype="multipart/form-data">
            @csrf 
            @method('PUT')
                <div class="modal-body"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-page-setting-btn" data-url="">
                        <i class="fas fa-save me-2"></i>Save Faqs
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="pageMetaModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="page-title">Edit Meta Info</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="pageMeta" method="POST" action="{{ route('admin.page.update',$page_details->id) }}" enctype="multipart/form-data">
            @csrf 
            @method('PUT')
                <div class="modal-body">
                    <input type="hidden" name="meta_setting">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_title" class="form-label">Meta Title<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_title" name="meta_title" required>
                                <div class="text-danger d-none" id="page-meta-title-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_description" class="form-label">Meta Description<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_description" name="meta_description" required>
                                <div class="text-danger d-none" id="page-meta-description-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_meta_keywords" class="form-label">Meta Keywords<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_meta_keywords" name="meta_keywords" required>
                                <div class="text-danger d-none" id="page-meta-keyords-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="page_h1_heading" class="form-label">H1 Heading<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="page_h1_heading" name="h1_heading" required>
                                <div class="text-danger d-none" id="page-meta-keyords-error"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-3">
                            <label for="page_meta_details" class="form-label">Extra Meta Tag<span class="required-text">*</span></label>
                            <textarea class="form-control"  name="meta_details" id="page_meta_details" rows="5" id="meta_details"></textarea>
                            <div class="text-danger d-none" id="page-meta-details-error"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-page-meta-btn">
                        <i class="fas fa-save me-2"></i>Update Meta Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="addCategoryModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i>Add New Car Category
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="addCategoryForm" method="POST" action="{{ route('admin.car-categories.store') }}" enctype="multipart/form-data">
                @csrf 
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="add_category_title" class="form-label">Name<span class="required-text">*</span></label>
                        <input type="text" class="form-control" id="add_category_title" name="name" required>
                        <div class="invalid-feedback title-error"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning rounded-md" id="add-submit-btn">
                        <i class="fas fa-plus me-2"></i>Add Category
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="editCategoryModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-pencil me-2"></i>Edit Car Category
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <input type="hidden" id="category_id">
            <form id="editCategoryForm" method="POST"  enctype="multipart/form-data">
                @csrf 
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_category_title" class="form-label">Name<span class="required-text">*</span></label>
                        <input type="text" class="form-control" id="edit_category_title" name="name" required>
                        <div class="invalid-feedback title-error"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning rounded-md" id="edit-submit-btn">
                        <i class="fas fa-save me-2"></i>Update Category
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="addCarModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i>Add New Car
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="addCarForm" method="POST" action="{{ route('admin.cars.store') }}" enctype="multipart/form-data">
                @csrf 
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="add_car_title" class="form-label">Title<span class="required-text">*</span></label>
                        <input type="text" class="form-control" id="add_car_title" name="title" required>
                        <div class="invalid-feedback title-error"></div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="add_category_id" class="form-label">Category</label>
                            <select class="form-select" id="add_category_id" name="category_id" required>
                                <option value="">Select</option>
                                @foreach($categories as $c)
                                    <option data-slug="{{$c->slug}}" value="{{ $c->id }}">{{ $c->name }}</option>
                                @endforeach
                            </select>
                            <div class="invalid-feedback category-error"></div>
                        </div>
                        <div class="col-md-4">
                            <label for="add_type" class="form-label">Fleet Type</label>
                            <select class="form-select" id="add_type" name="type" required>
                                <option value="">Select</option>
                                @foreach(getFleetType() as $t)
                                    <option  value="{{ $t }}">{{ $t }}</option>
                                @endforeach
                            </select>
                            <div class="invalid-feedback type-error"></div>
                        </div>
                        <div class="col-md-4">
                            <label for="add_car_seats" class="form-label">No. Of Seats</label>
                            <input type="number" class="form-control" id="add_car_seats" name="seats" max="100" min="1" required>
                            <div class="invalid-feedback seats-error"></div>
                        </div>
                    </div>
                    <div class="row mb-3" id="addPrimaryImagePreview"></div>
                    <div class="mb-2">
                        <label for="add_primary_image" class="form-label">Primary Image<span class="required-text">*</span> (accept only .webp)</label>
                        <input type="file" class="form-control" id="add_primary_image" name="primary_image" accept=".webp,image/webp" required>
                        <div class="invalid-feedback primary-image-error"></div>
                    </div>
                    <div class="mb-3">
                        <input type="text"  class="form-control mb-2"  id="add_primary_image_alt" name="primary_image_alt" 
                        value="" required placeholder="Primary Image Alt Text" >
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success rounded-md" id="add-car-submit-btn">
                        <i class="fas fa-plus me-2"></i>Add Car
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="editCarModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-edit me-2"></i>Edit Car
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <input type="hidden" id="car_id" name="id">
            <form id="editCarForm" method="POST" action="" enctype="multipart/form-data">
                @csrf 
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_car_title" class="form-label">Title</label>
                        <input type="text" class="form-control" id="edit_car_title" name="title" required>
                        <div class="invalid-feedback title-error"></div>
                    </div>
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <label for="edit_category_id" class="form-label">Category</label>
                            <select class="form-select" id="edit_category_id" name="category_id" required>
                                <option value="">Select</option>
                                @foreach($categories as $c)
                                    <option data-slug="{{$c->slug}}" value="{{ $c->id }}">{{ $c->name }}</option>
                                @endforeach
                            </select>
                            <div class="invalid-feedback category-error"></div>
                        </div>
                        <div class="col-md-4">
                            <label for="edit_type" class="form-label">Fleet Type</label>
                            <select class="form-select" id="edit_type" name="type" required>
                                <option value="">Select</option>
                                @foreach(getFleetType() as $t)
                                    <option  value="{{ $t }}">{{ $t }}</option>
                                @endforeach
                            </select>
                            <div class="invalid-feedback type-error"></div>
                        </div>
                        <div class="col-md-4">
                            <label for="edit_car_seats" class="form-label">No. Of Seats</label>
                            <input type="number" class="form-control" id="edit_car_seats" name="seats" max="100" min="1" required>
                            <div class="invalid-feedback seats-error"></div>
                        </div>
                    </div>
                    <div class="row mb-3" id="editPrimaryImagePreview">
                        <div class="col-md-12">
                            <div class="card">
                                <img src="" class="card-img-top img-fluid"  style="height:150px; object-fit:cover;" id="edit_primary_image_preview">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <input type="text"  class="form-control mb-2"  id="edit_primary_image_alt" name="primary_image_alt" value="" required placeholder="Primary Image Alt Text" >
                        <label for="edit_primary_image" class="form-label">Primary Image<span class="required-text">*</span> (accept only .webp)</label>
                        <input type="file" class="form-control" id="edit_primary_image" name="primary_image" accept=".webp,image/webp">
                        <div class="invalid-feedback primary-image-error"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning rounded-md" id="edit-car-submit-btn">
                        <i class="fas fa-edit me-2"></i>Update Car
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="addRouteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i>Add New Route
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="addRouteForm" method="POST" action="{{ route('admin.car-routes.store') }}" enctype="multipart/form-data">
                @csrf 
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="add_from_location" class="form-label">Source City</label>
                        <input type="text" class="form-control from_location" id="add_from_location" name="from_location" required>
                    </div>
                    <div class="mb-3">
                        <label for="add_to_location" class="form-label">Destination City</label>
                        <input type="text" class="form-control to_location" id="add_to_location" name="to_location" required>
                    </div>
                    <div class="invalid-feedback location-error"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning rounded-md" id="add-route-submit-btn">
                        <i class="fas fa-plus me-2"></i>Add Route
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="editRouteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-edit me-2"></i>Edit Route
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="editRouteForm" method="POST" action="" enctype="multipart/form-data">
                @csrf 
                @method('PUT')
                <input type="hidden" id="id" name="id">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="edit_from_location" class="form-label">Source City</label>
                        <input type="text" class="form-control to_location" id="edit_from_location" name="from_location" required>
                    </div>
                    <div class="mb-3">
                        <label for="edit_to_location" class="form-label">Destination City</label>
                        <input type="text" class="form-control to_location" id="edit_to_location" name="to_location" required>
                    </div>
                    <div class="invalid-feedback location-error"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning rounded-md" id="edit-route-submit-btn">
                        <i class="fas fa-edit me-2"></i>Update Route
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="routeCarModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-edit me-2"></i>Sync Car Route (<span id="routeCar"></span>)
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="routeCarForm" method="POST" action="{{ route('admin.car-routes.syncCars') }}" enctype="multipart/form-data">
                @csrf 
                <input type="hidden" id="route_id" name="route_id">
                <div class="modal-body">
                    <div id="car-list"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary rounded-md" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning rounded-md" id="route-car-submit-btn">
                        <i class="fas fa-save me-2"></i>Save
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="carRouteMetaModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="car-route-title">Edit Meta Info</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="carRouteMeta" method="POST" action="" enctype="multipart/form-data">
            @csrf 
            @method('PUT')
                <div class="modal-body">
                    <input type="hidden" name="meta_setting">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="car_route_meta_title" class="form-label">Meta Title<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="car_route_meta_title" name="meta_title" required>
                                <div class="text-danger d-none" id="car-route-meta-title-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="car_route_meta_description" class="form-label">Meta Description<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="car_route_meta_description" name="meta_description" required>
                                <div class="text-danger d-none" id="car-route-meta-description-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="car_route_meta_keywords" class="form-label">Meta Keywords<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="car_route_meta_keywords" name="meta_keywords" required>
                                <div class="text-danger d-none" id="car-route-meta-keyords-error"></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="car_route_h1_heading" class="form-label">H1 Heading<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="car_route_h1_heading" name="h1_heading" required>
                                <div class="text-danger d-none" id="car-route-meta-keyords-error"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-3">
                            <label for="car_route_meta_details" class="form-label">Extra Meta Tag<span class="required-text">*</span></label>
                            <textarea class="form-control"  name="meta_details" id="car_route_meta_details" rows="5" id="meta_details"></textarea>
                            <div class="text-danger d-none" id="car-route-meta-details-error"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-car-route-meta-btn">
                        <i class="fas fa-save me-2"></i>Update Meta Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="routePageSettingModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title" id="route-title">Set Route Page Details</h5>
                <button type="button" class="btn-close btn-close-white close-modal" data-bs-dismiss="modal"></button>
            </div>
            <form id="routePageSetting" method="POST" action="" enctype="multipart/form-data">
            @csrf 
            @method('PUT')
                <div class="modal-body">
                    <input type="hidden" name="page_setting">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="route_page_title" class="form-label">Page Title<span class="required-text">*</span></label>
                                <input type="text" class="form-control" id="route_page_title" name="title" required>
                                <div class="text-danger d-none" id="route-page-title-error"></div>
                            </div>
                        </div>
                    </div>
                    <div class="row" id="galleryPreviewRoute"></div>
                    <div class="row">
                        <div class="mb-3">
                            <label for="route_page_banner" class="form-label">Page Banner</label>
                            <input type="file" class="form-control" id="route_page_banner" accept=".webp,image/webp" name="banner_image" required>
                            <div class="text-danger d-none" id="route-page-banner-error"></div>
                        </div>
                        <div class="mb-3">
                            <label for="route_page_banner_alt" class="form-label">Banner image Alt</label>
                            <input type="text" class="form-control" id="route_page_banner_alt" name="banner_image_alt" required>
                            <div class="text-danger d-none" id="route-page-banner-alt-error"></div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="mb-3">
                            <label for="route_page_about" class="form-label">Page About<span class="required-text">*</span></label>
                            <textarea class="form-control tinymce"  name="description" id="route_page_about" rows="5" id="about"></textarea>
                            <div class="text-danger d-none" id="route-page-about-error"></div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondaryclose-modal close-modal" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-warning" id="update-route-page-setting-btn" data-url="">
                        <i class="fas fa-save me-2"></i>Update Setting
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
    let faqIndex = 0;
    let selectedFiles = [];
    let imageCounter = 0;

    function activeTab(ele){
        // Remove active from all nav links
        let nav = document.querySelectorAll('.tab_link');
        nav.forEach(function(element) {
            element.classList.remove('active');
            if (element.getAttribute('data-tab') === ele) {
                element.classList.add('active');
            }
        });

        // Hide all tabs
        let tab = document.querySelectorAll('.tab_details');
        tab.forEach(function(element) {
            element.classList.add('d-none');
        });

        let selectTab = document.getElementById(ele);
        if (selectTab) {
            selectTab.classList.remove('d-none');
        }
    }
    

    function addCarCategory() {
        activeTab('car_category_tab');
        let oldInput = document.querySelector('.static-input');
        if (oldInput) {
            oldInput.remove();
        }
        let dealModal = new bootstrap.Modal(document.getElementById('addCategoryModal'));
        dealModal.show();
    }

    function addCar() {
        activeTab('car_list_tab');
        let oldInput = document.querySelector('.static-input');
        if (oldInput) {
            oldInput.remove();
        }
        let dealModal = new bootstrap.Modal(document.getElementById('addCarModal'));
        dealModal.show();
    }

    function addRoute() {
        activeTab('route_list_tab');
        let oldInput = document.querySelector('.static-input');
        if (oldInput) {
            oldInput.remove();
        }
        let dealModal = new bootstrap.Modal(document.getElementById('addRouteModal'));
        dealModal.show();
    }



    $(document).ready(function () {
        @if(session('success'))
            toastr.success("{{ session('success') }} ", 'Success');
        @endif

        $(document).on('click', '.tab_link', function() {
            $('.tab_link').removeClass('active');
            $(this).addClass('active');
            $('.tab_details').addClass('d-none');
            let ele = $(this).data('tab');
            $('#'+ele).removeClass('d-none');
        });


        document.getElementById('editPage').addEventListener('submit', function(event) {
            tinymce.triggerSave();
            event.preventDefault(); 
            $('.invalid-feedback').addClass('d-none');
            $('#submit-btn').prop('disabled',true);
            let isError = 0;
            let description = document.getElementById('description');
            if(!description.value.trim()) {
                $('.invalid-feedback').removeClass('d-none');
                $('.invalid-feedback').addClass('d-block');
                $('.invalid-feedback').text('Descriptions required');
                $('#submit-btn').prop('disabled',false);
            } else {
                this.submit();
            }

        });

        /* ==== Primary Image Preview ==== */
        document.getElementById('edit_banner_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = event.target.files[0];
            let preview = document.getElementById('praimaryPreview');
            

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && (file.type === 'image/webp')) {
                dt.items.add(file); // Keep valid file
                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; // Clear old preview
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }
            input.files = dt.files;
        });

        $(document).on('click', '.page-faqs', function() {
            faqIndex = 0;
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let dataUrl = btn.data('url');
            
            $('#faqForm').attr('action',dataUrl);
            $.ajax({
                type: "GET",
                dataType: "json",
                url: "{{ route('admin.page.faq') }}", // better to point this to a dedicated faq route
                data: { id: id },
                success: function(data) {
                    let faqs = data.faqs || [];
                    let body = `
                    <table class="table" id="faqTable">
                        <thead>
                            <tr>
                                <th>Question</th>
                                <th>Answer</th>
                                <th><button type="button" class="btn btn-sm btn-outline-success" id="addFaqRow"><i class="fas fa-plus"></button></th>
                            </tr>
                        </thead>
                        <tbody>
                    `;

                    if (faqs.length > 0) {
                        $.each(faqs, function(index, faq) {
                            body += `
                                <tr class="b-none">
                                    <td><input type="text" name="faqs[${faqIndex}][question]" value="${faq.question}" class="form-control" required /></td>
                                    <td><textarea name="faqs[${faqIndex}][answer]" class="form-control">${faq.answer ?? ''}</textarea></td>
                                    <td><button type="button" class="btn btn-sm btn-outline-danger removeFaqRow"><i class="fas fa-trash"></button></td>
                                </tr>
                            `;
                            faqIndex++;
                        });
                    } else {
                        body += `
                            <tr class="b-none">
                                <td><input type="text" name="faqs[${faqIndex}][question]" class="form-control" required/></td>
                                <td><textarea name="faqs[${faqIndex}][answer]" class="form-control"></textarea></td>
                                <td></td>
                            </tr>
                        `;
                        faqIndex++;
                    }

                    body += `</tbody></table>`;

                    $('#faqModal .modal-body').html(body);

                    // open modal
                    $('#faqModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching package FAQs.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $(document).on('click', '#addFaqRow', function() {
            let row = `
                <tr class="b-none">
                    <td><input type="text" name="faqs[${faqIndex}][question]" class="form-control" required /></td>
                    <td><textarea name="faqs[${faqIndex}][answer]" class="form-control"></textarea></td>
                    <td><button type="button" class="btn btn-sm btn-outline-danger removeFaqRow"><i class="fas fa-trash"></button></td>
                </tr>`;
            faqIndex++;
            $('#faqTable tbody').append(row);
            
        });

        $(document).on('click', '.removeFaqRow', function() {
            $(this).closest('tr').remove();
        });

        $(document).on('click', '.page-meta', function() {
            let btn = $(this);
            let id = $(this).data('id');
            let dataUrl = $(this).data('url').trim();
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            $.ajax({
                type: "GET",
                dataType: "json",
                url: dataUrl,
                success: function(data) {
                    $('#page-title').text('# '+data.title+'-Meta Info');
                    if(data.meta != null){
                        $('#page_meta_title').val(data.meta.meta_title);
                        $('#page_meta_description').val(data.meta.meta_description);
                        $('#page_meta_keywords').val(data.meta.meta_keywords);
                        $('#page_h1_heading').val(data.meta.h1_heading);
                        $('#page_meta_details').val(data.meta.meta_details);
                    }
                    $('#pageMetaModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching city details.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        document.getElementById('addCategoryForm').addEventListener('submit', function(event) {
            event.preventDefault(); 
            $('.invalid-feedback').hide();
            $('#add-submit-btn').prop('disabled',true);
            let form = this;
            let title = document.getElementById('add_category_title').value.trim();
            $.ajax({
                type: "GET",
                url: "{{ route('admin.car-categories.slug.duplicate_check') }}",
                data: {'title':title},
                success: function(res) {
                    if (res.exists) {
                        $('.title-errorr').show();
                        $('.title-error').text('This category already exists');
                        $('.invalid-feedback').show();
                        $('#add-submit-btn').prop('disabled',false);
                    } else {
                        $('.title-errorr').hide();
                        form.submit();
                    }
                },
                error:function(err){
                    form.submit();
                }
            });
        });


        $(document).on('change', '.category-status', function() {
            let car_status = $(this).prop('checked') === true ? 1 : 0;
            $.ajax({
                type: "PUT",
                dataType: "json",
                url: $(this).data('url'),
                data: {
                    'status': car_status
                },
                success: function(data) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: data.message
                    });
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while processing your request.'
                    });
                }

            });
        });

        $(document).on('click', '.category-edit', function() {
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let dataurl = btn.data('url');
            let updateurl = btn.data('udurl');

            $.ajax({
                type: "GET",
                dataType: "json",
                url: dataurl,
                data: { id: id },
                success: function(data) {
                    $('#editCategoryForm').attr('action', updateurl);
                    $('#category_id').val(data.id);
                    $('#edit_category_title').val(data.name);
                    $('#editCategoryModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Note: The original code used a Swal.fire() which is a SweetAlert2 library function.
                    // If you don't have this library, you would use a standard alert or a custom modal.
                    console.error('An error occurred while fetching category details:', textStatus, errorThrown);
                    alert('An error occurred while fetching category details.');
                },
                complete: function() {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        document.getElementById('editCategoryForm').addEventListener('submit', function(event) {
            event.preventDefault(); 
            $('.invalid-feedback').hide();
            $('#edit-submit-btn').prop('disabled',true);
            
            let form = this;
            let title = document.getElementById('edit_category_title').value.trim();
            let id = document.getElementById('category_id').value.trim();
            $.ajax({
                type: "GET",
                url: "{{ route('admin.car-categories.slug.duplicate_check') }}",
                data: {'id':id,'name':title},
                success: function(res) {
                    if (res.exists) {
                        $('.invalid-feedback').show();
                        $('.title-error').text('This category already exists');
                        $('.invalid-feedback').show();
                        $('#edit-submit-btn').prop('disabled',false);
                    } else {
                        $('.invalid-feedback').hide();
                        form.submit();
                    }
                },
                error:function(err){
                    //form.submit();
                }
            });

        });

        $(document).on("click", ".delete-category", function(e) {
            e.preventDefault();
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let itemId = $(this).data("id");
            let itemUrl = $(this).data("url");
            let row = $(this).closest("tr"); // parent <tr>
            Swal.fire({
                title: "Are you sure?",
                text: "This item will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                customClass: {
                    popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                    confirmButton: 'px-4 py-2 text-white',
                    cancelButton: 'px-4 py-2 text-white'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: itemUrl,
                        success: function(res) {
                            if(res.success){
                                row.remove();
                                Swal.fire(
                                    "Deleted!",
                                    "The item has been deleted successfully.",
                                    "success"
                                );
                            }
                        },
                        error: function(xhr) {
                            toastr.error('Category not deleted!', 'Failed');
                        },
                        complete: function() {
                            // Hide loader, show button text back
                            btn.find('.spinner-border').addClass('d-none');
                            btn.find('.icon').removeClass('d-none');
                        }
                    });
                    
                }
            });
        });

        document.getElementById('add_primary_image').addEventListener('change', function(event) {
            console.log('kjiyuiyuiyuiy');
            let input = event.target;
            let file = input.files[0];
            let preview = document.getElementById('addPrimaryImagePreview');
            // Clear old preview

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && (file.type === 'image/webp')) {
                console.log('ok');
                dt.items.add(file); // Keep valid file

                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = "";
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                 console.log('nok');
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }

            // Replace with filtered file list (empty if invalid)
            input.files = dt.files;
        });

        document.getElementById('addCarForm').addEventListener('submit', function(event) {
            event.preventDefault(); 
            $('.invalid-feedback').hide();
            $('#add-car-submit-btn').prop('disabled',true);
            let form = this;
            let title = document.getElementById('add_car_title').value.trim();
            $.ajax({
                type: "GET",
                url: "{{ route('admin.cars.slug.duplicate_check') }}",
                data: {'title':title},
                success: function(res) {
                    if (res.exists) {
                        $('.title-errorr').show();
                        $('.title-error').text('This title already exists');
                        $('.invalid-feedback').show();
                        $('#add-car-submit-btn').prop('disabled',false);
                    } else {
                        $('.title-errorr').hide();
                        form.submit();
                    }
                },
                error:function(err){
                    form.submit();
                }
            });
        });
        

        $(document).on('change', '.car-status', function() {
            let car_status = $(this).prop('checked') === true ? 1 : 0;
            $.ajax({
                type: "PUT",
                dataType: "json",
                url: $(this).data('url'),
                data: {
                    'status': car_status
                },
                success: function(data) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: data.message
                    });
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while processing your request.'
                    });
                }

            });
        });

        $(document).on("click", ".delete-car", function(e) {
            e.preventDefault();
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let itemId = $(this).data("id");
            let itemUrl = $(this).data("url");
            let row = $(this).closest("tr"); // parent <tr>
            Swal.fire({
                title: "Are you sure?",
                text: "This item will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                customClass: {
                    popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                    confirmButton: 'px-4 py-2 text-white',
                    cancelButton: 'px-4 py-2 text-white'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: itemUrl,
                        success: function(res) {
                            if(res.success){
                                row.remove();
                                Swal.fire(
                                    "Deleted!",
                                    "The item has been deleted successfully.",
                                    "success"
                                );
                            }
                        },
                        error: function(xhr) {
                            toastr.error('Car not deleted!', 'Failed');
                        },
                        complete: function() {
                            // Hide loader, show button text back
                            btn.find('.spinner-border').addClass('d-none');
                            btn.find('.icon').removeClass('d-none');
                        }
                    });
                    
                }
            });
        });

        $(document).on('click', '.car-edit', function() {
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let dataurl = btn.data('url');
            let updateurl = btn.data('udurl');

            $.ajax({
                type: "GET",
                dataType: "json",
                url: dataurl,
                data: { id: id },
                success: function(data) {
                    $('#editCarForm').attr('action', updateurl);
                    $('#car_id').val(data.id);
                    $('#edit_car_title').val(data.title);
                    $('#edit_category_id').val(data.category_id);
                    $('#edit_type').val(data.type);
                    $('#edit_car_seats').val(data.seats);
                    $('#edit_primary_image_alt').val(data.primary_image_alt);
                    $('#edit_primary_image_preview').attr('src', s3BaseUrl+ data.primary_image);
                    $('#editCarModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Note: The original code used a Swal.fire() which is a SweetAlert2 library function.
                    // If you don't have this library, you would use a standard alert or a custom modal.
                    console.error('An error occurred while fetching hotel details:', textStatus, errorThrown);
                    alert('An error occurred while fetching hotel details.');
                },
                complete: function() {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        document.getElementById('edit_primary_image').addEventListener('change', function(event) {
            let input = event.target;
            let file = input.files[0];
            let preview = document.getElementById('editPrimaryImagePreview');
            // Clear old preview

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && (file.type === 'image/webp' || file.name.toLowerCase().endsWith('.webp'))) {
                dt.items.add(file); // Keep valid file

                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; 
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }

            // Replace with filtered file list (empty if invalid)
            input.files = dt.files;
        });

        document.getElementById('editCarForm').addEventListener('submit', function(event) {
            event.preventDefault(); 
            $('.invalid-feedback').hide();
            $('#edit-car-submit-btn').prop('disabled',true);
            let form = this;
            let title = document.getElementById('edit_car_title').value.trim();
            let id = document.getElementById('car_id').value.trim();
            $.ajax({
                type: "GET",
                url: "{{ route('admin.cars.slug.duplicate_check') }}",
                data: {'id':id,'title':title},
                success: function(res) {
                    if (res.exists) {
                        $('.title-errorr').show();
                        $('.title-error').text('This title already exists');
                        $('.invalid-feedback').show();
                        $('#edit-car-submit-btn').prop('disabled',false);
                    } else {
                        $('.title-errorr').hide();
                        form.submit();
                    }
                },
                error:function(err){
                    //form.submit();
                }
            });
        });
    });
</script>
<script>
    $(document).ready(function() {

        let previousFrom = null;

        /*$('.from_location').on('change', function() {
            const selectedFrom = $(this).val();
            const $cityTo = $('.to_location');

            // Step 1: Restore previously hidden option (if any)
            if (previousFrom) {
                $cityTo.find(`option[value="${previousFrom}"]`).show();
            }

            // Step 2: Hide the newly selected option
            if (selectedFrom) {
                $cityTo.find(`option[value="${selectedFrom}"]`).hide();

                // If destination is same as source, reset destination
                if ($cityTo.val() === selectedFrom) {
                    $cityTo.val('');
                }
            }

            // Step 3: Remember current selection
            previousFrom = selectedFrom;
        });*/

        document.getElementById('addRouteForm').addEventListener('submit', function(event) {
            event.preventDefault(); 
            $('.invalid-feedback').hide();
            $('#add-route-submit-btn').prop('disabled',true);
            let form = this;
            $.ajax({
                type: "GET",
                url: "{{ route('admin.car-routes.slug.duplicate_check') }}",
                data: $(form).serialize(),
                success: function(res) {
                    if (res.exists) {
                        $('.location-errorr').show();
                        $('.location-error').text('This route already exists');
                        $('.invalid-feedback').show();
                        $('#add-route-submit-btn').prop('disabled',false);
                    } else {
                        $('.location-errorr').hide();
                        form.submit();
                    }
                },
                error:function(err){
                    form.submit();
                }
            });
        });


        $(document).on('change', '.route-status', function() {
            let route_status = $(this).prop('checked') === true ? 1 : 0;
            $.ajax({
                type: "PUT",
                dataType: "json",
                url: $(this).data('url'),
                data: {
                    'status': route_status
                },
                success: function(data) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Success',
                        text: data.message
                    });
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while processing your request.'
                    });
                }

            });
        });

        $(document).on('click', '.route-edit', function() {
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let dataurl = btn.data('url');
            let updateurl = btn.data('udurl');

            $.ajax({
                type: "GET",
                dataType: "json",
                url: dataurl,
                data: { id: id },
                success: function(data) {
                    $('#editRouteForm').attr('action', updateurl);
                    $('#id').val(data.id);
                    $('#edit_from_location').val(data.from_location);
                    $('#edit_to_location').val(data.to_location);
                    //filterDestinationCities();
                    $('#editRouteModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Note: The original code used a Swal.fire() which is a SweetAlert2 library function.
                    // If you don't have this library, you would use a standard alert or a custom modal.
                    console.error('An error occurred while fetching route details:', textStatus, errorThrown);
                    alert('An error occurred while fetching route details.');
                },
                complete: function() {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        document.getElementById('editRouteForm').addEventListener('submit', function(event) {
            event.preventDefault(); 
            $('.invalid-feedback').hide();
            $('#edit-route-submit-btn').prop('disabled',true);
            
            let form = this;
            $.ajax({
                type: "GET",
                url: "{{ route('admin.car-routes.slug.duplicate_check') }}",
                data: $(form).serialize(),
                success: function(res) {
                    if (res.exists) {
                        $('.invalid-feedback').show();
                        $('.location-error').text('This route already exists');
                        $('.invalid-feedback').show();
                        $('#edit-route-submit-btn').prop('disabled',false);
                    } else {
                        $('.invalid-feedback').hide();
                        form.submit();
                    }
                },
                error:function(err){
                    //form.submit();
                }
            });

        });

        $(document).on("click", ".delete-route", function(e) {
            e.preventDefault();
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let itemId = $(this).data("id");
            let itemUrl = $(this).data("url");
            let row = $(this).closest("tr"); // parent <tr>
            Swal.fire({
                title: "Are you sure?",
                text: "This item will be deleted!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#e3342f",
                cancelButtonColor: "#6c757d",
                confirmButtonText: "Yes, delete it",
                cancelButtonText: "Cancel",
                customClass: {
                    popup: 'rounded-2xl shadow-lg',  // Rounded + shadow
                    confirmButton: 'px-4 py-2 text-white',
                    cancelButton: 'px-4 py-2 text-white'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: itemUrl,
                        success: function(res) {
                            if(res.success){
                                row.remove();
                                Swal.fire(
                                    "Deleted!",
                                    "The item has been deleted successfully.",
                                    "success"
                                );
                            }
                        },
                        error: function(xhr) {
                            toastr.error('Route not deleted!', 'Failed');
                        },
                        complete: function() {
                            // Hide loader, show button text back
                            btn.find('.spinner-border').addClass('d-none');
                            btn.find('.icon').removeClass('d-none');
                        }
                    });
                    
                }
            });
        });

        $(document).on('click', '.route-car', function() {
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let dataurl = btn.data('url');

            $.ajax({
                type: "GET",
                dataType: "json",
                url: dataurl,
                data: { id: id },
                success: function(res) {
                    $('#routeCar').text(res.route.slug);
                    $('#route_id').val(res.route.id);
                    const allCars = res.all_car;
                    let assignedCars = res.route.cars.map(c => c.id); // already assigned
                    let html = '<div class="row">';
                    allCars.forEach((car, index) => {
                        const checked = assignedCars.includes(car.id) ? 'checked' : '';
                        html += `
                            <div class="col-md-4 col-sm-4 col-6"> <!-- Adjust columns as needed -->
                                <div class="form-check">
                                    <input type="checkbox" name="car_ids[]" class="form-check-input car-checkbox" value="${car.id}" ${checked}>
                                    <label class="form-check-label">${car.title} (${car.category?.name ?? 'No Category'})</label>
                                </div>
                            </div>
                        `;
                    });
                    html += '</div>';
                    $('#car-list').html(html);
                    $('#routeCarModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Note: The original code used a Swal.fire() which is a SweetAlert2 library function.
                    // If you don't have this library, you would use a standard alert or a custom modal.
                    console.error('An error occurred while fetching route details:', textStatus, errorThrown);
                    alert('An error occurred while fetching route details.');
                },
                complete: function() {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $(document).on('click', '.car-route-meta', function() {
            let btn = $(this);
            let id = $(this).data('id');
            let dataUrl = $(this).data('url').trim();
            let dataupUrl = $(this).data('upurl').trim();
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            $.ajax({
                type: "GET",
                dataType: "json",
                url: dataUrl,
                success: function(data) {
                    $('#car-route-title').text('# Route ('+data.slug+'_-Meta Info');
                    if(data.meta != null){
                        $('#car_route_meta_title').val(data.meta.meta_title);
                        $('#car_route_meta_description').val(data.meta.meta_description);
                        $('#car_route_meta_keywords').val(data.meta.meta_keywords);
                        $('#car_route_h1_heading').val(data.meta.h1_heading);
                        $('#car_route_meta_details').val(data.meta.meta_details);
                    }
                    $('#carRouteMeta').attr('action',dataupUrl);
                    $('#carRouteMetaModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching route details.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        $(document).on('click', '.add-route-page-details', function() {
            let btn = $(this);
            let id = $(this).data('id');
            let dataUrl = $(this).data('url').trim();
            let dataeUrl = $(this).data('eurl').trim();
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            $.ajax({
                type: "GET",
                dataType: "json",
                url: dataeUrl,
                success: function(data) {
                    $('#route-title').text(data.from_location+' to '+data.to_location);
                    if(data.details != null){
                        $('#route_page_title').val(data.details.title);
                        $('#route_page_banner_alt').val(data.details.banner_image_alt);
                        tinymce.get('route_page_about').setContent(data.details.description);
                        $('#galleryPreviewRoute').html(`<div class="card mb-3">
                            <img src="${s3BaseUrl+data.details.banner_image}" class="card-img-top img-fluid" style="height:150px; object-fit:cover;">
                        </div>`);
                        $('#route_page_banner').prop('required',false);
                    }
                    $('#routePageSetting').attr('action',dataUrl);
                    $('#routePageSettingModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching country details.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

        document.getElementById('route_page_banner').addEventListener('change', function(event) {
            let input = event.target;
            let file = event.target.files[0];
            let preview = document.getElementById('galleryPreviewRoute');
            

            let dt = new DataTransfer(); // For rebuilding file list

            if (file && (file.type === 'image/webp')) {
                dt.items.add(file); // Keep valid file
                let reader = new FileReader();
                reader.onload = function(e) {
                    let col = document.createElement('div');
                    col.classList.add('col-md-12', 'mb-3');
                    col.innerHTML = `
                        <div class="card">
                            <img src="${e.target.result}" class="card-img-top img-fluid" 
                                style="height:150px; object-fit:cover;">
                        </div>
                    `;
                    preview.innerHTML = ""; // Clear old preview
                    preview.appendChild(col);
                };
                reader.readAsDataURL(file);
            } else {
                toastr.error("Only .webp images are allowed!", 'Error');
                input.value = ""; // reset invalid file
            }
            input.files = dt.files;
        });

        $(document).on('click', '.route-faqs', function() {
            faqIndex = 0;
            let btn = $(this);
            btn.find('.spinner-border').removeClass('d-none');
            btn.find('.icon').addClass('d-none');
            let id = btn.data('id');
            let dataUrl = btn.data('url');
            
            $('#faqForm').attr('action',dataUrl);
            $.ajax({
                type: "GET",
                dataType: "json",
                url: "{{ route('admin.car.routes.faq') }}", // better to point this to a dedicated faq route
                data: { id: id },
                success: function(data) {
                    let faqs = data.faqs || [];
                    let body = `
                    <table class="table" id="faqTable">
                        <thead>
                            <tr>
                                <th>Question</th>
                                <th>Answer</th>
                                <th><button type="button" class="btn btn-sm btn-outline-success" id="addFaqRow"><i class="fas fa-plus"></button></th>
                            </tr>
                        </thead>
                        <tbody>
                    `;

                    if (faqs.length > 0) {
                        $.each(faqs, function(index, faq) {
                            body += `
                                <tr class="b-none">
                                    <td><input type="text" name="faqs[${faqIndex}][question]" value="${faq.question}" class="form-control" required /></td>
                                    <td><textarea name="faqs[${faqIndex}][answer]" class="form-control">${faq.answer ?? ''}</textarea></td>
                                    <td><button type="button" class="btn btn-sm btn-outline-danger removeFaqRow"><i class="fas fa-trash"></button></td>
                                </tr>
                            `;
                            faqIndex++;
                        });
                    } else {
                        body += `
                            <tr class="b-none">
                                <td><input type="text" name="faqs[${faqIndex}][question]" class="form-control" required/></td>
                                <td><textarea name="faqs[${faqIndex}][answer]" class="form-control"></textarea></td>
                                <td></td>
                            </tr>
                        `;
                        faqIndex++;
                    }

                    body += `</tbody></table>`;

                    $('#faqModal .modal-body').html(body);

                    // open modal
                    $('#faqModal').modal('show');
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'An error occurred while fetching package FAQs.'
                    });
                },
                complete: function () {
                    // Hide loader, show button text back
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                }
            });
        });

    });

    // function filterDestinationCities() {
    //     let selectedSource = $('#edit_from_location').val();

    //     $('#edit_to_location option').each(function() {
    //         let option = $(this);

    //         // if this option value equals selected source, hide it
    //         if (option.val() == selectedSource) {
    //             option.prop('disabled', true).hide();
    //         } else {
    //             option.prop('disabled', false).show();
    //         }
    //     });
    // }
</script>

@endsection