@section('title','Tour Booking Enquiry')
@extends('layouts.app')
@section('content')
<div class="container">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h2">
                    <i class="fas fa-envelope me-2"></i>Tour Booking Enquiry
                </h1>
            </div>
        </div>
    </div>
    
    <!-- Inquiry Type Tabs -->
    <div class="row mb-3">
        <div class="col-12">
            <ul class="nav nav-pills">
                <li class="nav-item">
                    <a class="nav-link active" href="{{ route('admin.enquiries.packages') }}">
                        <i class="fas fa-map-marked-alt me-1"></i>Tour
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.enquiries.cars') }}">
                        <i class="fas fa-taxi me-1"></i>Car
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.enquiries.trains') }}">
                        <i class="fas fa-bus me-1"></i>Train
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.enquiries.hotels') }}">
                        <i class="fas fa-bed me-1"></i>Hotel
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.enquiries.customized') }}">
                        <i class="fas fa-map-marked-alt me-1"></i>Customized Tour
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.enquiries.plan.trip') }}">
                        <i class="fas fa-globe me-1"></i>Plan Trip
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.enquiries.general') }}">
                        <i class="fas fa-list me-1"></i>Custom/Genneral Enquiries
                    </a>
                </li>
            </ul>
        </div>
    </div>
    
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <tr>
                                    <th>Package</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Travellers</th>
                                    <th>Travel Month & Duration</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($enquiries as $enquiry)
                                <tr>
                                    <td>
                                        <div>
                                            <strong class="text-primary d-block package-details" data-id="{{$enquiry->package->id}}">{{ $enquiry->package->title ?? 'N/A' }}</strong>
                                            <small class="text-muted">Duration :
                                                {{ 
                                                    $enquiry->package->details->duration_days.' D/ '.$enquiry->package->details->duration_nights.' N' 
                                                }}
                                        </small>
                                        </div>
                                    </td>
                                    <td>
                                        <strong class="text-primary">{{ $enquiry->name }}</strong>
                                    </td>
                                    <td>
                                        <div>
                                            <small class="d-block">{{ $enquiry->email }}</small>
                                            <small class="text-muted">{{ $enquiry->phone }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        {{ $enquiry->no_of_travellers }}
                                    </td>
                                    <td>
                                        {{ $enquiry->month }}
                                    </td>
                                    <td>
                                        @if($enquiry->is_confirmed == 0)
                                            <span class="badge bg-warning">New</span>
                                        @elseif($enquiry->is_confirmed == 1)
                                            <span class="badge bg-success">Confirmed</span>
                                        @elseif($enquiry->is_confirmed == 2)
                                            <span class="badge bg-info">Proceeded</span>
                                        @endif
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-primary get-enquiry" data-url="{{ route('admin.enquiries.package.detail',$enquiry->id) }}" data-upurl="{{ route('admin.enquiries.package.status',$enquiry->id) }}">
                                            <i class="fas fa-eye icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        @if($enquiry->is_confirmed != 1)
                                        <button class="btn btn-sm btn-outline-success update-enquiry" data-url="{{ route('admin.enquiries.package.status',$enquiry->id) }}">
                                            <i class="fas fa-check icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                        @endif
                                        <button class="btn btn-sm btn-outline-danger delete-enquiry" data-url="{{ route('admin.enquiries.package.delete',$enquiry->id) }}">
                                            <i class="fas fa-trash icon"></i>
                                            <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                        </button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @include('admin.common.pagination', ['paginator' => $enquiries])
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('modal')
<div class="modal fade" id="viewInquiryModal1" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
    $(document).ready(function () {

    // ================== VIEW ENQUIRY ==================
    $(document).on("click", ".get-enquiry", function () {
        let btn = $(this);
        btn.find('.spinner-border').removeClass('d-none');
        btn.find('.icon').addClass('d-none');

        let url = $(this).data("url");
        let upurl = $(this).data("upurl");

        $.get(url, function (res) {
            if (res.success) {
                let data = res.data;

                // populate modal
                let modal = $("#viewInquiryModal1");

                modal.find(".modal-title").text("Enquiry #" + data.package.title);
                modal.find(".modal-body").html(`
                    <h6 class="fw-bold">Customer Information</h6>
                    <p><strong>Name:</strong> ${data.name}</p>
                    <p><strong>Email:</strong> ${data.email}</p>
                    <p><strong>Phone:</strong> ${data.phone}</p>
                    <p><strong>Country:</strong> ${data.country}</p>
                    <p><strong>City:</strong> ${data.city}</p>
                    <p><strong>No Of Travellers:</strong> ${data.no_of_travellers}</p>
                    <p><strong>Budget Per Person:</strong> ${data.per_person_budget ?? ''}</p>
                    <p><strong>Travel Month & Duration:</strong> ${data.month ?? ''}</p>
                    <p><strong>Arrival City:</strong> ${data.arrival_city ?? ''}</p>
                    <p><strong>Departure City:</strong> ${data.arrival_city ?? ''}</p>
                    <p><strong>Status:</strong> 
                        ${(() => {
                            switch (data.is_confirmed) {
                                case 0:
                                    return '<span class="badge bg-warning">New</span>';
                                case 2:
                                    return '<span class="badge bg-info">Processed</span>';
                                case 1:
                                    return '<span class="badge bg-success">Confirmed</span>';
                                default:
                                    return '<span class="badge bg-secondary">Unknown</span>';
                            }
                        })()}
                    </p>
                    <h6 class="fw-bold mt-3">Travel Requirement</h6>
                    <p class="text-muted">${data.message ?? ''}</p>
                `);
                let html = '';
                if(data.is_confirmed == 2){
                    html += `<button type="button" class="btn btn-success update-enquiry" data-url="${upurl}">Mark as Confirmed
                        <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>`;
                } else if(data.is_confirmed == 0) {
                    html += `<button type="button" class="btn btn-primary" id="p-btn" data-url="${upurl}">Mark as Processed
                        <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>`; 
                } else {
                    html+=`<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>`;
                }
                modal.find(".modal-footer").html(html);
                modal.modal("show");
            }
        }).fail(function () {
            Swal.fire("Error", "Failed to fetch enquiry details.", "error");
        }).always(function () {
            // This runs after success or failure
            btn.find('.spinner-border').addClass('d-none');
            btn.find('.icon').removeClass('d-none');
        });
    });

    // ================== UPDATE STATUS ==================
    $(document).on("click", ".update-enquiry", function () {
        let url = $(this).data("url");
        Swal.fire({
            title: "Mark as Confirmed?",
            icon: "question",
            showCancelButton: true,
            confirmButtonText: "Yes, Confirm",
            cancelButtonText: "Cancel",
        }).then((result) => {
            if (result.isConfirmed) {
                let btn = $(this);
                btn.find('.spinner-border').removeClass('d-none');
                btn.find('.icon').addClass('d-none');
                $.post(url, { _token: "{{ csrf_token() }}",status:1 }, function (res) {
                    if (res.success) {
                        Swal.fire("Updated!", "Enquiry status updated.", "success").then(() => {
                            location.reload();
                        });
                    }
                }).fail(function () {
                    Swal.fire("Error", "Failed to update status.", "error");
                }).always(function () {
                    // This runs after success or failure
                    btn.find('.spinner-border').addClass('d-none');
                    btn.find('.icon').removeClass('d-none');
                });
            }
        });
    });

    $(document).on("click", "#p-btn", function () {
        let url = $(this).data("url");
        let btn = $(this);
        btn.find('.spinner-border').removeClass('d-none');
        btn.find('.icon').addClass('d-none');
        $.post(url, { _token: "{{ csrf_token() }}",status:2 }, function (res) {
            if (res.success) {
                Swal.fire("Updated!", "Enquiry status updated.", "success").then(() => {
                    location.reload();
                });
            }
        }).fail(function () {
            Swal.fire("Error", "Failed to update status.", "error");
        }).always(function () {
            // This runs after success or failure
            btn.find('.spinner-border').addClass('d-none');
            btn.find('.icon').removeClass('d-none');
        });
    });

    // ================== DELETE ENQUIRY ==================
    $(document).on("click", ".delete-enquiry", function () {
        let url = $(this).data("url");
        Swal.fire({
            title: "Are you sure?",
            text: "This enquiry will be permanently deleted.",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#d33",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, Delete",
        }).then((result) => {
            if (result.isConfirmed) {
                let btn = $(this);
                btn.find('.spinner-border').removeClass('d-none');
                btn.find('.icon').addClass('d-none');
                $.ajax({
                    url: url,
                    type: "DELETE",
                    data: { _token: "{{ csrf_token() }}" },
                    success: function (res) {
                        if (res.success) {
                            Swal.fire("Deleted!", "Enquiry has been removed.", "success").then(() => {
                                location.reload();
                            });
                        }
                    },
                    error: function () {
                        Swal.fire("Error", "Failed to delete enquiry.", "error");
                    },
                    complete: function () {
                        // Hide loader, show button text back
                        btn.find('.spinner-border').addClass('d-none');
                        btn.find('.icon').removeClass('d-none');
                    }
                });
            }
        });
    });

});
</script>
@endsection