<?php
namespace Database\Seeders;
use Illuminate\Database\Seeder;
use App\Models\Category;
use App\Models\Country;
use App\Models\Location;
use App\Models\Package;
use App\Models\PackageDetail;
use App\Models\PackageImage;
use App\Models\User;

class DatabaseSeeder extends Seeder {
    public function run(): void {
        $admin = User::create(['name'=>'Admin','email'=>'admin@example.com','password'=>bcrypt('password'),'is_admin'=>true]);
        $cat = Category::create(['name'=>'Adventure','slug'=>'adventure']);
        $country = Country::create(['name'=>'India','code'=>'IN']);
        $loc = Location::create(['country_id'=>$country->id,'name'=>'Goa','type'=>'national']);
        $pkg = Package::create(['category_id'=>$cat->id,'location_id'=>$loc->id,'title'=>'Sample Package','slug'=>'sample-package','price'=>9999]);
        PackageDetail::create(['package_id'=>$pkg->id,'days'=>4,'nights'=>3,'itinerary'=>'Day1...','includes'=>'Breakfast','excludes'=>'Flights']);
        PackageImage::create(['package_id'=>$pkg->id,'image_path'=>'packages/sample1.jpg']);
    }
}
