<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use App\Http\Middleware\IsAdmin;
use Illuminate\Routing\Middleware\SubstituteBindings;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__ . '/../routes/web.php',
        api: __DIR__ . '/../routes/api.php',
        commands: __DIR__ . '/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware): void {
        // Route middleware aliases
        $middleware->alias([
            'auth'         => \App\Http\Middleware\Authenticate::class,
            'isadmin'      => IsAdmin::class,
            'public.token' => \App\Http\Middleware\PublicApiToken::class,
        ]);

        // API middleware group
        $middleware->api(prepend: [
            \Illuminate\Routing\Middleware\ThrottleRequests::class . ':api',
            SubstituteBindings::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions): void {
        // $exceptions->render(function (Throwable $e, $request) {
        //     // Optional: Log the exception
        //     Log::error($e);

        //     // Check if the request expects JSON
        //     if ($request->expectsJson()) {
        //         return response()->json(['message' => 'Not Found'], 404);
        //     }

        //     // Return the custom 404 view
        //     return response()->view('errors.404', [], 404);
        // });
    })
    
    ->create();
