<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TrainTour extends Model
{
    protected $table = 'train_tour';

    protected $casts = [
        'is_active' => 'boolean',
        'is_deleted' => 'boolean',
    ];

    protected $fillable = [
        'title',
        'slug',
        'train_id',
        'primary_image',
        'description',
        'refund_cancellation_policy',
        'is_active',
        'is_deleted',
    ];

    // 🔹 Corrected relation: A tour belongs to a train
    public function train()
    {
        return $this->belongsTo(Train::class, 'train_id', 'id');
    }

    public function details()
    {
        return $this->hasOne(TrainTourDetails::class, 'train_tour_id', 'id');
    }

    public function itineraries()
    { 
        return $this->hasMany(TrainTourItinerary::class, 'train_tour_id', 'id'); 
    }

    public function faqs()
    {
        return $this->hasMany(TrainTourFaq::class, 'train_tour_id', 'id');
    }

    public function enquiries()
    {
        return $this->hasMany(EnquiryTrain::class, 'train_tour_id');
    }

    public function meta()
    {
        return $this->hasOne(TrainTourMetaData::class, 'train_tour_id', 'id');
    }
}
