<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Model;

class TrainCabin extends Model {

    protected $table = 'train_cabins';

    protected $fillable = ['train_id','title','is_active','is_deleted'];

    public function train(){ 
        return $this->belongsTo(Train::class,'id','train_id'); 
    }

    public function images()
    { 
        return $this->hasMany(TrainCabinImage::class,'cabin_id','id'); 
    }
}
