<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Train extends Model
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'trains';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'title',
        'slug',
        'primary_image',
        'primary_image_alt',
        'short_description',
        'long_description',
        'destinations',
        'facilities',
        'is_active',
        'is_deleted',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_active' => 'boolean',
        'is_deleted' => 'boolean',
    ];

    public function images()
    { 
        return $this->hasMany(TrainImage::class,'train_id','id'); 
    }

    public function tours()
    { 
        return $this->hasMany(TrainTour::class,'train_id','id'); 
    }

    public function cabins()
    {
        return $this->hasMany(TrainCabin::class,'train_id','id');
    }

    public function faqs()
    {
        return $this->hasMany(TrainFaq::class,'train_id','id');
    }

    public function enquiries()
    {
        return $this->hasMany(EnquiryTrain::class, 'train_id');
    }

    public function meta()
    {
        return $this->hasOne(TrainMetaData::class, 'train_id', 'id');
    }

}
