<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    protected $table = 'pages';

    protected $fillable = [
        'id',
        'slug',
        'title',
        'description',
        'banner_image',
        'banner_image_alt'
    ];

    public function faqs()
    {
        return $this->hasMany(PageFaq::class, 'page_id', 'id');
    }

    public function meta()
    {
        return $this->hasOne(PageMetaData::class, 'page_id', 'id');
    }
}
